/*
 * Decompiled with CFR 0.152.
 */
package rockhounding.api;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import rockhounding.api.IReciperUtils;

public class IReciper
extends IReciperUtils {
    public static void sendToPollutantGases(FluidStack gas) {
        if (IReciper.isValidGas(gas)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound bathNBT = new NBTTagCompound();
            gas.writeToNBT(bathNBT);
            recipe.func_74782_a(tagInput, (NBTBase)bathNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_pollutant_gas_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromPollutantGases(FluidStack gas) {
        if (IReciper.isValidGas(gas)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound bathNBT = new NBTTagCompound();
            gas.writeToNBT(bathNBT);
            recipe.func_74782_a(tagInput, (NBTBase)bathNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_pollutant_gas_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToPollutantFluids(FluidStack bath) {
        if (IReciper.isValidFluid(bath)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound bathNBT = new NBTTagCompound();
            bath.writeToNBT(bathNBT);
            recipe.func_74782_a(tagInput, (NBTBase)bathNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_pollutant_fluid_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromPollutantFluids(FluidStack bath) {
        if (IReciper.isValidFluid(bath)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound bathNBT = new NBTTagCompound();
            bath.writeToNBT(bathNBT);
            recipe.func_74782_a(tagInput, (NBTBase)bathNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_pollutant_fluid_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToToxicMutation(ItemStack input, ItemStack output) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_toxic_mutation_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromToxicMutationByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_toxic_mutation_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromToxicMutationByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_toxic_mutation_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToTransposer(FluidStack input, FluidStack output) {
        if (IReciper.isValidFluid(input) && IReciper.isValidFluid(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound bathNBT = new NBTTagCompound();
            input.writeToNBT(bathNBT);
            recipe.func_74782_a(tagInput, (NBTBase)bathNBT);
            NBTTagCompound slurryNBT = new NBTTagCompound();
            output.writeToNBT(slurryNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)slurryNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_transposer_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromTransposerByInput(FluidStack input) {
        if (IReciper.isValidFluid(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound bathNBT = new NBTTagCompound();
            input.writeToNBT(bathNBT);
            recipe.func_74782_a(tagInput, (NBTBase)bathNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_transposer_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromTransposerByOutput(FluidStack output) {
        if (IReciper.isValidFluid(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound slurryNBT = new NBTTagCompound();
            output.writeToNBT(slurryNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)slurryNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_transposer_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToSlurryPond(ItemStack solute, FluidStack bath, FluidStack slurry) {
        if (IReciper.isValidStack(solute) && IReciper.isValidFluid(bath) && IReciper.isValidFluid(slurry)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound soluteNBT = new NBTTagCompound();
            solute.func_77955_b(soluteNBT);
            recipe.func_74782_a(tagInput, (NBTBase)soluteNBT);
            NBTTagCompound bathNBT = new NBTTagCompound();
            bath.writeToNBT(bathNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)bathNBT);
            NBTTagCompound slurryNBT = new NBTTagCompound();
            slurry.writeToNBT(slurryNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)slurryNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_slurry_pond_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromSlurryPondByInput(ItemStack solute) {
        if (IReciper.isValidStack(solute)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound soluteNBT = new NBTTagCompound();
            solute.func_77955_b(soluteNBT);
            recipe.func_74782_a(tagInput, (NBTBase)soluteNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_slurry_pond_solute_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromSlurryPondByBath(FluidStack bath) {
        if (IReciper.isValidFluid(bath)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound bathNBT = new NBTTagCompound();
            bath.writeToNBT(bathNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)bathNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_slurry_pond_bath_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromSlurryPondBySlurry(FluidStack slurry) {
        if (IReciper.isValidFluid(slurry)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound slurryNBT = new NBTTagCompound();
            slurry.writeToNBT(slurryNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)slurryNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_slurry_pond_slurry_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToSeasoningRack(ItemStack input, ItemStack output) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_seasoning_rack_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromSeasoningRackByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_seasoning_rack_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromSeasoningRackByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_seasoning_rack_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToRetentionVat(FluidStack input, List<ItemStack> specimen, List<Float> gravity) {
        if (IReciper.isValidFluid(input) && IReciper.isValidStackArray(specimen) && IReciper.isNonNegativeFloat(gravity) && IReciper.arraysMatch(specimen.size(), gravity.size())) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.writeToNBT(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagList elementsTAG = new NBTTagList();
            for (int i = 0; i < specimen.size(); ++i) {
                NBTTagCompound elementsNBT = new NBTTagCompound();
                specimen.get(i).func_77955_b(elementsNBT);
                elementsTAG.func_74742_a((NBTBase)elementsNBT);
            }
            recipe.func_74782_a(tagElements, (NBTBase)elementsTAG);
            NBTTagList weightTAG = new NBTTagList();
            for (int i = 0; i < gravity.size(); ++i) {
                if (!(gravity.get(i).floatValue() > 0.0f)) continue;
                NBTTagCompound weightNBT = new NBTTagCompound();
                weightNBT.func_74776_a(tagWeights + i, gravity.get(i).floatValue());
                weightTAG.func_74742_a((NBTBase)weightNBT);
            }
            recipe.func_74782_a(tagWeights, (NBTBase)weightTAG);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_retention_vat_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromRetentionVatByInput(FluidStack input) {
        if (IReciper.isValidFluid(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.writeToNBT(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_retention_vat_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToProfilingBench(ItemStack input, ItemStack output, int pattern) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output) && pattern > -1) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            recipe.func_74768_a(tagPattern, pattern);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_profiling_bench_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToProfilingBench(String input, ItemStack output, int pattern) {
        if (IReciper.isValidString(input) && IReciper.isValidStack(output) && pattern > -1) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            IReciper.oredictStack(input).func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            recipe.func_74768_a(tagPattern, pattern);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_profiling_bench_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromProfilingBenchByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_profiling_bench_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromProfilingBenchByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_profiling_bench_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromProfilingBenchByOredict(String oredict) {
        if (IReciper.isValidString(oredict)) {
            NBTTagCompound recipe = new NBTTagCompound();
            recipe.func_74778_a(tagOredict, oredict);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_profiling_bench_oredict_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToMineralSizer(ItemStack input, List<ItemStack> gangue, List<Integer> comminution) {
        if (IReciper.isValidStack(input) && IReciper.isValidStackArray(gangue) && IReciper.isNonNegativeInteger(comminution) && IReciper.arraysMatch(gangue.size(), comminution.size())) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagList elementsTAG = new NBTTagList();
            for (int i = 0; i < gangue.size(); ++i) {
                NBTTagCompound elementsNBT = new NBTTagCompound();
                gangue.get(i).func_77955_b(elementsNBT);
                elementsTAG.func_74742_a((NBTBase)elementsNBT);
            }
            recipe.func_74782_a(tagElements, (NBTBase)elementsTAG);
            NBTTagList weightTAG = new NBTTagList();
            for (int i = 0; i < comminution.size(); ++i) {
                if (comminution.get(i) <= 0) continue;
                NBTTagCompound weightNBT = new NBTTagCompound();
                weightNBT.func_74768_a(tagWeights + i, comminution.get(i).intValue());
                weightTAG.func_74742_a((NBTBase)weightNBT);
            }
            recipe.func_74782_a(tagWeights, (NBTBase)weightTAG);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_mineral_sizer_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromMineralSizerByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_mineral_sizer_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToMetalAlloyer(List<String> element, List<Integer> quantity, ItemStack output) {
        if (IReciper.isValidStack(output) && IReciper.isValidStringArray(element) && IReciper.isNonNegativeInteger(quantity) && IReciper.arraysMatch(element.size(), quantity.size())) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagList elementTAG = new NBTTagList();
            for (int i = 0; i < element.size(); ++i) {
                if (Strings.isNullOrEmpty((String)element.get(i))) continue;
                NBTTagCompound elementNBT = new NBTTagCompound();
                elementNBT.func_74778_a(tagElements + i, element.get(i));
                elementTAG.func_74742_a((NBTBase)elementNBT);
            }
            recipe.func_74782_a(tagElements, (NBTBase)elementTAG);
            NBTTagList weightTAG = new NBTTagList();
            for (int i = 0; i < quantity.size(); ++i) {
                if (quantity.get(i) <= 0) continue;
                NBTTagCompound weightNBT = new NBTTagCompound();
                weightNBT.func_74768_a(tagWeights + i, quantity.get(i).intValue());
                weightTAG.func_74742_a((NBTBase)weightNBT);
            }
            recipe.func_74782_a(tagWeights, (NBTBase)weightTAG);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_metal_alloyer_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromMetalAlloyerByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_metal_alloyer_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromMetalAlloyerByOredict(String oredict) {
        if (IReciper.isValidString(oredict)) {
            NBTTagCompound recipe = new NBTTagCompound();
            recipe.func_74778_a(tagOredict, oredict);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_metal_alloyer_oredict_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToMaterialCabinet(String id, String oredict, String display) {
        if (IReciper.isValidString(id) && id.length() <= 2 && IReciper.isValidString(oredict) && IReciper.isValidString(display)) {
            NBTTagCompound recipe = new NBTTagCompound();
            recipe.func_74778_a(tagPattern, id);
            recipe.func_74778_a(tagOredict, oredict);
            recipe.func_74778_a(tagDisplay, display);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_material_cabinet_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromMaterialCabinetByOredict(String oredict) {
        if (IReciper.isValidString(oredict)) {
            NBTTagCompound recipe = new NBTTagCompound();
            recipe.func_74778_a(tagOredict, oredict);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_material_cabinet_oredict_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToLeachingVat(ItemStack input, List<ItemStack> specimen, List<Float> gravity, FluidStack leachate) {
        if (IReciper.isValidStack(input) && IReciper.isValidStackArray(specimen) && IReciper.isNonNegativeFloat(gravity) && IReciper.arraysMatch(specimen.size(), gravity.size())) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagList elementsTAG = new NBTTagList();
            for (int i = 0; i < specimen.size(); ++i) {
                NBTTagCompound elementsNBT = new NBTTagCompound();
                specimen.get(i).func_77955_b(elementsNBT);
                elementsTAG.func_74742_a((NBTBase)elementsNBT);
            }
            recipe.func_74782_a(tagElements, (NBTBase)elementsTAG);
            NBTTagList weightTAG = new NBTTagList();
            for (int i = 0; i < gravity.size(); ++i) {
                if (!(gravity.get(i).floatValue() > 0.0f)) continue;
                NBTTagCompound weightNBT = new NBTTagCompound();
                weightNBT.func_74776_a(tagWeights + i, gravity.get(i).floatValue());
                weightTAG.func_74742_a((NBTBase)weightNBT);
            }
            recipe.func_74782_a(tagWeights, (NBTBase)weightTAG);
            NBTTagCompound leachateNBT = new NBTTagCompound();
            leachate.writeToNBT(leachateNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)leachateNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_leaching_vat_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromLeachingVatByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_leaching_vat_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToLabOven(String display, ItemStack solute, ItemStack catalyst, FluidStack solvent, FluidStack reagent, FluidStack solution, FluidStack byproduct) {
        if ((IReciper.isValidStack(solute) || IReciper.isValidConsumable(catalyst)) && IReciper.isValidFluid(solvent) && IReciper.isValidFluid(solution)) {
            NBTTagCompound recipe = new NBTTagCompound();
            if (IReciper.isValidString(display)) {
                recipe.func_74778_a(tagDisplay, display);
            }
            if (IReciper.isValidStack(solute)) {
                NBTTagCompound inputNBT = new NBTTagCompound();
                solute.func_77955_b(inputNBT);
                recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            }
            if (IReciper.isValidConsumable(catalyst)) {
                NBTTagCompound catalystNBT = new NBTTagCompound();
                catalyst.func_77955_b(catalystNBT);
                recipe.func_74782_a(tagPattern, (NBTBase)catalystNBT);
            }
            NBTTagCompound solventNBT = new NBTTagCompound();
            solvent.writeToNBT(solventNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)solventNBT);
            if (IReciper.isValidFluid(reagent)) {
                NBTTagCompound reagentNBT = new NBTTagCompound();
                reagent.writeToNBT(reagentNBT);
                recipe.func_74782_a(tagReagent, (NBTBase)reagentNBT);
            }
            NBTTagCompound solutionNBT = new NBTTagCompound();
            solution.writeToNBT(solutionNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)solutionNBT);
            if (IReciper.isValidFluid(byproduct)) {
                NBTTagCompound byproductNBT = new NBTTagCompound();
                byproduct.writeToNBT(byproductNBT);
                recipe.func_74782_a(tagByproduct, (NBTBase)byproductNBT);
            }
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_lab_oven_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromLabOvenBySolute(ItemStack solute) {
        if (IReciper.isValidStack(solute)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound soluteNBT = new NBTTagCompound();
            solute.func_77955_b(soluteNBT);
            recipe.func_74782_a(tagInput, (NBTBase)soluteNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_lab_oven_solute_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromLabOvenBySolvent(FluidStack solvent) {
        if (IReciper.isValidFluid(solvent)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound solventNBT = new NBTTagCompound();
            solvent.writeToNBT(solventNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)solventNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_lab_oven_solvent_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromLabOvenBySolution(FluidStack solution) {
        if (IReciper.isValidFluid(solution)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound solutionNBT = new NBTTagCompound();
            solution.writeToNBT(solutionNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)solutionNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_lab_oven_solution_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromLabOvenByPrecipitate(ItemStack precipitate) {
        if (IReciper.isValidStack(precipitate)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound precipitateNBT = new NBTTagCompound();
            precipitate.func_77955_b(precipitateNBT);
            recipe.func_74782_a(tagWaste, (NBTBase)precipitateNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_lab_oven_precipitate_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToLabBlender(List<ItemStack> stacks, ItemStack output) {
        if (IReciper.isValidStack(output) && IReciper.isValidStackArray(stacks)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagList elementTAG = new NBTTagList();
            for (int i = 0; i < stacks.size(); ++i) {
                NBTTagCompound elementNBT = new NBTTagCompound();
                stacks.get(i).func_77955_b(elementNBT);
                elementTAG.func_74742_a((NBTBase)elementNBT);
            }
            recipe.func_74782_a(tagElements, (NBTBase)elementTAG);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_lab_blender_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromLabBlenderByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_lab_blender_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToHeatExchanger(FluidStack input, FluidStack output) {
        if (IReciper.isValidGas(input) && IReciper.isValidGas(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.writeToNBT(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_heat_exchanger_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromHeatExchangerByInput(FluidStack input) {
        if (IReciper.isValidGas(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.writeToNBT(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_heat_exchanger_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromHeatExchangerByOutput(FluidStack output) {
        if (IReciper.isValidGas(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_heat_exchanger_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToReformingReactor(FluidStack solvent, FluidStack reagent, FluidStack output, ItemStack catalyst) {
        if (IReciper.isValidGas(solvent) && IReciper.isValidGas(reagent) && IReciper.isValidGas(output) && IReciper.isValidStack(catalyst)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound solventNBT = new NBTTagCompound();
            solvent.writeToNBT(solventNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)solventNBT);
            NBTTagCompound reagentNBT = new NBTTagCompound();
            reagent.writeToNBT(reagentNBT);
            recipe.func_74782_a(tagReagent, (NBTBase)reagentNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            NBTTagCompound catalystNBT = new NBTTagCompound();
            catalyst.func_77955_b(catalystNBT);
            recipe.func_74782_a(tagPattern, (NBTBase)catalystNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_reforming_reactor_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromReformingReactorBySolvent(FluidStack solvent) {
        if (IReciper.isValidGas(solvent)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            solvent.writeToNBT(inputNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_reforming_reactor_solvent_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromReformingReactorByReagent(FluidStack reagent) {
        if (IReciper.isValidGas(reagent)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            reagent.writeToNBT(inputNBT);
            recipe.func_74782_a(tagReagent, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_reforming_reactor_reagent_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromReformingReactorByOutput(FluidStack output) {
        if (IReciper.isValidGas(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_reforming_reactor_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToGasCondenser(FluidStack input, FluidStack output) {
        if (IReciper.isValidGas(input) && IReciper.isValidFluid(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.writeToNBT(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_gas_condenser_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromGasCondenserByInput(FluidStack input) {
        if (IReciper.isValidGas(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.writeToNBT(inputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_gas_condenser_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromGasCondenserByOutput(FluidStack output) {
        if (IReciper.isValidFluid(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_gas_condenser_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToGasPurifier(FluidStack input, FluidStack output, ItemStack slag1, ItemStack slag2) {
        if (IReciper.isValidGas(input) && IReciper.isValidGas(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.writeToNBT(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            if (IReciper.isValidStack(slag1)) {
                NBTTagCompound slag1NBT = new NBTTagCompound();
                slag1.func_77955_b(slag1NBT);
                recipe.func_74782_a(tagSlag1, (NBTBase)slag1NBT);
            }
            if (IReciper.isValidStack(slag2)) {
                NBTTagCompound slag2NBT = new NBTTagCompound();
                slag2.func_77955_b(slag2NBT);
                recipe.func_74782_a(tagSlag2, (NBTBase)slag2NBT);
            }
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_gas_purifier_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromGasPurifierByInput(FluidStack input) {
        if (IReciper.isValidGas(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.writeToNBT(inputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_gas_purifier_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromGasPurifierByOutput(FluidStack output) {
        if (IReciper.isValidGas(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_gas_purifier_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToGasificationPlant(FluidStack solvent, FluidStack reagent, FluidStack output, ItemStack slag1, ItemStack slag2, int temperature) {
        if (IReciper.isValidFluid(solvent) && IReciper.isValidFluid(reagent) && IReciper.isValidGas(output) && temperature > 30 && temperature <= 2000) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound solventNBT = new NBTTagCompound();
            solvent.writeToNBT(solventNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)solventNBT);
            NBTTagCompound reagentNBT = new NBTTagCompound();
            reagent.writeToNBT(reagentNBT);
            recipe.func_74782_a(tagReagent, (NBTBase)reagentNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            if (IReciper.isValidStack(slag1)) {
                NBTTagCompound slag1NBT = new NBTTagCompound();
                slag1.func_77955_b(slag1NBT);
                recipe.func_74782_a(tagSlag1, (NBTBase)slag1NBT);
            }
            if (IReciper.isValidStack(slag2)) {
                NBTTagCompound slag2NBT = new NBTTagCompound();
                slag2.func_77955_b(slag2NBT);
                recipe.func_74782_a(tagSlag2, (NBTBase)slag2NBT);
            }
            recipe.func_74768_a(tagTemperature, temperature);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_gasification_plant_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromGasificationPlantBySolvent(FluidStack solvent) {
        if (IReciper.isValidFluid(solvent)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            solvent.writeToNBT(inputNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_gasification_plant_solvent_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromGasificationPlantByReagent(FluidStack reagent) {
        if (IReciper.isValidFluid(reagent)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            reagent.writeToNBT(inputNBT);
            recipe.func_74782_a(tagReagent, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_gasification_plant_reagent_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromGasificationPlantByOutput(FluidStack output) {
        if (IReciper.isValidGas(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.writeToNBT(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_gasification_plant_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToDepositionChamber(ItemStack input, ItemStack output, FluidStack solvent, int temperature, int pressure) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output) && IReciper.isValidGas(solvent) && temperature > 30 && temperature <= 3000 && pressure > 30 && pressure <= 32000) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            NBTTagCompound solventNBT = new NBTTagCompound();
            solvent.writeToNBT(solventNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)solventNBT);
            recipe.func_74768_a(tagTemperature, temperature);
            recipe.func_74768_a(tagPressure, pressure);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_deposition_chamber_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromDepositionChamberByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_deposition_chamber_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromDepositionChamberByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_deposition_chamber_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromDepositionChamberBySolvent(FluidStack solvent) {
        if (IReciper.isValidGas(solvent)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            solvent.writeToNBT(inputNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_deposition_chamber_solvent_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToChemicalExtractor(String category, ItemStack input, List<String> element, List<Integer> quantity) {
        if (IReciper.isValidString(category) && IReciper.isValidStack(input) && IReciper.isValidStringArray(element) && IReciper.isNonNegativeInteger(quantity) && IReciper.arraysMatch(element.size(), quantity.size())) {
            NBTTagCompound recipe = new NBTTagCompound();
            recipe.func_74778_a(tagDisplay, category);
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagList elementTAG = new NBTTagList();
            for (int i = 0; i < element.size(); ++i) {
                if (Strings.isNullOrEmpty((String)element.get(i))) continue;
                NBTTagCompound elementNBT = new NBTTagCompound();
                elementNBT.func_74778_a(tagElements + i, element.get(i));
                elementTAG.func_74742_a((NBTBase)elementNBT);
            }
            recipe.func_74782_a(tagElements, (NBTBase)elementTAG);
            NBTTagList weightTAG = new NBTTagList();
            for (int i = 0; i < quantity.size(); ++i) {
                if (quantity.get(i) <= 0) continue;
                NBTTagCompound weightNBT = new NBTTagCompound();
                weightNBT.func_74768_a(tagWeights + i, quantity.get(i).intValue());
                weightTAG.func_74742_a((NBTBase)weightNBT);
            }
            recipe.func_74782_a(tagWeights, (NBTBase)weightTAG);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)add_chemical_extractor_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromChemicalExtractorByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_chemical_extractor_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromChemicalExtractorByOredict(String oredict) {
        if (IReciper.isValidString(oredict)) {
            NBTTagCompound recipe = new NBTTagCompound();
            recipe.func_74778_a(tagOredict, oredict);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)remove_chemical_extractor_oredict_key, (NBTTagCompound)recipe);
        }
    }

    public static void inhibitFromChemicalExtractor(String string) {
        if (IReciper.isValidString(string)) {
            NBTTagCompound recipe = new NBTTagCompound();
            recipe.func_74778_a(tagOredict, string);
            FMLInterModComms.sendMessage((String)rh_chemistry_id, (String)inhibit_chemical_extractor_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToBloomery(ItemStack input, FluidStack bloom, ItemStack output) {
        if (IReciper.isValidStack(input) && IReciper.isValidFluid(bloom) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)outputNBT);
            NBTTagCompound solventNBT = new NBTTagCompound();
            bloom.writeToNBT(solventNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)solventNBT);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)add_bloomery_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromBloomeryByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)remove_bloomery_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromBloomeryByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)remove_bloomery_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromBloomeryByBloom(FluidStack solvent) {
        if (IReciper.isValidFluid(solvent)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound solventNBT = new NBTTagCompound();
            solvent.writeToNBT(solventNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)solventNBT);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)remove_bloomery_bloom_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToCoalRefiner(ItemStack input, boolean oredict, ItemStack output, int refining) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            recipe.func_74757_a(tagOredict, oredict);
            recipe.func_74768_a(tagWeights, refining);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)add_coal_refiner_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromCoalRefinerByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)remove_coal_refiner_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromCoalRefinerByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)remove_coal_refiner_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToDryingPallet(ItemStack input, boolean oredict, ItemStack output, int refining) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            recipe.func_74757_a(tagOredict, oredict);
            recipe.func_74768_a(tagWeights, refining);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)add_drying_pallet_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromDryingPalletByInput(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)remove_drying_pallet_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromDryingPalletByOutput(ItemStack output) {
        if (IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_oretiers_id, (String)remove_drying_pallet_output_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToRockVendor(ItemStack input, int stacksize) {
        if (IReciper.isValidStack(input) && stacksize < 64) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            recipe.func_74768_a(tagPattern, stacksize);
            FMLInterModComms.sendMessage((String)rh_rocks_id, (String)add_rock_vendor_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromRockVendor(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_rocks_id, (String)remove_rock_vendor_input_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToCuttingStation(ItemStack input, int pattern, ItemStack output) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output) && pattern > -1 && pattern < 20) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            recipe.func_74768_a(tagPattern, pattern);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_rocks_id, (String)add_cutting_station_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToStoneRammer(ItemStack input, ItemStack output) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_rocks_id, (String)add_stone_rammer_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToCarvingTable(ItemStack input, int pattern, ItemStack output) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            recipe.func_74768_a(tagPattern, pattern);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_rocks_id, (String)add_carving_bench_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToSculptingTable(ItemStack input, int pattern, ItemStack output) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            recipe.func_74768_a(tagPattern, pattern);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_rocks_id, (String)add_sculpting_bench_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToCompostBin(ItemStack input, int type, int value) {
        if (IReciper.isValidStack(input) && type >= -1 && type < 6) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            recipe.func_74768_a(tagPattern, type);
            recipe.func_74768_a(tagWeights, value);
            FMLInterModComms.sendMessage((String)rh_surface_id, (String)add_compost_bin_key, (NBTTagCompound)recipe);
        }
    }

    public static void removeFromCompostBin(ItemStack input) {
        if (IReciper.isValidStack(input)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            FMLInterModComms.sendMessage((String)rh_surface_id, (String)remove_compost_bin_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToWoodIncubator(ItemStack input, ItemStack solute, FluidStack solvent, ItemStack output) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(solute) && IReciper.isValidFluid(solvent) && IReciper.isValidStack(output)) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound soluteNBT = new NBTTagCompound();
            solute.func_77955_b(soluteNBT);
            recipe.func_74782_a(tagPattern, (NBTBase)soluteNBT);
            NBTTagCompound solventNBT = new NBTTagCompound();
            solvent.writeToNBT(solventNBT);
            recipe.func_74782_a(tagSolvent, (NBTBase)solventNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            FMLInterModComms.sendMessage((String)rh_surface_id, (String)add_wood_incubator_key, (NBTTagCompound)recipe);
        }
    }

    public static void sendToVivarium(ItemStack input, ItemStack output, int produceRate, int consumeRate) {
        if (IReciper.isValidStack(input) && IReciper.isValidStack(output) && produceRate > 0 && consumeRate > 0) {
            NBTTagCompound recipe = new NBTTagCompound();
            NBTTagCompound inputNBT = new NBTTagCompound();
            input.func_77955_b(inputNBT);
            recipe.func_74782_a(tagInput, (NBTBase)inputNBT);
            NBTTagCompound outputNBT = new NBTTagCompound();
            output.func_77955_b(outputNBT);
            recipe.func_74782_a(tagOutput, (NBTBase)outputNBT);
            recipe.func_74768_a(tagWeights, produceRate);
            recipe.func_74768_a(tagWaste, consumeRate);
            FMLInterModComms.sendMessage((String)rh_surface_id, (String)add_vivarium_key, (NBTTagCompound)recipe);
        }
    }
}

