/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.utils;

import com.globbypotato.rockhounding_core.enums.EnumFluidNbt;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityFueledMachine;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityFueledTank;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityFueledVessel;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityPoweredMachine;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityPoweredTank;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityPoweredVessel;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class MachinesUtils {
    public static void restoreMachineNBT(ItemStack stack, TileEntity te, int facing) {
        TileEntityInv tile;
        if (te instanceof TileEntityInv && facing != -1) {
            tile = (TileEntityInv)te;
            tile.facing = facing;
        }
        if (stack.func_77942_o()) {
            if (te instanceof TileEntityInv) {
                tile = (TileEntityInv)te;
                if (stack.func_77978_p().func_74764_b("Recipe")) {
                    int recipe;
                    tile.recipeIndex = recipe = stack.func_77978_p().func_74762_e("Recipe");
                }
            }
            if (te instanceof TileEntityFueledMachine) {
                tile = (TileEntityFueledMachine)te;
                if (stack.func_77978_p().func_74764_b("Fuel")) {
                    int fuel;
                    ((TileEntityFueledMachine)tile).powerCount = fuel = stack.func_77978_p().func_74762_e("Fuel");
                }
            }
            if (te instanceof TileEntityFueledTank) {
                tile = (TileEntityFueledTank)te;
                if (stack.func_77978_p().func_74764_b(EnumFluidNbt.LAVA.nameTag())) {
                    ((TileEntityFueledTank)tile).lavaTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.LAVA.nameTag())));
                }
            }
            if (te instanceof TileEntityFueledVessel) {
                tile = (TileEntityPoweredVessel)te;
                if (stack.func_77978_p().func_74764_b(EnumFluidNbt.COMBUSTIBLE.nameTag())) {
                    ((TileEntityPoweredVessel)tile).gasTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.COMBUSTIBLE.nameTag())));
                }
            }
            if (Loader.isModLoaded((String)CoreBasics.r_flux)) {
                if (te instanceof TileEntityPoweredMachine) {
                    tile = (TileEntityPoweredMachine)te;
                    if (stack.func_77978_p().func_74764_b("Energy")) {
                        int energy;
                        ((TileEntityPoweredMachine)tile).redstoneCount = energy = stack.func_77978_p().func_74762_e("Energy");
                    }
                    if (stack.func_77978_p().func_74764_b("Induction")) {
                        boolean induction;
                        ((TileEntityPoweredMachine)tile).permanentInductor = induction = stack.func_77978_p().func_74767_n("Induction");
                    }
                }
                if (te instanceof TileEntityPoweredVessel) {
                    tile = (TileEntityPoweredVessel)te;
                    if (stack.func_77978_p().func_74764_b(EnumFluidNbt.COMBUSTIBLE.nameTag())) {
                        ((TileEntityPoweredVessel)tile).gasTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.COMBUSTIBLE.nameTag())));
                    }
                }
            }
        }
    }

    public static void addMachineNbt(ItemStack itemstack, TileEntity tileentity) {
        if (tileentity != null) {
            NBTTagCompound lava;
            TileEntityInv tile;
            if (tileentity instanceof TileEntityInv) {
                itemstack.func_77982_d(new NBTTagCompound());
                tile = (TileEntityInv)tileentity;
                if (tile.recipeIndex >= 0) {
                    itemstack.func_77978_p().func_74768_a("Recipe", tile.recipeIndex);
                }
            }
            if (tileentity instanceof TileEntityFueledMachine) {
                tile = (TileEntityFueledMachine)tileentity;
                itemstack.func_77978_p().func_74768_a("Fuel", tile.powerCount);
            }
            if (!Loader.isModLoaded((String)CoreBasics.r_flux)) {
                if (tileentity instanceof TileEntityFueledTank) {
                    tile = (TileEntityFueledTank)tileentity;
                    lava = new NBTTagCompound();
                    if (((TileEntityFueledTank)tile).lavaTank.getFluid() != null) {
                        ((TileEntityFueledTank)tile).lavaTank.getFluid().writeToNBT(lava);
                        itemstack.func_77978_p().func_74782_a(EnumFluidNbt.LAVA.nameTag(), (NBTBase)lava);
                    }
                }
                if (tileentity instanceof TileEntityFueledVessel) {
                    tile = (TileEntityFueledVessel)tileentity;
                    lava = new NBTTagCompound();
                    if (((TileEntityFueledVessel)tile).gasTank.getFluid() != null) {
                        ((TileEntityFueledVessel)tile).gasTank.getFluid().writeToNBT(lava);
                        itemstack.func_77978_p().func_74782_a(EnumFluidNbt.COMBUSTIBLE.nameTag(), (NBTBase)lava);
                    }
                }
            }
            if (Loader.isModLoaded((String)CoreBasics.r_flux)) {
                if (tileentity instanceof TileEntityPoweredMachine) {
                    tile = (TileEntityPoweredMachine)tileentity;
                    itemstack.func_77978_p().func_74768_a("Energy", ((TileEntityPoweredMachine)tile).redstoneCount);
                    itemstack.func_77978_p().func_74757_a("Induction", ((TileEntityPoweredMachine)tile).permanentInductor);
                }
                if (tileentity instanceof TileEntityPoweredVessel) {
                    tile = (TileEntityPoweredVessel)tileentity;
                    lava = new NBTTagCompound();
                    if (((TileEntityPoweredVessel)tile).gasTank.getFluid() != null) {
                        ((TileEntityPoweredVessel)tile).gasTank.getFluid().writeToNBT(lava);
                        itemstack.func_77978_p().func_74782_a(EnumFluidNbt.COMBUSTIBLE.nameTag(), (NBTBase)lava);
                    }
                }
                if (tileentity instanceof TileEntityPoweredTank) {
                    tile = (TileEntityPoweredTank)tileentity;
                    lava = new NBTTagCompound();
                    if (((TileEntityPoweredTank)tile).lavaTank.getFluid() != null) {
                        ((TileEntityPoweredTank)tile).lavaTank.getFluid().writeToNBT(lava);
                        itemstack.func_77978_p().func_74782_a(EnumFluidNbt.LAVA.nameTag(), (NBTBase)lava);
                    }
                }
            }
        }
    }
}

