/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.machines.tileentity;

import com.globbypotato.rockhounding_core.machines.tileentity.IFluidHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;

public abstract class TileEntityTank
extends TileEntityInv
implements IFluidHandlingTile {
    public TileEntityTank(int inputSlots, int outputSlots, int templateSlots, int upgradeSlots) {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
    }

    @Override
    public boolean interactWithFluidHandler(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
        this.markDirtyClient();
        return didFill;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getCombinedTank();
        }
        return super.getCapability(capability, facing);
    }

    protected FluidHandlerConcatenate getCombinedTank() {
        return null;
    }

    protected boolean handleBucket(ItemStack insertingStack, Fluid fluid) {
        if (!insertingStack.func_190926_b() && CoreUtils.isBucketType(insertingStack)) {
            if (insertingStack.func_77973_b() instanceof UniversalBucket) {
                if (TileEntityTank.toFluidStack(fluid) != null) {
                    return TileEntityTank.isValidFluidStack(insertingStack, TileEntityTank.toFluidStack(fluid));
                }
            } else if (insertingStack.func_77973_b() instanceof ItemBucket || insertingStack.func_77973_b() == Items.field_151133_ar) {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidFluidStack(ItemStack insertingStack, FluidStack fluidStack) {
        if (!insertingStack.func_190926_b() && fluidStack != null) {
            return FluidUtil.getFluidContained((ItemStack)insertingStack).containsFluid(fluidStack);
        }
        return false;
    }

    private static FluidStack toFluidStack(Fluid fluid) {
        return fluid != null ? new FluidStack(fluid, 1000) : null;
    }

    protected void emptyContainer(int slot, FluidTank tank) {
        ItemStack bucketSlot = this.input.getStackInSlot(slot);
        FluidStack insertingFluid = FluidUtil.getFluidContained((ItemStack)bucketSlot);
        if (CoreUtils.isBucketType(bucketSlot) && insertingFluid != null && (tank.getFluid() == null || tank.getFluid() != null && insertingFluid.isFluidEqual(tank.getFluid())) && !FluidUtil.tryEmptyContainer((ItemStack)bucketSlot, (IFluidHandler)tank, (int)1000, null, (boolean)false).getResult().func_190926_b()) {
            this.input.setStackInSlot(slot, FluidUtil.tryEmptyContainer((ItemStack)bucketSlot, (IFluidHandler)tank, (int)1000, null, (boolean)true).getResult());
        }
    }

    protected void fillContainer(int slot, FluidTank tank) {
        ItemStack bucketSlot = this.input.getStackInSlot(slot);
        if (CoreUtils.isEmptyBucket(bucketSlot) && tank.getFluid() != null && tank.getFluidAmount() >= 1000 && FluidUtil.tryFillContainer((ItemStack)bucketSlot, (IFluidHandler)tank, (int)1000, null, (boolean)false) != null) {
            if (bucketSlot.func_190916_E() > 1) {
                ItemStack droppingBeaker = FluidUtil.tryFillContainer((ItemStack)bucketSlot, (IFluidHandler)tank, (int)1000, null, (boolean)true).getResult();
                EnumFacing front = EnumFacing.func_82600_a((int)this.func_145832_p());
                BlockPos frontPos = this.field_174879_c.func_177972_a(front.func_176734_d());
                EntityItem entityitem = new EntityItem(this.field_145850_b, (double)frontPos.func_177958_n() + 0.5, (double)frontPos.func_177956_o() + 0.5, (double)frontPos.func_177952_p() + 0.5, droppingBeaker);
                this.field_145850_b.func_72838_d((Entity)entityitem);
                this.input.decrementSlot(slot);
            } else {
                this.input.setStackInSlot(slot, FluidUtil.tryFillContainer((ItemStack)bucketSlot, (IFluidHandler)tank, (int)1000, null, (boolean)true).getResult());
            }
        }
    }
}

