/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.machines.tileentity;

import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class MachineStackHandler
extends ItemStackHandler {
    Random rand = new Random();
    TileEntityInv tile;

    public MachineStackHandler(int slots, TileEntityInv tile) {
        super(slots);
        this.tile = tile;
    }

    public boolean canSetOrStack(ItemStack stackInSlot, ItemStack recipeOutput) {
        return stackInSlot.func_190926_b() || this.canStack(stackInSlot, recipeOutput);
    }

    public boolean canStack(ItemStack stackInSlot, ItemStack recipeOutput) {
        return !stackInSlot.func_190926_b() && stackInSlot.func_77969_a(recipeOutput) && stackInSlot.func_190916_E() <= stackInSlot.func_77976_d() - recipeOutput.func_190916_E();
    }

    public void setOrStack(int slot, ItemStack stackToSet) {
        if (this.getStackInSlot(slot).func_190926_b()) {
            this.setStackInSlot(slot, stackToSet);
        } else {
            for (int x = 0; x < stackToSet.func_190916_E(); ++x) {
                this.incrementSlot(slot);
            }
        }
    }

    public boolean canIncrementSlot(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_190916_E() < stack.func_77976_d();
    }

    public void incrementSlot(int slot) {
        ItemStack temp = this.getStackInSlot(slot);
        if (temp.func_190916_E() + 1 <= temp.func_77976_d()) {
            temp.func_190917_f(1);
        }
        this.setStackInSlot(slot, temp);
    }

    public void incrementSlotBy(int slot, int num) {
        ItemStack temp = this.getStackInSlot(slot);
        int adding = Math.min(temp.func_77976_d() - temp.func_190916_E(), num);
        temp.func_190917_f(adding);
        this.setStackInSlot(slot, temp);
    }

    public void setOrIncrement(int slot, ItemStack stackToSet) {
        if (this.getStackInSlot(slot).func_190926_b()) {
            this.setStackInSlot(slot, stackToSet);
        } else {
            this.incrementSlot(slot);
        }
    }

    public void decrementSlot(int slot) {
        ItemStack temp = this.getStackInSlot(slot);
        temp.func_190918_g(1);
        if (temp.func_190916_E() <= 0) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        } else {
            this.setStackInSlot(slot, temp);
        }
    }

    public void decrementSlotBy(int slot, int num) {
        ItemStack temp = this.getStackInSlot(slot);
        int taking = Math.min(temp.func_190916_E(), num);
        temp.func_190918_g(taking);
        if (temp.func_190916_E() <= 0) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        } else {
            this.setStackInSlot(slot, temp);
        }
    }

    public void damageSlot(int slot) {
        if (!this.getStackInSlot(slot).func_190926_b()) {
            int damage = this.getStackInSlot(slot).func_77952_i() + 1;
            this.getStackInSlot(slot).func_77964_b(damage);
            if (damage >= this.getStackInSlot(slot).func_77958_k()) {
                this.getStackInSlot(slot).func_190918_g(1);
            }
            if (this.getStackInSlot(slot).func_190916_E() <= 0) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
        }
    }

    public void damageSlot(int slot, int step) {
        if (this.getStackInSlot(slot) != ItemStack.field_190927_a) {
            int damage = this.getStackInSlot(slot).func_77952_i() + step;
            this.getStackInSlot(slot).func_77964_b(damage);
            if (damage >= this.getStackInSlot(slot).func_77958_k()) {
                this.getStackInSlot(slot).func_190918_g(1);
            }
            if (this.getStackInSlot(slot).func_190916_E() <= 0) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
        }
    }

    public void damageUnbreakingSlot(int level, int slot) {
        if (level > 0) {
            if (this.rand.nextInt(level + 1) == 0) {
                this.damageSlot(slot);
            }
        } else {
            this.damageSlot(slot);
        }
    }

    public boolean canSetOrFillFluid(FluidTank tank, FluidStack tankFluid, FluidStack insertingFluid) {
        return insertingFluid != null && (tankFluid == null || this.canFillFluid(tank, tankFluid, insertingFluid));
    }

    public boolean canFillFluid(FluidTank tank, FluidStack tankFluid, FluidStack insertingFluid) {
        return tankFluid != null && tankFluid.isFluidEqual(insertingFluid) && tankFluid.amount <= tank.getCapacity() - insertingFluid.amount;
    }

    public boolean canSetOrAddFluid(FluidTank tank, FluidStack tankFluid, FluidStack insertingFluid, int amount) {
        return insertingFluid != null && (tankFluid == null || this.canAddFluid(tank, tankFluid, insertingFluid, amount));
    }

    public boolean canAddFluid(FluidTank tank, FluidStack tankFluid, FluidStack insertingFluid, int amount) {
        return tankFluid != null && tankFluid.isFluidEqual(insertingFluid) && tankFluid.amount <= tank.getCapacity() - amount;
    }

    public boolean canDrainFluid(FluidStack tankFluid, FluidStack requestedFluid) {
        return tankFluid != null && requestedFluid != null && tankFluid.isFluidEqual(requestedFluid) && tankFluid.amount >= requestedFluid.amount;
    }

    public boolean canDrainFluid(FluidStack tankFluid, FluidStack requestedFluid, int amount) {
        return tankFluid != null && requestedFluid != null && tankFluid.isFluidEqual(requestedFluid) && tankFluid.amount >= amount;
    }

    public void drainOrCleanFluid(FluidTank tank, int amount, boolean doClean) {
        tank.getFluid().amount -= amount;
        if (doClean && tank.getFluidAmount() <= 0) {
            tank.setFluid(null);
        }
    }

    public boolean tankHasFluid(FluidTank tank) {
        return tank.getFluid() != null && tank.getFluidAmount() > 0;
    }

    public boolean tankHasFluid(FluidTank tank, int amount) {
        return tank.getFluid() != null && tank.getFluidAmount() >= amount;
    }

    public void setOrFillFluid(FluidTank tank, FluidStack insertingFluid) {
        if (tank.getFluid() != null) {
            tank.getFluid().amount += insertingFluid.amount;
        } else {
            tank.setFluid(insertingFluid);
        }
    }

    public void setOrFillFluid(FluidTank tank, FluidStack insertingFluid, int amount) {
        if (tank.getFluid() != null) {
            tank.getFluid().amount += amount;
        } else {
            tank.setFluid(new FluidStack(insertingFluid.getFluid(), amount));
        }
    }
}

