/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import hellfirepvp.modularmachinery.common.util.InventoryUpdateListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;

public class IOInventory
implements IItemHandlerModifiable {
    public boolean allowAnySlots = false;
    private final TileEntitySynchronized owner;
    private Map<Integer, Integer> slotLimits = new HashMap<Integer, Integer>();
    private Map<Integer, SlotStackHolder> inventory = new HashMap<Integer, SlotStackHolder>();
    private int[] inSlots = new int[0];
    private int[] outSlots = new int[0];
    private int[] miscSlots = new int[0];
    private InventoryUpdateListener listener = null;
    public List<EnumFacing> accessibleSides = new ArrayList<EnumFacing>();

    private IOInventory(TileEntitySynchronized owner) {
        this.owner = owner;
    }

    public IOInventory(TileEntitySynchronized owner, int[] inSlots, int[] outSlots) {
        this(owner, inSlots, outSlots, EnumFacing.field_82609_l);
    }

    public IOInventory(TileEntitySynchronized owner, int[] inSlots, int[] outSlots, EnumFacing ... accessibleFrom) {
        Integer slot;
        int n;
        this.owner = owner;
        this.inSlots = inSlots;
        this.outSlots = outSlots;
        int[] nArray = inSlots;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            slot = nArray[n];
            this.inventory.put(slot, new SlotStackHolder(slot));
        }
        nArray = outSlots;
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            slot = nArray[n];
            this.inventory.put(slot, new SlotStackHolder(slot));
        }
        this.accessibleSides = Arrays.asList(accessibleFrom);
    }

    public IOInventory setMiscSlots(int ... miscSlots) {
        this.miscSlots = miscSlots;
        int[] nArray = miscSlots;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer slot = nArray[i];
            this.inventory.put(slot, new SlotStackHolder(slot));
        }
        return this;
    }

    public IOInventory setStackLimit(int limit, int ... slots) {
        for (int slot : slots) {
            this.slotLimits.put(slot, limit);
        }
        return this;
    }

    public IOInventory setListener(InventoryUpdateListener listener) {
        this.listener = listener;
        return this;
    }

    public TileEntitySynchronized getOwner() {
        return this.owner;
    }

    public IItemHandlerModifiable asGUIAccess() {
        return new GuiAccess(this);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.inventory.containsKey(slot)) {
            this.inventory.get(slot).itemStack = stack;
            this.getOwner().markForUpdate();
            if (this.listener != null) {
                this.listener.onChange();
            }
        }
    }

    public int getSlots() {
        return this.inventory.size();
    }

    public int getSlotLimit(int slot) {
        if (this.slotLimits.containsKey(slot)) {
            return this.slotLimits.get(slot);
        }
        return 64;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.containsKey(slot) ? this.inventory.get(slot).itemStack : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (!this.allowAnySlots && !this.arrayContains(this.inSlots, slot)) {
            return stack;
        }
        if (!this.inventory.containsKey(slot)) {
            return stack;
        }
        SlotStackHolder holder = this.inventory.get(slot);
        ItemStack toInsert = this.copyWithSize(stack, stack.func_190916_E());
        if (!holder.itemStack.func_190926_b()) {
            ItemStack existing = this.copyWithSize(holder.itemStack, holder.itemStack.func_190916_E());
            int max = Math.min(existing.func_77976_d(), this.getSlotLimit(slot));
            if (existing.func_190916_E() >= max || !this.canMergeItemStacks(existing, toInsert)) {
                return stack;
            }
            int movable = Math.min(max - existing.func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                holder.itemStack.func_190917_f(movable);
                this.getOwner().markForUpdate();
                if (this.listener != null) {
                    this.listener.onChange();
                }
            }
            if (movable >= stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190918_g(movable);
            return copy;
        }
        int max = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (max >= stack.func_190916_E()) {
            if (!simulate) {
                holder.itemStack = stack.func_77946_l();
                this.getOwner().markForUpdate();
                if (this.listener != null) {
                    this.listener.onChange();
                }
            }
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(max);
        if (!simulate) {
            holder.itemStack = copy;
            this.getOwner().markForUpdate();
            if (this.listener != null) {
                this.listener.onChange();
            }
        }
        copy = stack.func_77946_l();
        copy.func_190918_g(max);
        return copy;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.allowAnySlots && !this.arrayContains(this.outSlots, slot)) {
            return ItemStack.field_190927_a;
        }
        if (!this.inventory.containsKey(slot)) {
            return ItemStack.field_190927_a;
        }
        SlotStackHolder holder = this.inventory.get(slot);
        if (holder.itemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack extract = this.copyWithSize(holder.itemStack, Math.min(amount, holder.itemStack.func_190916_E()));
        if (extract.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            holder.itemStack = this.copyWithSize(holder.itemStack, holder.itemStack.func_190916_E() - extract.func_190916_E());
            if (this.listener != null) {
                this.listener.onChange();
            }
        }
        this.getOwner().markForUpdate();
        return extract;
    }

    @Nonnull
    private ItemStack copyWithSize(@Nonnull ItemStack stack, int amount) {
        if (stack.func_190926_b() || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = stack.func_77946_l();
        s.func_190920_e(Math.min(amount, stack.func_77976_d()));
        return s;
    }

    private boolean arrayContains(int[] array, int i) {
        for (int id : array) {
            if (id != i) continue;
            return true;
        }
        return false;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("inSlots", this.inSlots);
        tag.func_74783_a("outSlots", this.outSlots);
        tag.func_74783_a("miscSlots", this.miscSlots);
        NBTTagList inv = new NBTTagList();
        for (Integer slot : this.inventory.keySet()) {
            SlotStackHolder holder = this.inventory.get(slot);
            NBTTagCompound holderTag = new NBTTagCompound();
            holderTag.func_74757_a("holderEmpty", holder.itemStack.func_190926_b());
            holderTag.func_74768_a("holderId", slot.intValue());
            if (!holder.itemStack.func_190926_b()) {
                holder.itemStack.func_77955_b(holderTag);
            }
            inv.func_74742_a((NBTBase)holderTag);
        }
        tag.func_74782_a("inventoryArray", (NBTBase)inv);
        int[] sides = new int[this.accessibleSides.size()];
        for (int i = 0; i < this.accessibleSides.size(); ++i) {
            EnumFacing side = this.accessibleSides.get(i);
            sides[i] = side.ordinal();
        }
        tag.func_74783_a("sides", sides);
        return tag;
    }

    public void readNBT(NBTTagCompound tag) {
        int[] sides;
        this.inSlots = tag.func_74759_k("inSlots");
        this.outSlots = tag.func_74759_k("outSlots");
        this.miscSlots = tag.func_74759_k("miscSlots");
        this.inventory.clear();
        NBTTagList list = tag.func_150295_c("inventoryArray", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound holderTag = list.func_150305_b(i);
            int slot = holderTag.func_74762_e("holderId");
            boolean isEmpty = holderTag.func_74767_n("holderEmpty");
            ItemStack stack = ItemStack.field_190927_a;
            if (!isEmpty) {
                stack = new ItemStack(holderTag);
            }
            SlotStackHolder holder = new SlotStackHolder(slot);
            holder.itemStack = stack;
            this.inventory.put(slot, holder);
        }
        for (int i : sides = tag.func_74759_k("sides")) {
            this.accessibleSides.add(EnumFacing.values()[i]);
        }
        if (this.listener != null) {
            this.listener.onChange();
        }
    }

    private boolean canMergeItemStacks(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b() || other.func_190926_b() || !stack.func_77985_e() || !other.func_77985_e()) {
            return false;
        }
        return stack.func_77969_a(other) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    public static IOInventory deserialize(TileEntitySynchronized owner, NBTTagCompound tag) {
        IOInventory inv = new IOInventory(owner);
        inv.readNBT(tag);
        return inv;
    }

    public boolean hasCapability(EnumFacing facing) {
        return facing == null || this.accessibleSides.contains(facing);
    }

    public IItemHandlerModifiable getCapability(EnumFacing facing) {
        if (this.hasCapability(facing)) {
            return this;
        }
        return null;
    }

    public int calcRedstoneFromInventory() {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < this.getSlots(); ++j) {
            ItemStack itemstack = this.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(this.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)this.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static IOInventory mergeBuild(TileEntitySynchronized tile, IOInventory ... inventories) {
        IOInventory merged = new IOInventory(tile);
        int slotOffset = 0;
        for (IOInventory inventory : inventories) {
            for (Integer key : inventory.inventory.keySet()) {
                merged.inventory.put(key + slotOffset, inventory.inventory.get(key));
            }
            for (Integer key : inventory.slotLimits.keySet()) {
                merged.slotLimits.put(key + slotOffset, inventory.slotLimits.get(key));
            }
            slotOffset += inventory.inventory.size();
        }
        return merged;
    }

    public static class GuiAccess
    implements IItemHandlerModifiable {
        private final IOInventory inventory;

        public GuiAccess(IOInventory inventory) {
            this.inventory = inventory;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.inventory.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.inventory.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.inventory.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            boolean allowPrev = this.inventory.allowAnySlots;
            this.inventory.allowAnySlots = true;
            ItemStack insert = this.inventory.insertItem(slot, stack, simulate);
            this.inventory.allowAnySlots = allowPrev;
            return insert;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            boolean allowPrev = this.inventory.allowAnySlots;
            this.inventory.allowAnySlots = true;
            ItemStack extract = this.inventory.extractItem(slot, amount, simulate);
            this.inventory.allowAnySlots = allowPrev;
            return extract;
        }

        public int getSlotLimit(int slot) {
            return this.inventory.getSlotLimit(slot);
        }
    }

    private static class SlotStackHolder {
        private final int slotId;
        @Nonnull
        private ItemStack itemStack = ItemStack.field_190927_a;

        private SlotStackHolder(int slotId) {
            this.slotId = slotId;
        }
    }
}

