/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.registry;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.item.ItemBlockCustomName;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.item.ItemConstructTool;
import hellfirepvp.modularmachinery.common.item.ItemDynamicColor;
import hellfirepvp.modularmachinery.common.item.ItemModularium;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;

public class RegistryItems {
    private static List<Item> itemModelRegister = Lists.newArrayList();
    static List<Item> itemBlocks = Lists.newArrayList();
    public static List<ItemDynamicColor> pendingDynamicColorItems = new LinkedList<ItemDynamicColor>();

    public static void initialize() {
        ItemsMM.blueprint = RegistryItems.prepareRegister(new ItemBlueprint());
        ItemsMM.modularium = RegistryItems.prepareRegister(new ItemModularium());
        ItemsMM.constructTool = RegistryItems.prepareRegister(new ItemConstructTool());
        RegistryItems.registerItemBlocks();
        RegistryItems.registerItemModels();
    }

    private static <T extends Item> T prepareRegister(T item) {
        String name = item.getClass().getSimpleName().toLowerCase();
        ((Item)item.setRegistryName(name)).func_77655_b("modularmachinery." + name);
        return RegistryItems.register(item);
    }

    private static <T extends Item> T register(T item) {
        itemModelRegister.add(item);
        CommonProxy.registryPrimer.register(item);
        if (item instanceof ItemDynamicColor) {
            pendingDynamicColorItems.add((ItemDynamicColor)item);
        }
        return item;
    }

    private static void registerItemBlocks() {
        itemBlocks.forEach(RegistryItems::register);
    }

    private static void registerItemModels() {
        itemModelRegister.stream().filter(i -> !(i instanceof ItemBlockCustomName)).forEach(ModularMachinery.proxy::registerItemModel);
    }
}

