/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.tools.MathTool;
import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public final class Column
implements IPlacementSequence {
    private final Region region;

    public static Column extendFrom(BlockPos hit, EnumFacing side, int range) {
        return new Column(hit, hit.func_177967_a(side, range - 1));
    }

    public static Column centerAt(BlockPos center, EnumFacing.Axis axis, int length) {
        EnumFacing positive = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis);
        EnumFacing negative = positive.func_176734_d();
        BlockPos base = center.func_177967_a(negative, (length - 1) / 2);
        return new Column(base, base.func_177967_a(positive, MathTool.floorToOdd(length) - 1));
    }

    private Column(BlockPos source, BlockPos target) {
        this.region = new Region((Vec3i)source, (Vec3i)target);
    }

    @VisibleForTesting
    private Column(Region region) {
        this.region = region;
    }

    @Override
    public Region getBoundingBox() {
        return this.region;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.region.mayContain(x, y, z);
    }

    @Override
    public IPlacementSequence copy() {
        return new Column(this.region);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return this.region.iterator();
    }

    @Override
    public Spliterator<BlockPos> spliterator() {
        return this.region.spliterator();
    }
}

