/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.ClientEventHandler;
import assets.recipehandler.RecipeMod;
import com.google.common.base.Predicates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public final class GuiEventHandler {
    public static final GuiEventHandler INSTANCE = new GuiEventHandler();
    private int deltaX = 0;

    private GuiEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEffectInGui(GuiScreenEvent.PotionShiftEvent potionShift) {
        if (potionShift.getGui() instanceof GuiContainer) {
            this.deltaX = 60;
        }
    }

    @SubscribeEvent
    public void onPostInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)event.getGui();
            int xOffset = ClientEventHandler.xOffset;
            int yOffset = ClientEventHandler.yOffset;
            CreativeButton button = null;
            if (container instanceof GuiContainerCreative) {
                if (!ClientEventHandler.creativeCraft) {
                    return;
                }
                button = new CreativeButton(event.getButtonList().size() + 2, xOffset += 166, yOffset += 34);
            } else {
                Slot slot;
                InventoryCrafting craft = RecipeMod.registry.craftingHandler.getCraftingMatrix(container.field_147002_h);
                if (craft != null && (slot = RecipeMod.registry.craftingHandler.getResultSlot(container.field_147002_h, craft, 0)) != null) {
                    button = new CreativeButton(event.getButtonList().size(), xOffset += slot.field_75223_e + 2, yOffset += slot.field_75221_f + 22);
                }
            }
            if (button != null) {
                button.field_146128_h += this.deltaX;
                event.getButtonList().add(button);
            }
            this.deltaX = 0;
        }
    }

    @SubscribeEvent
    public void onPostBookToggle(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getButton() instanceof GuiButtonImage && event.getGui() instanceof GuiContainer && event.getGui() instanceof IRecipeShownListener) {
            GuiContainer container = (GuiContainer)event.getGui();
            event.getButtonList().stream().filter(Predicates.instanceOf(CreativeButton.class)).forEach(guiButton -> ((CreativeButton)((Object)guiButton)).setupXY(container));
        }
    }

    final class CreativeButton
    extends GuiButton {
        private final ResourceLocation texture;
        private static final int WIDTH = 12;
        private static final int HEIGHT = 16;
        private final int xOffset;
        private final int yOffset;
        private boolean firstDraw;

        public CreativeButton(int id, int posX, int posY) {
            super(id, posX, posY, 12, 16, "0");
            this.texture = new ResourceLocation("textures/gui/container/villager.png");
            this.firstDraw = true;
            this.xOffset = posX;
            this.yOffset = posY;
        }

        public void setupXY(GuiContainer container) {
            this.field_146128_h = container.getGuiLeft() + this.xOffset;
            this.field_146129_i = container.getGuiTop() + this.yOffset;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partTicks) {
            if (mc.field_71462_r instanceof GuiContainerCreative) {
                boolean bl = this.field_146125_m = ClientEventHandler.creativeCraft && ((GuiContainerCreative)mc.field_71462_r).func_147056_g() == CreativeTabs.field_78036_m.func_78021_a();
            }
            if (this.field_146125_m) {
                int crafts;
                if (this.firstDraw) {
                    this.setupXY((GuiContainer)mc.field_71462_r);
                    this.firstDraw = false;
                }
                if (mc.field_71462_r instanceof GuiContainerCreative) {
                    Slot slot;
                    GuiContainerCreative creative = (GuiContainerCreative)mc.field_71462_r;
                    for (int i = 0; i < 4; ++i) {
                        slot = creative.field_147002_h.func_75139_a(i + 5);
                        slot.field_75223_e = i / 2 * 54;
                        if (i < 2) {
                            slot.field_75223_e = 14;
                        }
                        slot = creative.field_147002_h.func_75139_a(i + 1);
                        slot.field_75223_e = 108 + i % 2 * 18;
                        slot.field_75221_f = 6 + i / 2 * 18;
                    }
                    slot = creative.field_147002_h.func_75139_a(0);
                    slot.field_75223_e = 164;
                    slot.field_75221_f = 16;
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/creative_inventory/tab_inventory.png"));
                    creative.func_73729_b(creative.getGuiLeft() + 13, creative.getGuiTop() + 5, 107, 5, 18, 44);
                    mc.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
                    creative.func_73729_b(creative.getGuiLeft() + 106, creative.getGuiTop() + 3, 96, 15, 76, 47);
                    GlStateManager.func_179101_C();
                    GlStateManager.func_179097_i();
                }
                if ((crafts = RecipeMod.registry.craftingHandler.getNumberOfCraft(mc.field_71439_g.field_71070_bA, mc.field_71439_g.field_70170_p)) == -1) {
                    this.field_146124_l = false;
                    return;
                }
                boolean bl = this.field_146124_l = crafts > 1;
                if (this.field_146124_l || !ClientEventHandler.onlyNecessary) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(this.texture);
                    int k = 177;
                    if (!this.field_146124_l) {
                        k += this.field_146120_f * 2;
                    } else if (super.func_146116_c(mc, mouseX, mouseY)) {
                        k += this.field_146120_f;
                    }
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, k, 2, this.field_146120_f, this.field_146121_g);
                    if (!ClientEventHandler.cornerText) {
                        this.field_146126_j = String.valueOf(crafts);
                        int l = this.field_146124_l ? 0xFFFFFF : 0xA0A0A0;
                        this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h, this.field_146129_i + this.field_146121_g / 2, l);
                    }
                }
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            boolean onButton = super.func_146116_c(mc, mouseX, mouseY);
            if (onButton) {
                ((ClientEventHandler)RecipeMod.registry).pressed();
            }
            return onButton;
        }
    }
}

