/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonReward
extends Button {
    public final GuiQuestTree treeGui;
    public final Reward reward;

    public ButtonReward(Panel panel, Reward r) {
        super(panel, r.getTitle(), r.getIcon());
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.reward = r;
        this.setSize(18, 18);
    }

    public String getTitle() {
        if (this.reward.isTeamReward()) {
            return TextFormatting.BLUE + super.getTitle();
        }
        return super.getTitle();
    }

    public void addMouseOverText(List<String> list) {
        if (ButtonReward.isShiftKeyDown() && ButtonReward.isCtrlKeyDown()) {
            list.add(TextFormatting.DARK_GRAY + this.reward.toString());
        }
        if (this.reward.addTitleInMouseOverText()) {
            list.add(this.getTitle());
        }
        if (this.reward.isTeamReward()) {
            list.add(TextFormatting.BLUE + "[" + I18n.func_135052_a((String)"ftbquests.reward.team_reward", (Object[])new Object[0]) + "]");
        }
        this.reward.addMouseOverText(list);
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public WidgetType getWidgetType() {
        if (!ClientQuestFile.existsWithTeam() || !this.reward.quest.isComplete(ClientQuestFile.INSTANCE.self)) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (ClientQuestFile.existsWithTeam()) {
                this.reward.onButtonClicked(this.reward.quest.isComplete(ClientQuestFile.INSTANCE.self) && !ClientQuestFile.INSTANCE.self.isRewardClaimedSelf(this.reward));
            }
        } else if (button.isRight() && ClientQuestFile.exists() && ClientQuestFile.INSTANCE.canEdit()) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            GuiQuestTree.addObjectMenuItems(contextMenu, (IOpenableGui)this.getGui(), this.reward);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.reward.getIngredient();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(theme, x, y, w, h);
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        String s;
        int bs = h >= 32 ? 32 : 16;
        this.drawBackground(theme, x, y, w, h);
        this.drawIcon(theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        boolean completed = false;
        if (!ClientQuestFile.existsWithTeam()) {
            GuiIcons.CLOSE.draw(x + w - 9, y + 1, 8, 8);
        } else if (ClientQuestFile.INSTANCE.self.isRewardClaimedSelf(this.reward)) {
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(x + w - 9, y + 1, 8, 8);
            completed = true;
        } else if (this.reward.quest.isComplete(ClientQuestFile.INSTANCE.self)) {
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(x + w - 9, y + 1, 8, 8);
        }
        GlStateManager.func_179121_F();
        if (!completed && !(s = this.reward.getButtonText()).isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 19.0f - (float)theme.getStringWidth(s) / 2.0f), (float)((float)y + 15.0f), (float)500.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            theme.drawString(s, 0, 0, Color4I.WHITE, 2);
            GlStateManager.func_179121_F();
        }
    }
}

