/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.block;

import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.tile.IHasConfig;
import com.feed_the_beast.ftbquests.tile.TilePlayerDetector;
import com.feed_the_beast.ftbquests.tile.TileRedstoneDetector;
import com.feed_the_beast.ftbquests.tile.TileWithTeam;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDetector
extends Block {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);

    public BlockDetector() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.REDSTONE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.VALUES[meta]));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return (TileEntity)((Variant)((Object)state.func_177229_b(VARIANT))).tileEntitySupplier.get();
    }

    public int func_180651_a(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (Variant variant : Variant.VALUES) {
            items.add((Object)new ItemStack((Block)this, 1, variant.ordinal()));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && FTBQuests.canEdit(player) && (tileEntity = world.func_175625_s(pos)) instanceof IHasConfig) {
            ((IHasConfig)tileEntity).editConfig((EntityPlayerMP)player, true);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileBase) {
            ((TileBase)tileEntity).readFromItem(stack);
            if (tileEntity instanceof TileWithTeam) {
                ((TileWithTeam)tileEntity).setIDFromPlacer(placer);
            }
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tileEntity;
        if (state.func_177229_b(VARIANT) == Variant.REDSTONE && (tileEntity = world.func_175625_s(pos)) instanceof TileRedstoneDetector) {
            ((TileRedstoneDetector)tileEntity).checkRedstone();
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.func_177229_b(VARIANT) == Variant.REDSTONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        QuestObject object;
        if (world == null || !ClientQuestFile.exists()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        QuestObject questObject = object = nbt == null ? null : ClientQuestFile.INSTANCE.get(nbt.func_74762_e("object"));
        if (object != null) {
            tooltip.add(object.getYellowDisplayName());
        }
    }

    public static enum Variant implements IStringSerializable
    {
        REDSTONE("redstone", TileRedstoneDetector.class, TileRedstoneDetector::new),
        PLAYER("player", TilePlayerDetector.class, TilePlayerDetector::new);

        public static final Variant[] VALUES;
        private final String name;
        public final Class<? extends TileBase> clazz;
        private final Supplier<TileBase> tileEntitySupplier;

        private Variant(String n2, Class<? extends TileBase> c, Supplier<TileBase> t) {
            this.name = n2;
            this.clazz = c;
            this.tileEntitySupplier = t;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            VALUES = Variant.values();
        }
    }
}

