/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics;

import knightminer.ceramics.CommonProxy;
import knightminer.ceramics.blocks.BlockBarrel;
import knightminer.ceramics.blocks.BlockBarrelPorcelain;
import knightminer.ceramics.blocks.BlockBarrelStained;
import knightminer.ceramics.blocks.BlockBarrelUnfired;
import knightminer.ceramics.blocks.BlockChannel;
import knightminer.ceramics.blocks.BlockClayBucket;
import knightminer.ceramics.blocks.BlockClayHard;
import knightminer.ceramics.blocks.BlockClayRainbow;
import knightminer.ceramics.blocks.BlockClaySlab;
import knightminer.ceramics.blocks.BlockClaySoft;
import knightminer.ceramics.blocks.BlockClayWall;
import knightminer.ceramics.blocks.BlockEnumBase;
import knightminer.ceramics.blocks.BlockFaucet;
import knightminer.ceramics.blocks.BlockStained;
import knightminer.ceramics.blocks.BlockStairsEnum;
import knightminer.ceramics.items.ItemArmorClay;
import knightminer.ceramics.items.ItemArmorClayRaw;
import knightminer.ceramics.items.ItemBlockBarrel;
import knightminer.ceramics.items.ItemBlockChannel;
import knightminer.ceramics.items.ItemBlockEnum;
import knightminer.ceramics.items.ItemBlockEnumSlab;
import knightminer.ceramics.items.ItemClayBucket;
import knightminer.ceramics.items.ItemClayShears;
import knightminer.ceramics.items.ItemClayUnfired;
import knightminer.ceramics.legacy.TileEntityRenamer;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.library.CreativeTab;
import knightminer.ceramics.library.Util;
import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.plugin.bwm.BetterWithModsPlugin;
import knightminer.ceramics.plugin.tconstruct.TConstructPlugin;
import knightminer.ceramics.tileentity.TileBarrel;
import knightminer.ceramics.tileentity.TileBarrelExtension;
import knightminer.ceramics.tileentity.TileChannel;
import knightminer.ceramics.tileentity.TileFaucet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ceramics", version="1.12-1.3.7", name="Ceramics", dependencies="required-after:forge@[14.21.1.2394,);after:tconstruct", acceptedMinecraftVersions="[1.12]")
public class Ceramics {
    public static final String name = "Ceramics";
    public static final String modID = "ceramics";
    public static final String version = "1.12-1.3.7";
    @SidedProxy(clientSide="knightminer.ceramics.ClientProxy", serverSide="knightminer.ceramics.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTab tab;
    public static final Logger log;
    public static Block clayBarrel;
    public static Block porcelainBarrel;
    public static Block porcelainBarrelExtension;
    public static Block clayBarrelStained;
    public static Block clayBarrelStainedExtension;
    public static Block faucet;
    public static Block channel;
    public static Block clayBarrelUnfired;
    public static BlockClaySoft claySoft;
    public static Block clayBucketBlock;
    public static BlockClayHard clayHard;
    public static BlockClaySlab claySlab;
    public static BlockClayWall clayWall;
    public static BlockStained porcelain;
    public static BlockClayRainbow rainbowClay;
    public static Block stairsPorcelainBricks;
    public static Block stairsDarkBricks;
    public static Block stairsGoldenBricks;
    public static Block stairsMarineBricks;
    public static Block stairsDragonBricks;
    public static Block stairsLavaBricks;
    public static Block stairsRainbowBricks;
    public static Block stairsMonochromeBricks;
    public static Item clayUnfired;
    public static ItemClayBucket clayBucket;
    public static Item clayShears;
    public static ItemArmor.ArmorMaterial clayArmor;
    public static Item clayHelmet;
    public static Item clayChestplate;
    public static Item clayLeggings;
    public static Item clayBoots;
    public static ItemArmor.ArmorMaterial clayArmorRaw;
    public static Item clayHelmetRaw;
    public static Item clayChestplateRaw;
    public static Item clayLeggingsRaw;
    public static Item clayBootsRaw;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load(event);
        clayArmor = EnumHelper.addArmorMaterial((String)Util.prefix("clay"), (String)"cermamics:clay", (int)4, (int[])new int[]{1, 2, 3, 1}, (int)7, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f);
        Ceramics.clayArmor.repairMaterial = new ItemStack(Items.field_151118_aC);
        clayArmorRaw = EnumHelper.addArmorMaterial((String)Util.prefix("clay_raw"), (String)"cermamics:clay_raw", (int)1, (int[])new int[]{1, 1, 1, 1}, (int)0, (SoundEvent)SoundEvents.field_187587_bZ, (float)0.0f);
        Ceramics.clayArmor.repairMaterial = new ItemStack(Items.field_151119_aD);
        CeramicsNetwork.registerPackets();
        proxy.preInit();
        ModFixs fixer = FMLCommonHandler.instance().getDataFixer().init(modID, 1);
        fixer.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileEntityRenamer());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Ceramics.oredict(clayUnfired, ItemClayUnfired.UnfiredType.CLAY_PLATE_RAW.getMeta(), "plateClayRaw");
        Ceramics.oredict(clayUnfired, ItemClayUnfired.UnfiredType.CLAY_PLATE.getMeta(), "plateClay", "plateBrick");
        if (Config.fancyBricksEnabled) {
            GameRegistry.addSmelting((Block)Blocks.field_150336_V, (ItemStack)new ItemStack((Block)clayHard, 1, BlockClayHard.ClayTypeHard.DARK_BRICKS.getMeta()), (float)0.1f);
            GameRegistry.addSmelting((ItemStack)new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.BRICK.func_176624_a()), (ItemStack)new ItemStack((Block)claySlab, 1, BlockClayHard.ClayTypeHard.DARK_BRICKS.getMeta()), (float)0.1f);
            GameRegistry.addSmelting((ItemStack)new ItemStack((Block)clayWall, 1, BlockClayWall.ClayWallType.BRICKS.getMeta()), (ItemStack)new ItemStack((Block)clayWall, 1, BlockClayWall.ClayWallType.DARK_BRICKS.getMeta()), (float)0.1f);
            GameRegistry.addSmelting((Block)Blocks.field_150389_bf, (ItemStack)new ItemStack(stairsDarkBricks), (float)0.1f);
        }
        if (Config.porcelainEnabled) {
            Ceramics.oredict(clayUnfired, ItemClayUnfired.UnfiredType.PORCELAIN.getMeta(), "clayPorcelain");
            GameRegistry.addSmelting((ItemStack)new ItemStack((Block)claySoft, 1, BlockClaySoft.ClayTypeSoft.PORCELAIN.getMeta()), (ItemStack)new ItemStack((Block)porcelain, 1, EnumDyeColor.WHITE.func_176765_a()), (float)0.1f);
            if (Config.porcelainOredictSmelting) {
                for (ItemStack porcelain : OreDictionary.getOres((String)"clayPorcelain")) {
                    GameRegistry.addSmelting((ItemStack)porcelain, (ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.PORCELAIN_BRICK.getMeta()), (float)0.1f);
                }
                MinecraftForge.EVENT_BUS.register(FurnaceOredictRecipeHandler.class);
            } else {
                GameRegistry.addSmelting((ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.PORCELAIN.getMeta()), (ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.PORCELAIN_BRICK.getMeta()), (float)0.1f);
            }
        }
        if (Config.bucketEnabled) {
            ItemStack unfiredBucket = Config.placeClayBucket ? new ItemStack(clayBucketBlock) : new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.BUCKET.getMeta());
            GameRegistry.addSmelting((ItemStack)unfiredBucket, (ItemStack)new ItemStack((Item)clayBucket), (float)0.5f);
        }
        if (Config.shearsEnabled) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.SHEARS.getMeta()), (ItemStack)new ItemStack(clayShears), (float)0.5f);
        }
        if (Config.armorEnabled) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.CLAY_PLATE_RAW.getMeta()), (ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.CLAY_PLATE.getMeta()), (float)0.5f);
        }
        if (Config.barrelEnabled) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(clayBarrelUnfired, 1, 0), (ItemStack)new ItemStack(clayBarrel, 1, 0), (float)0.5f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(clayBarrelUnfired, 1, 1), (ItemStack)new ItemStack(clayBarrel, 1, 1), (float)0.5f);
            if (Config.porcelainEnabled) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(clayBarrelUnfired, 1, 2), (ItemStack)new ItemStack(porcelainBarrel, 1, 0), (float)0.5f);
                GameRegistry.addSmelting((ItemStack)new ItemStack(clayBarrelUnfired, 1, 3), (ItemStack)new ItemStack(porcelainBarrelExtension, 1, 0), (float)0.5f);
            }
        }
        if (Config.faucetEnabled) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.FAUCET.getMeta()), (ItemStack)new ItemStack(faucet, 1), (float)0.5f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.CHANNEL.getMeta()), (ItemStack)new ItemStack(channel, 1), (float)0.5f);
        }
        if (Loader.isModLoaded((String)"betterwithmods")) {
            BetterWithModsPlugin.init();
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Config.bucketEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)clayBucket);
        }
        if (Config.shearsEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)clayShears);
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            TConstructPlugin.postInit();
        }
    }

    public static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        block.func_149663_c(Util.prefix(name));
        block.setRegistryName(Util.getResource(name));
        registry.register(block);
        return block;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockStairsEnum<E> registerStairsFrom(IForgeRegistry<Block> registry, BlockEnumBase<E> block, E value, String name) {
        return Ceramics.registerBlock(registry, new BlockStairsEnum<E>(block, value), name);
    }

    public static ItemBlock registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        return Ceramics.registerItemBlock(registry, new ItemBlock(block));
    }

    public static <T extends ItemBlock> T registerItemBlock(IForgeRegistry<Item> registry, T item) {
        Block block = item.func_179223_d();
        item.func_77655_b(block.func_149739_a());
        item.setRegistryName(block.getRegistryName());
        registry.register(item);
        return item;
    }

    public static <T extends Item> T registerItem(IForgeRegistry<Item> registry, T block, String name) {
        block.func_77655_b(Util.prefix(name));
        block.setRegistryName(Util.getResource(name));
        registry.register(block);
        return block;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        GameRegistry.registerTileEntity(teClazz, (String)Util.resource(name));
    }

    public static void oredict(Item item, String ... name) {
        Ceramics.oredict(item, Short.MAX_VALUE, name);
    }

    public static void oredict(Block block, String ... name) {
        Ceramics.oredict(block, Short.MAX_VALUE, name);
    }

    public static void oredict(Item item, int meta, String ... name) {
        Ceramics.oredict(new ItemStack(item, 1, meta), name);
    }

    public static void oredict(Block block, int meta, String ... name) {
        Ceramics.oredict(new ItemStack(block, 1, meta), name);
    }

    public static void oredict(ItemStack stack, String ... names) {
        if (stack != null && stack.func_77973_b() != null) {
            for (String name : names) {
                OreDictionary.registerOre((String)name, (ItemStack)stack);
            }
        }
    }

    static {
        tab = new CreativeTab(modID, new ItemStack(Items.field_151118_aC));
        log = LogManager.getLogger((String)modID);
        FluidRegistry.enableUniversalBucket();
    }

    public static class FurnaceOredictRecipeHandler {
        @SubscribeEvent
        public static void onOredictRegister(OreDictionary.OreRegisterEvent event) {
            if ("clayPorcelain".equals(event.getName())) {
                GameRegistry.addSmelting((ItemStack)event.getOre(), (ItemStack)new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.PORCELAIN_BRICK.getMeta()), (float)0.1f);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="ceramics")
    public static class Registration {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry r = event.getRegistry();
            clayHard = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockClayHard(), "clay_hard");
            claySoft = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockClaySoft(), "clay_soft");
            claySlab = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockClaySlab(), "clay_slab");
            clayWall = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockClayWall(), "clay_wall");
            porcelain = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockStained(), "porcelain");
            stairsPorcelainBricks = Ceramics.registerStairsFrom((IForgeRegistry<Block>)r, clayHard, BlockClayHard.ClayTypeHard.PORCELAIN_BRICKS, "porcelain_bricks_stairs");
            rainbowClay = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockClayRainbow(), "rainbow_clay");
            stairsRainbowBricks = Ceramics.registerStairsFrom((IForgeRegistry<Block>)r, clayHard, BlockClayHard.ClayTypeHard.RAINBOW_BRICKS, "rainbow_bricks_stairs");
            stairsDarkBricks = Ceramics.registerStairsFrom((IForgeRegistry<Block>)r, clayHard, BlockClayHard.ClayTypeHard.DARK_BRICKS, "dark_bricks_stairs");
            stairsGoldenBricks = Ceramics.registerStairsFrom((IForgeRegistry<Block>)r, clayHard, BlockClayHard.ClayTypeHard.GOLDEN_BRICKS, "golden_bricks_stairs");
            stairsMarineBricks = Ceramics.registerStairsFrom((IForgeRegistry<Block>)r, clayHard, BlockClayHard.ClayTypeHard.MARINE_BRICKS, "marine_bricks_stairs");
            stairsDragonBricks = Ceramics.registerStairsFrom((IForgeRegistry<Block>)r, clayHard, BlockClayHard.ClayTypeHard.DRAGON_BRICKS, "dragon_bricks_stairs");
            stairsLavaBricks = Ceramics.registerStairsFrom((IForgeRegistry<Block>)r, clayHard, BlockClayHard.ClayTypeHard.LAVA_BRICKS, "lava_bricks_stairs");
            stairsMonochromeBricks = Ceramics.registerStairsFrom((IForgeRegistry<Block>)r, clayHard, BlockClayHard.ClayTypeHard.MONOCHROME_BRICKS, "monochrome_bricks_stairs");
            clayBarrelUnfired = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockBarrelUnfired(), "clay_barrel_unfired");
            clayBarrel = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockBarrel(), "clay_barrel");
            clayBarrelStained = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockBarrelStained(false), "clay_barrel_stained");
            clayBarrelStainedExtension = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockBarrelStained(true), "clay_barrel_stained_extension");
            porcelainBarrel = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockBarrelPorcelain(false), "porcelain_barrel");
            porcelainBarrelExtension = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockBarrelPorcelain(true), "porcelain_barrel_extension");
            clayBucketBlock = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockClayBucket(), "clay_bucket_block");
            Ceramics.registerTE(TileBarrel.class, "barrel");
            Ceramics.registerTE(TileBarrelExtension.class, "barrel_extension");
            faucet = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockFaucet(), "faucet");
            Ceramics.registerTE(TileFaucet.class, "faucet");
            channel = Ceramics.registerBlock((IForgeRegistry<Block>)r, new BlockChannel(), "channel");
            Ceramics.registerTE(TileChannel.class, "channel");
            if (!Config.porcelainEnabled) {
                channel.func_149663_c(Util.prefix("channel_clay"));
                faucet.func_149663_c(Util.prefix("faucet_clay"));
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry r = event.getRegistry();
            clayUnfired = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemClayUnfired(), "unfired_clay");
            clayBucket = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemClayBucket(), "clay_bucket");
            tab.setIcon(new ItemStack((Item)clayBucket));
            clayShears = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemClayShears(), "clay_shears");
            clayHelmet = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemArmorClay(EntityEquipmentSlot.HEAD), "clay_helmet");
            clayChestplate = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemArmorClay(EntityEquipmentSlot.CHEST), "clay_chestplate");
            clayLeggings = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemArmorClay(EntityEquipmentSlot.LEGS), "clay_leggings");
            clayBoots = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemArmorClay(EntityEquipmentSlot.FEET), "clay_boots");
            clayHelmetRaw = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemArmorClayRaw(EntityEquipmentSlot.HEAD), "clay_helmet_raw");
            clayChestplateRaw = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemArmorClayRaw(EntityEquipmentSlot.CHEST), "clay_chestplate_raw");
            clayLeggingsRaw = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemArmorClayRaw(EntityEquipmentSlot.LEGS), "clay_leggings_raw");
            clayBootsRaw = Ceramics.registerItem((IForgeRegistry<Item>)r, new ItemArmorClayRaw(EntityEquipmentSlot.FEET), "clay_boots_raw");
            ItemBlock clayBucket = new ItemBlock(clayBucketBlock);
            clayBucket.func_77625_d(16);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, clayBucket);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockEnum(clayHard));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockEnum(claySoft));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockEnum(clayWall));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockEnumSlab<BlockClayHard.ClayTypeHard>(claySlab));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockEnum(porcelain));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, stairsPorcelainBricks);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockEnum(rainbowClay));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, stairsRainbowBricks);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, stairsDarkBricks);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, stairsGoldenBricks);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, stairsMarineBricks);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, stairsDragonBricks);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, stairsLavaBricks);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, stairsMonochromeBricks);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockBarrel(clayBarrelUnfired, "clay", "clay_extension", "porcelain", "porcelain_extension"));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockBarrel(clayBarrel, "barrel", "barrel_extension"));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemCloth(clayBarrelStained));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemCloth(clayBarrelStainedExtension));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemCloth(porcelainBarrel));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemCloth(porcelainBarrelExtension));
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, faucet);
            Ceramics.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockChannel(channel));
        }
    }
}

