/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.trials;

import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import xt9.deepmoblearning.common.config.Config;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.mobmetas.MobMetaFactory;
import xt9.deepmoblearning.common.trials.EndermanTrial;
import xt9.deepmoblearning.common.trials.SkeletonTrial;
import xt9.deepmoblearning.common.trials.SlimeTrial;
import xt9.deepmoblearning.common.trials.SpiderTrial;
import xt9.deepmoblearning.common.trials.Trial;
import xt9.deepmoblearning.common.trials.WitchTrial;
import xt9.deepmoblearning.common.trials.WitherSkeletonTrial;
import xt9.deepmoblearning.common.trials.ZombieTrial;
import xt9.deepmoblearning.common.util.MathHelper;
import xt9.deepmoblearning.common.util.Tier;
import xt9.deepmoblearning.common.util.TrialKey;

public class TrialFactory {
    public static Trial createTrial(String key) {
        Trial trial = new ZombieTrial("zombie", new int[]{4, 5, 6, 6, 10, 14, 20});
        if (key.equals("zombie")) {
            trial = new ZombieTrial("zombie", new int[]{4, 5, 6, 6, 10, 14, 20});
        } else if (key.equals("enderman")) {
            trial = new EndermanTrial("enderman", new int[]{2, 2, 3, 4, 4, 7, 9});
        } else if (key.equals("skeleton")) {
            trial = new SkeletonTrial("skeleton", new int[]{4, 4, 5, 7, 9, 11, 16});
        } else if (key.equals("witch")) {
            trial = new WitchTrial("witch", new int[]{2, 2, 3, 3, 4, 5, 6});
        } else if (key.equals("spider")) {
            trial = new SpiderTrial("spider", new int[]{3, 4, 5, 5, 6, 8, 10});
        } else if (key.equals("slime")) {
            trial = new SlimeTrial("slime", new int[]{4, 5, 5, 7, 7, 9, 15});
        } else if (key.equals("witherskeleton")) {
            trial = new WitherSkeletonTrial("witherskeleton", new int[]{2, 3, 4, 4, 6, 8, 11});
        }
        return trial;
    }

    public static NonNullList<String> getValidTrials() {
        NonNullList validKeys = NonNullList.func_191196_a();
        validKeys.add((Object)"zombie");
        validKeys.add((Object)"enderman");
        validKeys.add((Object)"skeleton");
        validKeys.add((Object)"witch");
        validKeys.add((Object)"spider");
        validKeys.add((Object)"slime");
        validKeys.add((Object)"witherskeleton");
        return validKeys;
    }

    public static NonNullList<String> getValidTrialsHumanReadable() {
        NonNullList mobNames = NonNullList.func_191196_a();
        TrialFactory.getValidTrials().forEach(key -> {
            MobMetaData data = MobMetaFactory.createMobMetaData(key);
            mobNames.add((Object)data.getName());
        });
        return mobNames;
    }

    public static boolean isMobKeyValidForTrial(String key) {
        return TrialFactory.getValidTrials().contains((Object)key);
    }

    public static NonNullList<ItemStack> getRewards(ItemStack trialKey) {
        NonNullList rewards = NonNullList.func_191196_a();
        Trial trialData = TrialFactory.createTrial(TrialKey.getMobKey(trialKey));
        rewards.addAll(trialData.getTrialRewards(TrialKey.getTier(trialKey)));
        if (Tier.isMaxTier(TrialKey.getTier(trialKey))) {
            NonNullList<ItemStack> maxTierRewards = Config.LootParser.getTrialRewards(trialData.getMobKey());
            for (int i = 0; i < MathHelper.ensureRange(maxTierRewards.size(), 0, 3); ++i) {
                rewards.add(maxTierRewards.get(i));
            }
        }
        return rewards;
    }
}

