/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.mobmetas;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import xt9.deepmoblearning.common.config.Config;
import xt9.deepmoblearning.common.items.ItemLivingMatter;
import xt9.deepmoblearning.common.items.ItemPristineMatter;
import xt9.deepmoblearning.common.util.MathHelper;

public abstract class MobMetaData {
    protected String name;
    private String pluralName;
    protected String key;
    protected int numberOfHearts;
    protected int interfaceScale;
    protected int interfaceOffsetX;
    protected int interfaceOffsetY;
    protected ItemLivingMatter livingMatter;
    protected ItemPristineMatter pristineMatter;
    protected String[] mobTrivia;
    private String[] mobRegistryNames;

    public MobMetaData(String key, String name, String pluralName, int numberOfHearts, int interfaceScale, int interfaceOffsetX, int interfaceOffsetY, Item livingMatter, Item pristineMatter, String[] mobTrivia) {
        this.key = key;
        this.name = name;
        this.pluralName = pluralName;
        this.numberOfHearts = numberOfHearts;
        this.interfaceScale = interfaceScale;
        this.interfaceOffsetX = interfaceOffsetX;
        this.interfaceOffsetY = interfaceOffsetY;
        this.livingMatter = (ItemLivingMatter)livingMatter;
        this.pristineMatter = (ItemPristineMatter)pristineMatter;
        this.mobTrivia = mobTrivia;
    }

    public int getSimulationTickCost() {
        int cost = Config.dataModel.get(this.getKey()).getInt();
        cost = MathHelper.ensureRange(cost, 1, 6666);
        return cost;
    }

    public ItemStack getLivingMatterStack(int amount) {
        return new ItemStack((Item)this.livingMatter, amount);
    }

    public ItemStack getPristineMatterStack(int amount) {
        return new ItemStack((Item)this.pristineMatter, amount);
    }

    public String getName() {
        return this.name;
    }

    public String getPluralName() {
        return this.pluralName;
    }

    public String getKey() {
        return this.key;
    }

    public int getNumberOfHearts() {
        return this.numberOfHearts;
    }

    public int getInterfaceScale() {
        return this.interfaceScale;
    }

    public int getInterfaceOffsetX() {
        return this.interfaceOffsetX;
    }

    public int getInterfaceOffsetY() {
        return this.interfaceOffsetY;
    }

    public String getMatterTypeName() {
        return this.livingMatter.getMatterTypeName();
    }

    public ItemLivingMatter getLivingMatter() {
        return this.livingMatter;
    }

    public ItemPristineMatter getPristineMatter() {
        return this.pristineMatter;
    }

    public String[] getMobTrivia() {
        return this.mobTrivia;
    }

    public boolean entityLivingMatchesMob(EntityLivingBase entityLiving) {
        EntityEntry entry = EntityRegistry.getEntry(entityLiving.getClass());
        if (entry != null) {
            ResourceLocation registryName = entry.getRegistryName();
            if (registryName != null) {
                String name = registryName.toString();
                return ArrayUtils.contains((Object[])Config.dataModelMobNames.get(this.getKey()).getStringList(), (Object)name);
            }
            return ArrayUtils.contains((Object[])Config.dataModelMobNames.get(this.getKey()).getStringList(), (Object)entry.getName());
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract Entity getEntity(World var1);

    @SideOnly(value=Side.CLIENT)
    public Entity getExtraEntity(World world) {
        return null;
    }

    public int getExtraInterfaceOffsetX() {
        return 0;
    }

    public int getExtraInterfaceOffsetY() {
        return 0;
    }

    public String getExtraTooltip() {
        return null;
    }
}

