/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.events;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObsidian;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.Registry;
import xt9.deepmoblearning.common.config.Config;
import xt9.deepmoblearning.common.items.ItemGlitchArmor;
import xt9.deepmoblearning.common.items.ItemGlitchHeart;

@Mod.EventBusSubscriber
public class PlayerHandler {
    public static final List<UUID> FLYING_PLAYERS = new ArrayList<UUID>();

    @SubscribeEvent
    public static void playerTickUpdate(TickEvent.PlayerTickEvent event) {
        PlayerCapabilities cap = event.player.field_71075_bZ;
        if (Config.isGlitchArmorCreativeFlightEnabled.getBoolean() && !event.player.field_70170_p.field_72995_K) {
            if (!cap.field_75101_c && ItemGlitchArmor.isSetEquippedByPlayer(event.player)) {
                cap.field_75101_c = true;
                event.player.func_71016_p();
                FLYING_PLAYERS.add(event.player.func_110124_au());
            }
            if (FLYING_PLAYERS.contains(event.player.func_110124_au()) && !ItemGlitchArmor.isSetEquippedByPlayer(event.player)) {
                if (cap.field_75101_c && !event.player.func_175149_v() && !event.player.func_184812_l_()) {
                    cap.field_75101_c = false;
                    cap.field_75100_b = false;
                    event.player.func_71016_p();
                }
                FLYING_PLAYERS.removeIf(uuid -> uuid.toString().equals(event.player.func_110124_au().toString()));
            }
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (FLYING_PLAYERS.contains(event.player.func_110124_au())) {
            FLYING_PLAYERS.removeIf(uuid -> uuid.toString().equals(event.player.func_110124_au().toString()));
        }
    }

    @SubscribeEvent
    public static void playerLeftClickedBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (Config.isSootedRedstoneCraftingEnabled.getBoolean() && stack.func_77973_b() instanceof ItemRedstone && PlayerHandler.isBlock("minecraft:coal_block", event.getWorld().func_180495_p(event.getPos()).func_177230_c())) {
            if (event.getSide() == Side.SERVER) {
                PlayerHandler.createSootedRedstone(event);
                stack.func_190918_g(1);
            } else {
                PlayerHandler.createSootedRedstoneParticles(event);
            }
        }
        if (stack.func_77973_b() instanceof ItemGlitchHeart && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BlockObsidian) {
            if (event.getSide() == Side.SERVER) {
                PlayerHandler.createGlitchFragment(event);
                stack.func_190918_g(1);
            } else {
                PlayerHandler.createGlitchFragmentparticles(event);
            }
        }
    }

    private static void createGlitchFragmentparticles(PlayerInteractEvent.LeftClickBlock event) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        Vec3d vector = event.getHitVec();
        for (int i = 0; i < 3; ++i) {
            DeepMobLearning.proxy.spawnSmokeParticle(event.getWorld(), vector.field_72450_a + rand.nextDouble(-0.4, 0.4), vector.field_72448_b + rand.nextDouble(-0.1, 0.4), vector.field_72449_c + rand.nextDouble(-0.4, 0.4), rand.nextDouble(-0.08, 0.08), rand.nextDouble(-0.08, 0.0), rand.nextDouble(-0.08, 0.08), "cyan");
        }
    }

    private static void createSootedRedstoneParticles(PlayerInteractEvent.LeftClickBlock event) {
        Vec3d vector = event.getHitVec();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 3; ++i) {
            DeepMobLearning.proxy.spawnSmokeParticle(event.getWorld(), vector.field_72450_a + rand.nextDouble(-0.4, 0.4), vector.field_72448_b + rand.nextDouble(-0.1, 0.4), vector.field_72449_c + rand.nextDouble(-0.4, 0.4), rand.nextDouble(-0.08, 0.08), rand.nextDouble(-0.08, 0.0), rand.nextDouble(-0.08, 0.08), "smoke");
        }
    }

    private static void createGlitchFragment(PlayerInteractEvent.LeftClickBlock event) {
        Vec3d vector = event.getHitVec();
        EntityItem item = new EntityItem(event.getWorld(), vector.field_72450_a, vector.field_72448_b + 0.5, vector.field_72449_c, new ItemStack((Item)Registry.glitchFragment, 3));
        item.func_174869_p();
        event.getWorld().func_72838_d((Entity)item);
    }

    private static boolean isBlock(String unlocalizedPath, Block block) {
        ResourceLocation loc = block.getRegistryName();
        String fullPath = loc.func_110624_b() + ":" + loc.func_110623_a();
        return fullPath.equals(unlocalizedPath);
    }

    private static void createSootedRedstone(PlayerInteractEvent.LeftClickBlock event) {
        Vec3d vector = event.getHitVec();
        EntityItem item = new EntityItem(event.getWorld(), vector.field_72450_a, vector.field_72448_b + 0.5, vector.field_72449_c, new ItemStack((Item)Registry.sootedRedstone, 1));
        item.func_174869_p();
        event.getWorld().func_72838_d((Entity)item);
    }
}

