/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.TorchmasterConfig;
import net.xalcon.torchmaster.common.blocks.BlockMegaTorch;
import net.xalcon.torchmaster.common.items.ItemBlockTooltipInfo;

public class ItemBlockMegaTorch
extends ItemBlockTooltipInfo {
    private static final int DAY_TICKS = 1728000;
    private static final int HOUR_TICKS = 72000;
    private static final int MINUTE_TICKS = 1200;
    private static final int SECOND_TICKS = 20;

    public ItemBlockMegaTorch(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ((Boolean)ModBlocks.getMegaTorch().func_176203_a(stack.func_77960_j()).func_177229_b((IProperty)BlockMegaTorch.BURNING) != false ? "lit" : "unlit");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        if (((Boolean)ModBlocks.getMegaTorch().func_176203_a(stack.func_77960_j()).func_177229_b((IProperty)BlockMegaTorch.BURNING)).booleanValue()) {
            NBTTagCompound compound = stack.func_179543_a("tm_tile");
            if (compound == null) {
                return;
            }
            if (compound.func_74767_n("isExtinguished")) {
                return;
            }
            int burnValueLeft = compound.func_74762_e("burnValueLeft");
            int burnRate = TorchmasterConfig.MegaTorchBurnoutRate;
            if (burnRate <= 0) {
                return;
            }
            int ticksLeft = burnValueLeft / burnRate;
            int days = ticksLeft / 1728000;
            int hours = (ticksLeft - days * 1728000) / 72000;
            int minutes = (ticksLeft - days * 1728000 - hours * 72000) / 1200;
            int seconds = (ticksLeft - days * 1728000 - hours * 72000 - minutes * 1200) / 20;
            tooltip.add(I18n.func_135052_a((String)(this.func_77667_c(stack) + ".burntime_left"), (Object[])new Object[]{days, ItemBlockMegaTorch.fmt(hours), ItemBlockMegaTorch.fmt(minutes), ItemBlockMegaTorch.fmt(seconds)}));
        }
    }

    private static String fmt(int number) {
        return String.format("%02d", number);
    }
}

