/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockModContainer;
import vazkii.psi.common.block.base.IPsiBlock;
import vazkii.psi.common.block.tile.TileConjured;

@Mod.EventBusSubscriber(modid="psi")
public class BlockConjured
extends BlockModContainer
implements IPsiBlock {
    public static final PropertyBool SOLID = PropertyBool.func_177716_a((String)"solid");
    public static final PropertyBool LIGHT = PropertyBool.func_177716_a((String)"light");
    public static final PropertyBool BLOCK_UP = PropertyBool.func_177716_a((String)"block_up");
    public static final PropertyBool BLOCK_DOWN = PropertyBool.func_177716_a((String)"block_down");
    public static final PropertyBool BLOCK_NORTH = PropertyBool.func_177716_a((String)"block_north");
    public static final PropertyBool BLOCK_SOUTH = PropertyBool.func_177716_a((String)"block_south");
    public static final PropertyBool BLOCK_WEST = PropertyBool.func_177716_a((String)"block_west");
    public static final PropertyBool BLOCK_EAST = PropertyBool.func_177716_a((String)"block_east");
    private static final Set<BlockPos> needsParticleUpdate = Sets.newHashSet();
    protected static final AxisAlignedBB LIGHT_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);

    public BlockConjured() {
        super("conjured", Material.field_151592_s, new String[0]);
        this.func_180632_j(this.makeDefaultState());
        this.func_149713_g(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity inWorld = worldIn.func_175625_s(pos);
        if (inWorld instanceof TileConjured) {
            needsParticleUpdate.add(pos.func_185334_h());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void fireParticles(TickEvent.ClientTickEvent event) {
        if (event.side.isClient() && event.phase == TickEvent.Phase.END) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            Entity viewPoint = Minecraft.func_71410_x().func_175606_aa();
            if (viewPoint == null) {
                viewPoint = Minecraft.func_71410_x().field_71439_g;
            }
            Entity view = viewPoint;
            needsParticleUpdate.removeIf(arg_0 -> BlockConjured.lambda$fireParticles$0(view, (World)world, arg_0));
        }
    }

    @SubscribeEvent
    public static void ignoreMissingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110623_a().equals("conjured")) continue;
            mapping.ignore();
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175698_g(pos);
    }

    public ItemBlock createItemBlock(ResourceLocation res) {
        return null;
    }

    public IBlockState makeDefaultState() {
        return this.func_176203_a(0);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, this.getAllProperties());
    }

    public IProperty[] getIgnoredProperties() {
        return this.getAllProperties();
    }

    public IProperty[] getAllProperties() {
        return new IProperty[]{SOLID, LIGHT, BLOCK_UP, BLOCK_DOWN, BLOCK_NORTH, BLOCK_SOUTH, BLOCK_WEST, BLOCK_EAST};
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        return state.func_177226_a((IProperty)SOLID, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)LIGHT, (Comparable)Boolean.valueOf((meta & 2) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)SOLID) != false ? 1 : 0) | ((Boolean)state.func_177229_b((IProperty)LIGHT) != false ? 2 : 0);
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState origState = state;
        state = state.func_177226_a((IProperty)BLOCK_UP, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177984_a()).equals(origState)));
        state = state.func_177226_a((IProperty)BLOCK_DOWN, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177977_b()).equals(origState)));
        state = state.func_177226_a((IProperty)BLOCK_NORTH, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177978_c()).equals(origState)));
        state = state.func_177226_a((IProperty)BLOCK_SOUTH, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177968_d()).equals(origState)));
        state = state.func_177226_a((IProperty)BLOCK_WEST, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177976_e()).equals(origState)));
        state = state.func_177226_a((IProperty)BLOCK_EAST, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177974_f()).equals(origState)));
        return state;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIGHT) != false ? 15 : 0;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return (Boolean)blockState.func_177229_b((IProperty)SOLID) != false ? field_185505_j : field_185506_k;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)SOLID) != false ? field_185505_j : LIGHT_AABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileConjured();
    }

    private static /* synthetic */ boolean lambda$fireParticles$0(Entity view, World world, BlockPos pos) {
        TileEntity inWorld;
        if (view == null || world == null) {
            return true;
        }
        if (world.func_175667_e(pos) && view.func_174818_b(pos) <= 4096.0 && (inWorld = world.func_175625_s(pos)) instanceof TileConjured) {
            ((TileConjured)inWorld).doParticles();
            return false;
        }
        return true;
    }
}

