/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;

public abstract class SpellPiece {
    private static final String TAG_KEY_LEGACY = "spellKey";
    private static final String TAG_KEY = "key";
    private static final String TAG_PARAMS = "params";
    private static final String TAG_COMMENT = "comment";
    private static final String PSI_PREFIX = "psi.spellparam.";
    public final String registryKey;
    public final Spell spell;
    public boolean isInGrid = false;
    public int x;
    public int y;
    public String comment;
    public final Map<String, SpellParam> params = new LinkedHashMap<String, SpellParam>();
    public final Map<SpellParam, SpellParam.Side> paramSides = new LinkedHashMap<SpellParam, SpellParam.Side>();

    public SpellPiece(Spell spell) {
        this.spell = spell;
        this.registryKey = (String)PsiAPI.spellPieceRegistry.func_177774_c(this.getClass());
        this.initParams();
    }

    public void initParams() {
    }

    public abstract EnumPieceType getPieceType();

    public abstract Class<?> getEvaluationType();

    public abstract Object evaluate() throws SpellCompilationException;

    public abstract Object execute(SpellContext var1) throws SpellRuntimeException;

    public String getEvaluationTypeString() {
        Class<?> evalType = this.getEvaluationType();
        String evalStr = evalType == null ? "Null" : evalType.getSimpleName();
        String s = TooltipHelper.local("psi.datatype." + evalStr);
        if (this.getPieceType() == EnumPieceType.CONSTANT) {
            s = s + " " + TooltipHelper.local("psimisc.constant");
        }
        return s;
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
    }

    public void addParam(SpellParam param) {
        this.params.put(param.name, param);
        this.paramSides.put(param, SpellParam.Side.OFF);
    }

    public <T> T getParamValue(SpellContext context, SpellParam param) {
        SpellParam.Side side = this.paramSides.get(param);
        if (!side.isEnabled()) {
            return null;
        }
        try {
            SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, side);
            if (piece == null || !param.canAccept(piece)) {
                return null;
            }
            return (T)context.evaluatedObjects[piece.x][piece.y];
        }
        catch (SpellCompilationException e) {
            return null;
        }
    }

    public <T> T getParamEvaluation(SpellParam param) throws SpellCompilationException {
        SpellParam.Side side = this.paramSides.get(param);
        if (!side.isEnabled()) {
            return null;
        }
        SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, side);
        if (piece == null || !param.canAccept(piece)) {
            return null;
        }
        return (T)piece.evaluate();
    }

    public String getUnlocalizedName() {
        return "psi.spellpiece." + this.registryKey;
    }

    public String getSortingName() {
        return TooltipHelper.local(this.getUnlocalizedName());
    }

    public String getUnlocalizedDesc() {
        return "psi.spellpiece." + this.registryKey + ".desc";
    }

    @SideOnly(value=Side.CLIENT)
    public void draw() {
        this.drawBackground();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.1f);
        this.drawAdditional();
        if (this.isInGrid) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.1f);
            this.drawParams();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.1f);
            this.drawComment();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground() {
        ResourceLocation res = PsiAPI.simpleSpellTextures.get(this.registryKey);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(res);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(0.0, 16.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(16.0, 16.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b(16.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawAdditional() {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawComment() {
        if (this.comment != null && !this.comment.isEmpty()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(PsiAPI.internalHandler.getProgrammerTexture());
            float wh = 6.0f;
            float minU = 0.5859375f;
            float minV = 0.71875f;
            float maxU = (150.0f + wh) / 256.0f;
            float maxV = (184.0f + wh) / 256.0f;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_181662_b(-2.0, 4.0, 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
            wr.func_181662_b(4.0, 4.0, 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            wr.func_181662_b(4.0, -2.0, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
            wr.func_181662_b(-2.0, -2.0, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawParams() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(PsiAPI.internalHandler.getProgrammerTexture());
        GlStateManager.func_179141_d();
        for (SpellParam param : this.paramSides.keySet()) {
            SpellParam.Side side = this.paramSides.get(param);
            if (!side.isEnabled()) continue;
            int minX = 4;
            int minY = 4;
            int maxX = (minX += side.offx * 9) + 8;
            int maxY = (minY += side.offy * 9) + 8;
            float wh = 8.0f;
            float minU = (float)side.u / 256.0f;
            float minV = (float)side.v / 256.0f;
            float maxU = ((float)side.u + wh) / 256.0f;
            float maxV = ((float)side.v + wh) / 256.0f;
            GlStateManager.func_179131_c((float)((float)PsiRenderHelper.r(param.color) / 255.0f), (float)((float)PsiRenderHelper.g(param.color) / 255.0f), (float)((float)PsiRenderHelper.b(param.color) / 255.0f), (float)1.0f);
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_181662_b((double)minX, (double)maxY, 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
            wr.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            wr.func_181662_b((double)maxX, (double)minY, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
            wr.func_181662_b((double)minX, (double)minY, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawTooltip(int tooltipX, int tooltipY, List<String> tooltip) {
        PsiAPI.internalHandler.renderTooltip(tooltipX, tooltipY, tooltip, 0x505000FF, -267386864);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawCommentText(int tooltipX, int tooltipY, List<String> commentText) {
        PsiAPI.internalHandler.renderTooltip(tooltipX, tooltipY - 9 - commentText.size() * 10, commentText, 0x5000A000, -268427776);
    }

    @SideOnly(value=Side.CLIENT)
    public void getTooltip(List<String> tooltip) {
        ModContainer container;
        TooltipHelper.addToTooltip(tooltip, this.getUnlocalizedName(), new Object[0]);
        TooltipHelper.tooltipIfShift(tooltip, () -> this.addToTooltipAfterShift(tooltip));
        String addon = PsiAPI.pieceMods.get(this.getClass());
        if (!addon.equals("psi") && (container = (ModContainer)Loader.instance().getIndexedModList().get(addon)) != null) {
            TooltipHelper.addToTooltip(tooltip, "psimisc.providerMod", container.getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addToTooltipAfterShift(List<String> tooltip) {
        tooltip.add(TextFormatting.GRAY + TooltipHelper.local(this.getUnlocalizedDesc()).replaceAll("&", "\u00a7"));
        tooltip.add("");
        String eval = this.getEvaluationTypeString();
        tooltip.add("<- " + TextFormatting.GOLD + eval);
        for (SpellParam param : this.paramSides.keySet()) {
            String pName = TooltipHelper.local(param.name);
            String pEval = param.getRequiredTypeString();
            tooltip.add((param.canDisable ? "[->] " : " ->  ") + TextFormatting.YELLOW + pName + " [" + pEval + "]");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean interceptKeystrokes() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyPressed(char c, int i, boolean doit) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasConfig() {
        return !this.params.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public void getShownPieces(List<SpellPiece> pieces) {
        pieces.add(this);
    }

    public static SpellPiece createFromNBT(Spell spell, NBTTagCompound cmp) {
        Class clazz;
        String key = cmp.func_74764_b(TAG_KEY_LEGACY) ? cmp.func_74779_i(TAG_KEY_LEGACY) : cmp.func_74779_i(TAG_KEY);
        if (key.startsWith("_")) {
            key = PSI_PREFIX + key.substring(1);
        }
        if (key.matches("^[a-z][a-z0-9_]+\\:[a-z0-9_]+$")) {
            key = key.substring(key.indexOf(":") + 1);
            key = StringUtils.uncapitalize((String)Arrays.stream(key.split("_")).map(StringUtils::capitalize).collect(Collectors.joining()));
        }
        if ((clazz = (Class)PsiAPI.spellPieceRegistry.func_82594_a((Object)key)) != null) {
            SpellPiece p = SpellPiece.create(clazz, spell);
            p.readFromNBT(cmp);
            return p;
        }
        return null;
    }

    public static SpellPiece create(Class<? extends SpellPiece> clazz, Spell spell) {
        try {
            return clazz.getConstructor(Spell.class).newInstance(spell);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SpellPiece copy() {
        NBTTagCompound cmp = new NBTTagCompound();
        this.writeToNBT(cmp);
        return SpellPiece.createFromNBT(this.spell, cmp);
    }

    public void readFromNBT(NBTTagCompound cmp) {
        NBTTagCompound paramCmp = cmp.func_74775_l(TAG_PARAMS);
        for (String s : this.params.keySet()) {
            SpellParam param = this.params.get(s);
            String key = s;
            if (paramCmp.func_74764_b(key)) {
                this.paramSides.put(param, SpellParam.Side.fromInt(paramCmp.func_74762_e(key)));
                continue;
            }
            if (key.startsWith(PSI_PREFIX)) {
                key = "_" + key.substring(PSI_PREFIX.length());
            }
            this.paramSides.put(param, SpellParam.Side.fromInt(paramCmp.func_74762_e(key)));
        }
        this.comment = cmp.func_74779_i(TAG_COMMENT);
    }

    public void writeToNBT(NBTTagCompound cmp) {
        if (this.comment == null) {
            this.comment = "";
        }
        cmp.func_74778_a(TAG_KEY, this.registryKey.replaceAll("^psi.spellparam.", "_"));
        int paramCount = 0;
        NBTTagCompound paramCmp = new NBTTagCompound();
        for (String s : this.params.keySet()) {
            SpellParam param = this.params.get(s);
            SpellParam.Side side = this.paramSides.get(param);
            paramCmp.func_74768_a(s.replaceAll("^psi.spellparam.", "_"), side.asInt());
            ++paramCount;
        }
        if (paramCount > 0) {
            cmp.func_74782_a(TAG_PARAMS, (NBTBase)paramCmp);
        }
        if (!this.comment.isEmpty()) {
            cmp.func_74778_a(TAG_COMMENT, this.comment);
        }
    }

    public static class Null {
    }
}

