/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityEnergyCube
extends TileEntityElectricBlock
implements IComputerIntegration,
IRedstoneControl,
ISideConfiguration,
ISecurityTile,
ITierUpgradeable,
IConfigCardAccess,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded"};
    public EnergyCubeTier tier = EnergyCubeTier.BASIC;
    public int currentRedstoneLevel;
    public IRedstoneControl.RedstoneControl controlType;
    public int prevScale;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ENERGY, TransmissionType.ITEM);
    public TileComponentSecurity securityComponent;

    public TileEntityEnergyCube() {
        super("EnergyCube", 0.0);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Charge", EnumColor.DARK_BLUE, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Discharge", EnumColor.DARK_RED, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{0, 0, 0, 0, 2, 1});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.setIOConfig(TransmissionType.ENERGY);
        this.configComponent.setEjecting(TransmissionType.ENERGY, true);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.ejectorComponent = new TileComponentEjector(this);
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            int newScale;
            ChargeUtils.charge(0, (IStrictEnergyStorage)this);
            ChargeUtils.discharge(1, this);
            if (MekanismUtils.canFunction(this) && this.configComponent.isEjecting(TransmissionType.ENERGY)) {
                CableUtils.emit(this);
            }
            if ((newScale = this.getScaledEnergyLevel(20)) != this.prevScale) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            this.prevScale = newScale;
        }
    }

    @Override
    public boolean upgrade(BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = EnergyCubeTier.values()[upgradeTier.ordinal()];
        Mekanism.packetHandler.sendUpdatePacket(this);
        this.func_70296_d();
        return true;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("tile.EnergyCube" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    @Override
    public double getMaxOutput() {
        return this.tier.getOutput();
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 1, side);
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 2, side);
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return true;
    }

    @Override
    public double getMaxEnergy() {
        return this.tier.getMaxEnergy();
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (slotID == 0) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        return false;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.tier.getOutput()};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            EnergyCubeTier prevTier = this.tier;
            this.tier = EnergyCubeTier.values()[dataStream.readInt()];
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            if (prevTier != this.tier) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = EnergyCubeTier.values()[nbtTags.func_74762_e("tier")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        return nbtTags;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.tier == EnergyCubeTier.CREATIVE && energy != Double.MAX_VALUE) {
            return;
        }
        super.setEnergy(energy);
        int newRedstoneLevel = this.getRedstoneLevel();
        if (newRedstoneLevel != this.currentRedstoneLevel) {
            this.func_70296_d();
            this.currentRedstoneLevel = newRedstoneLevel;
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.getEnergy(), this.getMaxEnergy());
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY) {
            return (T)Capabilities.CONFIG_CARD_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }
}

