/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import mekanism.client.render.FluidRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityBoilerCasing;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderThermoelectricBoiler
extends TileEntitySpecialRenderer<TileEntityBoilerCasing> {
    private FluidStack STEAM = new FluidStack(FluidRegistry.getFluid((String)"steam"), 1);
    private FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1);

    public void render(TileEntityBoilerCasing tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tileEntity.clientHasStructure && tileEntity.isRendering && tileEntity.structure != null && ((SynchronizedBoilerData)tileEntity.structure).renderLocation != null && ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation != null) {
            MekanismRenderer.GlowInfo glowInfo;
            FluidRenderer.RenderData data;
            FluidStack waterStored = ((SynchronizedBoilerData)tileEntity.structure).waterStored;
            boolean glChanged = false;
            if (waterStored != null && waterStored.amount != 0) {
                data = new FluidRenderer.RenderData();
                data.location = ((SynchronizedBoilerData)tileEntity.structure).renderLocation;
                data.height = ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation.y - 1 - ((SynchronizedBoilerData)tileEntity.structure).renderLocation.y;
                data.length = ((SynchronizedBoilerData)tileEntity.structure).volLength;
                data.width = ((SynchronizedBoilerData)tileEntity.structure).volWidth;
                data.fluidType = this.WATER;
                if (data.height >= 1 && waterStored.getFluid() != null) {
                    this.func_147499_a(TextureMap.field_110575_b);
                    GlStateManager.func_179094_E();
                    glChanged = this.makeGLChanges(glChanged);
                    FluidRenderer.translateToOrigin(data.location);
                    glowInfo = MekanismRenderer.enableGlow(waterStored);
                    MekanismRenderer.color(waterStored, (float)waterStored.amount / (float)tileEntity.clientWaterCapacity);
                    if (waterStored.getFluid().isGaseous(waterStored)) {
                        FluidRenderer.getTankDisplay(data).render();
                    } else {
                        FluidRenderer.getTankDisplay(data, tileEntity.prevWaterScale).render();
                    }
                    MekanismRenderer.resetColor();
                    MekanismRenderer.disableGlow(glowInfo);
                    GlStateManager.func_179121_F();
                    for (SynchronizedTankData.ValveData valveData : tileEntity.valveViewing) {
                        GlStateManager.func_179094_E();
                        FluidRenderer.translateToOrigin(valveData.location);
                        MekanismRenderer.GlowInfo valveGlowInfo = MekanismRenderer.enableGlow(waterStored);
                        FluidRenderer.getValveDisplay(FluidRenderer.ValveRenderData.get(data, valveData)).render();
                        MekanismRenderer.disableGlow(valveGlowInfo);
                        GlStateManager.func_179121_F();
                    }
                }
            }
            if (((SynchronizedBoilerData)tileEntity.structure).steamStored != null && ((SynchronizedBoilerData)tileEntity.structure).steamStored.amount > 0) {
                data = new FluidRenderer.RenderData();
                data.location = ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation;
                data.height = ((SynchronizedBoilerData)tileEntity.structure).renderLocation.y + ((SynchronizedBoilerData)tileEntity.structure).volHeight - 2 - ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation.y;
                data.length = ((SynchronizedBoilerData)tileEntity.structure).volLength;
                data.width = ((SynchronizedBoilerData)tileEntity.structure).volWidth;
                data.fluidType = this.STEAM;
                if (data.height >= 1 && ((SynchronizedBoilerData)tileEntity.structure).steamStored.getFluid() != null) {
                    this.func_147499_a(TextureMap.field_110575_b);
                    GlStateManager.func_179094_E();
                    glChanged = this.makeGLChanges(glChanged);
                    FluidRenderer.translateToOrigin(data.location);
                    glowInfo = MekanismRenderer.enableGlow(((SynchronizedBoilerData)tileEntity.structure).steamStored);
                    MekanismRenderer.DisplayInteger display = FluidRenderer.getTankDisplay(data);
                    MekanismRenderer.color(((SynchronizedBoilerData)tileEntity.structure).steamStored, (float)((SynchronizedBoilerData)tileEntity.structure).steamStored.amount / (float)tileEntity.clientSteamCapacity);
                    display.render();
                    MekanismRenderer.resetColor();
                    MekanismRenderer.disableGlow(glowInfo);
                    GlStateManager.func_179121_F();
                }
            }
            if (glChanged) {
                this.func_190053_a(false);
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
                GlStateManager.func_179129_p();
            }
        }
    }

    private boolean makeGLChanges(boolean glChanged) {
        if (!glChanged) {
            GlStateManager.func_179089_o();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_190053_a(true);
        }
        return true;
    }
}

