/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.filter.GuiTextFilter;
import mekanism.common.Mekanism;
import mekanism.common.content.filter.IOreDictFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiOreDictFilter<FILTER extends IOreDictFilter, TILE extends TileEntityContainerBlock>
extends GuiTextFilter<FILTER, TILE> {
    protected GuiOreDictFilter(EntityPlayer player, TILE tile) {
        super(player, tile);
    }

    protected abstract void updateStackList(String var1);

    @Override
    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            if (!this.text.func_146179_b().isEmpty()) {
                this.setText();
            }
            if (((IOreDictFilter)this.filter).getOreDictName() != null && !((IOreDictFilter)this.filter).getOreDictName().isEmpty()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(0);
            } else {
                this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.noKey");
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == 1) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            this.sendPacketToServer(0);
        }
    }

    @Override
    protected void setText() {
        String name = this.text.func_146179_b();
        if (name.isEmpty()) {
            this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.noKey");
            return;
        }
        if (name.equals(((IOreDictFilter)this.filter).getOreDictName())) {
            this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.sameKey");
            return;
        }
        this.updateStackList(name);
        ((IOreDictFilter)this.filter).setOreDictName(name);
        this.text.func_146180_a("");
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b((this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.oredictFilter"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + this.status, 35, 20, 52480);
        this.renderScaledText(LangUtils.localize("gui.key") + ": " + ((IOreDictFilter)this.filter).getOreDictName(), 35, 32, 52480, 107);
        super.func_146979_b(mouseX, mouseY);
    }
}

