/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.tiles;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import vswe.superfactory.blocks.ClusterMethodRegistration;
import vswe.superfactory.blocks.IRedstoneNode;
import vswe.superfactory.blocks.ISystemListener;
import vswe.superfactory.blocks.ITriggerNode;
import vswe.superfactory.tiles.TileEntityClusterElement;
import vswe.superfactory.tiles.TileEntityManager;

public class TileEntityInput
extends TileEntityClusterElement
implements IRedstoneNode,
ISystemListener,
ITriggerNode {
    private static final String NBT_POWER = "Power";
    private static final String NBT_SIDES = "Sides";
    private int[] isPowered = new int[EnumFacing.values().length];
    private List<TileEntityManager> managerList = new ArrayList<TileEntityManager>();
    private int[] oldPowered = new int[EnumFacing.values().length];

    @Override
    public void added(TileEntityManager owner) {
        if (!this.managerList.contains(owner)) {
            this.managerList.add(owner);
        }
    }

    @Override
    public void removed(TileEntityManager owner) {
        this.managerList.remove(owner);
    }

    public void triggerRedstone() {
        this.isPowered = new int[this.isPowered.length];
        for (int i = 0; i < this.isPowered.length; ++i) {
            EnumFacing direction = EnumFacing.func_82600_a((int)i);
            BlockPos pos = this.func_174877_v().func_177972_a(direction);
            this.isPowered[i] = this.field_145850_b.func_175651_c(pos, direction);
        }
        this.managerList.forEach(m -> m.triggerRedstone(this));
        this.oldPowered = this.isPowered;
    }

    @Override
    public int[] getPower() {
        return this.isPowered;
    }

    @Override
    public void writeContentToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)13);
        NBTTagList sidesTag = new NBTTagList();
        for (int power : this.isPowered) {
            NBTTagCompound sideTag = new NBTTagCompound();
            sideTag.func_74774_a(NBT_POWER, (byte)power);
            sidesTag.func_74742_a((NBTBase)sideTag);
        }
        nbtTagCompound.func_74782_a(NBT_SIDES, (NBTBase)sidesTag);
    }

    @Override
    public void readContentFromNBT(NBTTagCompound nbtTagCompound) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        NBTTagList sidesTag = nbtTagCompound.func_150295_c(NBT_SIDES, 10);
        for (int i = 0; i < sidesTag.func_74745_c(); ++i) {
            NBTTagCompound sideTag = sidesTag.func_150305_b(i);
            byte by = sideTag.func_74771_c(NBT_POWER);
            this.isPowered[i] = by;
            this.oldPowered[i] = by;
        }
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.CAN_CONNECT_REDSTONE, ClusterMethodRegistration.ON_NEIGHBOR_BLOCK_CHANGED, ClusterMethodRegistration.ON_BLOCK_ADDED);
    }

    @Override
    public int[] getData() {
        return this.isPowered;
    }

    @Override
    public int[] getOldData() {
        return this.oldPowered;
    }
}

