/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.baseelements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiEvent;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.brandon3055.brandonscore.lib.ScissorHelper;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.google.common.collect.ImmutableList;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class GuiScrollElement
extends MGuiElementBase<GuiScrollElement>
implements IGuiEventListener {
    public static final String DEFAULT_SCROLL_BAR_GROUP = "GuiScrollElement_Default_Scroll_Bars";
    protected int listSpacing = 0;
    protected int verticalScrollPos = 0;
    protected int horizontalScrollPos = 0;
    protected int animSpeed = 1;
    protected Insets defaultInsets = new Insets(0, 0, 0, 0);
    protected boolean smoothScroll = false;
    protected boolean enableVerticalScroll = true;
    protected boolean useAbsoluteElementSize = false;
    protected boolean enableHorizontalScroll = true;
    protected boolean scrollBarExclusionMode = true;
    protected ListMode listMode = ListMode.DISABLED;
    protected Rectangle scrollBounds = new Rectangle();
    protected MGuiElementBase backgroundElement = null;
    protected GuiSlideControl verticalScrollBar = null;
    protected GuiSlideControl horizontalScrollBar = null;
    protected LinkedList<MGuiElementBase> scrollingElements = new LinkedList();
    protected LinkedList<MGuiElementBase> foregroundElements = new LinkedList();
    protected LinkedList<MGuiElementBase> backgroundElements = new LinkedList();

    public GuiScrollElement() {
    }

    public GuiScrollElement(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiScrollElement(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        this.resetScrollPositions();
        this.updateScrollElement();
        this.resetScrollPositions();
    }

    public GuiScrollElement setAllowedScrollAxes(boolean vertical, boolean horizontal) {
        this.enableVerticalScroll = vertical;
        this.enableHorizontalScroll = horizontal;
        return this;
    }

    public GuiScrollElement setVerticalScrollBar(GuiSlideControl verticalScrollBar) {
        if (this.verticalScrollBar != null) {
            this.removeChild(this.verticalScrollBar);
        }
        this.verticalScrollBar = verticalScrollBar;
        this.verticalScrollBar.setListener(this);
        this.addChild(this.verticalScrollBar);
        return this;
    }

    public GuiSlideControl getVerticalScrollBar() {
        this.validateScrollBarExistence();
        return this.verticalScrollBar;
    }

    public GuiScrollElement setHorizontalScrollBar(GuiSlideControl horizontalScrollBar) {
        if (this.horizontalScrollBar != null) {
            this.removeChild(this.horizontalScrollBar);
        }
        this.horizontalScrollBar = horizontalScrollBar;
        this.horizontalScrollBar.setListener(this);
        this.addChild(this.horizontalScrollBar);
        return this;
    }

    public GuiSlideControl getHorizontalScrollBar() {
        this.validateScrollBarExistence();
        return this.horizontalScrollBar;
    }

    public GuiScrollElement setScrollBarExclusionMode(boolean scrollBarExclusionMode) {
        this.scrollBarExclusionMode = scrollBarExclusionMode;
        return this;
    }

    public GuiScrollElement setSmoothScroll(boolean smoothScroll, int speed) {
        this.smoothScroll = smoothScroll;
        this.animSpeed = speed;
        return this;
    }

    public GuiScrollElement useAbsoluteElementSize(boolean useAbsoluteElementSize) {
        this.useAbsoluteElementSize = useAbsoluteElementSize;
        return this;
    }

    public GuiScrollElement setStandardScrollBehavior() {
        this.validateScrollBarExistence();
        this.verticalScrollBar.setParentScroll(true);
        this.verticalScrollBar.allowMiddleClickDrag(true);
        this.verticalScrollBar.clearScrollChecks();
        this.verticalScrollBar.addScrollCheck((slider, mouseX, mouseY) -> slider.isMouseOver((int)mouseX, (int)mouseY) || !GuiScreen.func_146272_n());
        this.horizontalScrollBar.setParentScroll(true);
        this.horizontalScrollBar.allowMiddleClickDrag(true);
        this.horizontalScrollBar.clearScrollChecks();
        this.horizontalScrollBar.addScrollCheck((slider, mouseX, mouseY) -> slider.isMouseOver((int)mouseX, (int)mouseY) || GuiScreen.func_146272_n());
        return this;
    }

    @Override
    public GuiScrollElement setInsets(int top, int left, int bottom, int right) {
        this.defaultInsets.set(top, left, bottom, right);
        return (GuiScrollElement)super.setInsets(top, left, bottom, right);
    }

    @Override
    public GuiScrollElement setInsets(Insets insets) {
        this.defaultInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        return (GuiScrollElement)super.setInsets(insets);
    }

    public GuiScrollElement addElement(MGuiElementBase element) {
        this.scrollingElements.add(element);
        super.addChild(element);
        this.updateScrollElement();
        return this;
    }

    public GuiScrollElement removeElement(MGuiElementBase element) {
        this.removeChild(element);
        this.updateScrollElement();
        return this;
    }

    @Override
    public <C extends MGuiElementBase> C removeChild(C child) {
        this.scrollingElements.remove(child);
        this.backgroundElements.remove(child);
        return super.removeChild(child);
    }

    @Override
    public final <C extends MGuiElementBase> C addChild(C child) {
        this.foregroundElements.add(child);
        return super.addChild(child);
    }

    public <C extends MGuiElementBase> C addBackgroundChild(C child) {
        this.backgroundElements.add(child);
        return super.addChild(child);
    }

    public void clearElements() {
        this.scrollingElements.forEach(x$0 -> super.removeChild(x$0));
        this.scrollingElements.clear();
        this.updateScrollElement();
    }

    public ImmutableList<MGuiElementBase> getScrollingElements() {
        return ImmutableList.copyOf(this.scrollingElements);
    }

    protected int elementXSize(MGuiElementBase element) {
        if (this.useAbsoluteElementSize) {
            return element.getEnclosingRect().width;
        }
        return element.xSize();
    }

    protected int elementYSize(MGuiElementBase element) {
        if (this.useAbsoluteElementSize) {
            return element.getEnclosingRect().height;
        }
        return element.ySize();
    }

    public void updateScrollElement() {
        if (this.listMode != ListMode.DISABLED) {
            int lastPos = this.listMode.horizontal() ? this.getInsetRect().x : this.getInsetRect().y;
            for (MGuiElementBase element : this.scrollingElements) {
                if (!element.isEnabled() || element == this.backgroundElement) continue;
                if (this.listMode.horizontal()) {
                    if (this.listMode.lockPos()) {
                        element.setYPos(this.getInsetRect().y);
                    }
                    if (this.listMode.lockWidth()) {
                        element.setYSize(this.getInsetRect().height);
                    }
                    element.setXPos(lastPos);
                    lastPos += this.elementXSize(element) + this.listSpacing;
                    continue;
                }
                if (this.listMode.lockPos()) {
                    element.setXPos(this.getInsetRect().x);
                }
                if (this.listMode.lockWidth()) {
                    element.setXSize(this.getInsetRect().width);
                }
                element.setYPos(lastPos);
                lastPos += this.elementYSize(element) + this.listSpacing;
            }
        }
        this.updateScrollBounds();
        this.updateScrollbars();
        if (this.backgroundElement != null) {
            this.backgroundElement.setPosAndSize(this.scrollBounds);
        }
    }

    protected void updateScrollBounds() {
        int yMin;
        int xMin;
        int xMax = xMin = this.getInsetRect().x;
        int yMax = yMin = this.getInsetRect().y;
        if (DataUtils.firstMatch(this.scrollingElements, elementBase -> elementBase.isEnabled() || elementBase != this.backgroundElement) == null) {
            xMin = this.xPos();
            xMax = this.maxXPos();
            yMin = this.yPos();
            yMax = this.maxYPos();
        } else {
            for (MGuiElementBase element : this.scrollingElements) {
                if (!element.isEnabled() || element == this.backgroundElement) continue;
                Rectangle rect = element.getEnclosingRect();
                if (rect.x < xMin) {
                    xMin = (int)rect.getX();
                }
                if (rect.getMaxX() > (double)xMax) {
                    xMax = (int)rect.getMaxX();
                }
                if (rect.y < yMin) {
                    yMin = (int)rect.getY();
                }
                if (!(rect.getMaxY() > (double)yMax)) continue;
                yMax = (int)rect.getMaxY();
            }
        }
        this.scrollBounds.setBounds(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public void updateScrollbars() {
        boolean canDisHoz;
        this.validateScrollBarExistence();
        this.setInsets(this.defaultInsets.top, this.defaultInsets.left, this.defaultInsets.bottom, this.defaultInsets.right);
        double verticalMinScroll = Math.min(0, this.scrollBounds.y - this.getInsetRect().y);
        double verticalMaxScroll = Math.max(0.0, this.scrollBounds.getMaxY() - this.getInsetRect().getMaxY());
        boolean vertNoExc = Math.abs(verticalMinScroll) + Math.abs(verticalMaxScroll) <= 0.0;
        double horizontalMinScroll = Math.min(0, this.scrollBounds.x - this.getInsetRect().x);
        double horizontalMaxScroll = Math.max(0.0, this.scrollBounds.getMaxX() - this.getInsetRect().getMaxX());
        boolean hozNoExc = Math.abs(horizontalMinScroll) + Math.abs(horizontalMaxScroll) <= 0.0;
        verticalMinScroll = Math.min(0, this.scrollBounds.y - this.getInsetRect().y);
        verticalMaxScroll = Math.max(0.0, this.scrollBounds.getMaxY() - this.getInsetRect().getMaxY());
        boolean vertExc = Math.abs(verticalMinScroll) + Math.abs(verticalMaxScroll) <= 0.0;
        horizontalMinScroll = Math.min(0, this.scrollBounds.x - this.getInsetRect().x);
        horizontalMaxScroll = Math.max(0.0, this.scrollBounds.getMaxX() - this.getInsetRect().getMaxX());
        boolean hozExc = Math.abs(horizontalMinScroll) + Math.abs(horizontalMaxScroll) <= 0.0;
        boolean canDisVert = vertExc || !this.enableVerticalScroll;
        boolean bl = canDisHoz = hozExc || !this.enableHorizontalScroll;
        if (!canDisVert && vertNoExc) {
            boolean bl2 = canDisVert = canDisHoz || hozNoExc;
        }
        if (!canDisHoz && hozNoExc) {
            canDisHoz = canDisVert;
        }
        this.verticalScrollBar.setEnabled(!canDisVert);
        this.horizontalScrollBar.setEnabled(!canDisHoz && this.enableHorizontalScroll);
        this.setInsets(this.defaultInsets.top, this.defaultInsets.left, this.defaultInsets.bottom, this.defaultInsets.right);
        this.updateScrollbarExclusion();
        if ((!this.verticalScrollBar.isEnabled() || this.verticalScrollBar.isHidden()) && this.horizontalScrollBar.isEnabled() && this.horizontalScrollBar.isInGroup(DEFAULT_SCROLL_BAR_GROUP)) {
            ((GuiSlideControl)((GuiSlideControl)this.horizontalScrollBar.setXSize(this.xSize())).setYPos(this.maxYPos() - this.horizontalScrollBar.ySize())).updateElements();
        } else if (this.horizontalScrollBar.isInGroup(DEFAULT_SCROLL_BAR_GROUP)) {
            ((GuiSlideControl)((GuiSlideControl)this.horizontalScrollBar.setXSize(this.xSize() - this.verticalScrollBar.xSize())).setYPos(this.maxYPos() - this.horizontalScrollBar.ySize())).updateElements();
        }
        if ((!this.horizontalScrollBar.isEnabled() || this.horizontalScrollBar.isHidden()) && this.verticalScrollBar.isEnabled() && this.verticalScrollBar.isInGroup(DEFAULT_SCROLL_BAR_GROUP)) {
            ((GuiSlideControl)((GuiSlideControl)this.verticalScrollBar.setYSize(this.ySize())).setXPos(this.maxXPos() - this.verticalScrollBar.xSize())).updateElements();
        } else if (this.verticalScrollBar.isInGroup(DEFAULT_SCROLL_BAR_GROUP)) {
            ((GuiSlideControl)((GuiSlideControl)this.verticalScrollBar.setYSize(this.ySize() - this.horizontalScrollBar.ySize())).setXPos(this.maxXPos() - this.verticalScrollBar.xSize())).updateElements();
        }
        double contentHeight = Math.abs(verticalMinScroll) + (double)this.getInsetRect().height + Math.abs(verticalMaxScroll);
        this.verticalScrollBar.setRange(verticalMinScroll, verticalMaxScroll);
        this.verticalScrollBar.setScaledSliderSize((double)this.getInsetRect().height / contentHeight);
        this.verticalScrollBar.updatePos(this.verticalScrollPos, false);
        double contentWidth = Math.abs(horizontalMinScroll) + (double)this.getInsetRect().width + Math.abs(horizontalMaxScroll);
        this.horizontalScrollBar.setRange(horizontalMinScroll, horizontalMaxScroll);
        this.horizontalScrollBar.setScaledSliderSize((double)this.getInsetRect().width / contentWidth);
        this.horizontalScrollBar.updatePos(this.horizontalScrollPos, false);
    }

    protected void updateScrollbarExclusion() {
        if (this.scrollBarExclusionMode) {
            if (this.verticalScrollBar.isEnabled() && !this.verticalScrollBar.isHidden()) {
                if (this.verticalScrollBar.getRect().getCenterX() > this.getRect().getCenterX()) {
                    if (this.getInsetRect().getMaxX() > (double)this.verticalScrollBar.xPos()) {
                        this.getInsets().right = this.maxXPos() - this.verticalScrollBar.xPos();
                    }
                } else if (this.getInsetRect().getX() < (double)this.verticalScrollBar.maxXPos()) {
                    this.getInsets().left = this.verticalScrollBar.maxXPos() - this.xPos();
                }
            }
            if (this.horizontalScrollBar.isEnabled() && !this.horizontalScrollBar.isHidden()) {
                if (this.horizontalScrollBar.getRect().getCenterY() > this.getRect().getCenterY()) {
                    if (this.getInsetRect().getMaxY() > (double)this.horizontalScrollBar.yPos()) {
                        this.getInsets().bottom = this.maxYPos() - this.horizontalScrollBar.yPos();
                    }
                } else if (this.getInsetRect().getY() < (double)this.horizontalScrollBar.maxYPos()) {
                    this.getInsets().top = this.horizontalScrollBar.maxYPos() - this.yPos();
                }
            }
        }
    }

    private void validateScrollBarExistence() {
        if (this.verticalScrollBar == null) {
            this.setVerticalScrollBar(((GuiSlideControl)((GuiSlideControl)new GuiSlideControl(GuiSlideControl.SliderRotation.VERTICAL).setPos(this.maxXPos() - 10, this.yPos())).setSize(10, this.ySize() - 10)).setDefaultBackground(-16777216, -1).setDefaultSlider(-6250336, -9408400));
            this.verticalScrollBar.addToGroup(DEFAULT_SCROLL_BAR_GROUP);
        }
        if (this.horizontalScrollBar == null) {
            this.setHorizontalScrollBar(((GuiSlideControl)((GuiSlideControl)new GuiSlideControl().setPos(this.xPos(), this.maxYPos() - 10)).setSize(this.xSize() - 10, 10)).setDefaultBackground(-16777216, -1).setDefaultSlider(-6250336, -9408400));
            this.horizontalScrollBar.addToGroup(DEFAULT_SCROLL_BAR_GROUP);
        }
    }

    public void resetScrollPositions() {
        this.validateScrollBarExistence();
        this.verticalScrollBar.updatePos(0.0);
        this.horizontalScrollBar.updatePos(0.0);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.getInsetRect().contains(mouseX, mouseY)) {
            for (MGuiElementBase element : this.scrollingElements) {
                if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
        }
        for (MGuiElementBase element : this.foregroundElements) {
            if (!element.isEnabled() || this.scrollingElements.contains(element) || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        for (MGuiElementBase element : this.scrollingElements) {
            if (!element.isEnabled() || !element.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) continue;
            return true;
        }
        for (MGuiElementBase element : this.foregroundElements) {
            if (!element.isEnabled() || this.scrollingElements.contains(element) || !element.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        for (MGuiElementBase element : this.scrollingElements) {
            if (!element.isEnabled() || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
            return true;
        }
        for (MGuiElementBase element : this.foregroundElements) {
            if (!element.isEnabled() || this.scrollingElements.contains(element) || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMGuiEvent(GuiEvent event, MGuiElementBase eventSource) {
        int xAdjustment = 0;
        int yAdjustment = 0;
        if (eventSource == this.verticalScrollBar) {
            yAdjustment = this.verticalScrollPos - (int)this.verticalScrollBar.getPosition();
            this.verticalScrollPos = (int)this.verticalScrollBar.getPosition();
        } else if (eventSource == this.horizontalScrollBar) {
            xAdjustment = this.horizontalScrollPos - (int)this.horizontalScrollBar.getPosition();
            this.horizontalScrollPos = (int)this.horizontalScrollBar.getPosition();
        }
        for (MGuiElementBase scrollableElement : this.scrollingElements) {
            if (this.smoothScroll) {
                scrollableElement.translateAnim(xAdjustment, yAdjustment, this.animSpeed);
                continue;
            }
            scrollableElement.translate(xAdjustment, yAdjustment);
        }
    }

    public GuiScrollElement setListMode(ListMode listMode) {
        this.listMode = listMode;
        if (listMode != ListMode.DISABLED) {
            this.setAllowedScrollAxes(!listMode.horizontal(), listMode.horizontal());
        }
        return this;
    }

    public GuiScrollElement setListSpacing(int listSpacing) {
        this.listSpacing = listSpacing;
        return this;
    }

    public GuiScrollElement applyBackgroundElement(MGuiElementBase backgroundElement) {
        if (this.backgroundElement != null) {
            this.removeChild(this.backgroundElement);
        }
        this.backgroundElement = backgroundElement;
        this.addElement(this.backgroundElement);
        this.updateScrollElement();
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase element : this.backgroundElements) {
            if (!element.isEnabled()) continue;
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
        double xPos = this.getInsetRect().x;
        double yPos = this.getInsetRect().y;
        double xSize = this.getInsetRect().width;
        double ySize = this.getInsetRect().height;
        double yResScale = (double)minecraft.field_71440_d / (double)this.screenHeight;
        double xResScale = (double)minecraft.field_71443_c / (double)this.screenWidth;
        double scaledWidth = xSize * xResScale;
        double scaledHeight = ySize * yResScale;
        int x = (int)(xPos * xResScale);
        int y = (int)((double)minecraft.field_71440_d - yPos * yResScale - scaledHeight);
        ScissorHelper.pushScissor(x, y, (int)scaledWidth, (int)scaledHeight);
        if (this.backgroundElement != null) {
            this.backgroundElement.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
        for (MGuiElementBase element : this.scrollingElements) {
            if (!element.isEnabled() || element == this.backgroundElement) continue;
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
        ScissorHelper.popScissor();
        for (MGuiElementBase element : this.foregroundElements) {
            if (!element.isEnabled() || this.scrollingElements.contains(element)) continue;
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void addDefaultListener(MGuiElementBase childElement) {
        if (childElement instanceof IGuiEventDispatcher && ((IGuiEventDispatcher)((Object)childElement)).getListener() == null) {
            if (this.getParent() instanceof IGuiEventListener) {
                ((IGuiEventDispatcher)((Object)childElement)).setListener((IGuiEventListener)((Object)this.getParent()));
            } else if (this.modularGui instanceof IGuiEventListener) {
                ((IGuiEventDispatcher)((Object)childElement)).setListener((IGuiEventListener)((Object)this.modularGui));
            }
        }
    }

    @Override
    public Rectangle addBoundsToRect(Rectangle enclosingRect) {
        int enRectMaxX = (int)enclosingRect.getMaxX();
        int enRectMaxY = (int)enclosingRect.getMaxY();
        if (this.getRect().x < enclosingRect.x) {
            enclosingRect.x = this.getRect().x;
            enclosingRect.width = enRectMaxX - enclosingRect.x;
        }
        if (this.getRect().getMaxX() > (double)enRectMaxX) {
            enclosingRect.width = (int)this.getRect().getMaxX() - enclosingRect.x;
        }
        if (this.getRect().y < enclosingRect.y) {
            enclosingRect.y = this.getRect().y;
            enclosingRect.height = enRectMaxY - enclosingRect.y;
        }
        if (this.getRect().getMaxY() > (double)enRectMaxY) {
            enclosingRect.height = (int)this.getRect().getMaxY() - enclosingRect.y;
        }
        for (MGuiElementBase element : this.childElements) {
            if (this.scrollingElements.contains(element)) continue;
            element.addBoundsToRect(enclosingRect);
        }
        return enclosingRect;
    }

    @Override
    public boolean allowMouseOver(MGuiElementBase elementRequesting, int mouseX, int mouseY) {
        if (this.scrollingElements.contains(elementRequesting)) {
            return this.getInsetRect().contains(mouseX, mouseY);
        }
        return super.allowMouseOver(elementRequesting, mouseX, mouseY);
    }

    @Override
    public void xSizeChanged(MGuiElementBase elementChanged) {
        if (this.scrollingElements.contains(elementChanged) && elementChanged.reportXSizeChange) {
            int vsp = this.verticalScrollPos;
            int hsp = this.horizontalScrollPos;
            this.resetScrollPositions();
            this.updateScrollElement();
            this.resetScrollPositions();
            this.verticalScrollBar.updatePos(vsp);
            this.horizontalScrollBar.updatePos(hsp);
        }
    }

    @Override
    public void ySizeChanged(MGuiElementBase elementChanged) {
        if (this.scrollingElements.contains(elementChanged) && elementChanged.reportYSizeChange) {
            int vsp = this.verticalScrollPos;
            int hsp = this.horizontalScrollPos;
            this.resetScrollPositions();
            this.updateScrollBounds();
            this.updateScrollElement();
            this.resetScrollPositions();
            this.verticalScrollBar.updatePos(vsp);
            this.horizontalScrollBar.updatePos(hsp);
        }
    }

    public Rectangle getScrollBounds() {
        return this.scrollBounds;
    }

    public static enum ListMode {
        DISABLED(false, false, false),
        VERTICAL(false, false, false),
        VERT_LOCK_POS(false, false, true),
        VERT_LOCK_POS_WIDTH(false, true, true),
        HORIZONTAL(true, false, false),
        HORIZ_LOCK_POS(true, false, true),
        HORIZ_LOCK_POS_HEIGHT(true, true, true);

        private final boolean horizontal;
        private final boolean lockWidth;
        private final boolean lockPos;

        private ListMode(boolean horizontal, boolean lockWidth, boolean lockPos) {
            this.horizontal = horizontal;
            this.lockWidth = lockWidth;
            this.lockPos = lockPos;
        }

        public boolean horizontal() {
            return this.horizontal;
        }

        public boolean lockPos() {
            return this.lockPos;
        }

        public boolean lockWidth() {
            return this.lockWidth;
        }
    }
}

