/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.art.integration;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.NumberedOreDictStack;
import zmaster587.libVulpes.recipe.RecipesMachine;

public class CraftTweaker {
    protected static final List<IAction> LATE_ACTIONS = new LinkedList<IAction>();
    private static CraftTweaker INSTANCE;

    public Class<?> getRecipeClass() {
        return null;
    }

    public static CraftTweaker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CraftTweaker();
        }
        return INSTANCE;
    }

    protected static List<IRecipe> getRecipesForMachine(Class<?> machineClass) {
        try {
            Class.forName(machineClass.getName());
            List recipeList = RecipesMachine.getInstance().getRecipes(machineClass);
            if (recipeList == null) {
                throw new ClassNotFoundException("Machine Recipe Class " + machineClass.toString() + " not found in AR Recipe Registry");
            }
            return recipeList;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return new ArrayList<IRecipe>();
        }
    }

    public static void performCraftTweakerActions() {
        try {
            LATE_ACTIONS.forEach(CraftTweakerAPI::apply);
        }
        catch (Exception e) {
            e.printStackTrace();
            CraftTweakerAPI.logError((String)"Error while applying actions", (Throwable)e);
        }
    }

    protected static void addAction(IAction action) {
        if (!LATE_ACTIONS.contains(action)) {
            LATE_ACTIONS.add(action);
        }
    }

    public String formatObjectArray(Object[] objArray) {
        String ret = "";
        boolean first = true;
        for (Object obj : objArray) {
            if (!first) {
                ret = ret + "; ";
            }
            ret = ret + this.formatObject(obj);
            if (!first) continue;
            first = false;
        }
        return ret;
    }

    private String formatObject(Object obj) {
        if (obj instanceof FluidStack) {
            return "Fluid: " + ((FluidStack)obj).getFluid().getName() + "|Count: " + ((FluidStack)obj).amount;
        }
        if (obj instanceof ILiquidStack) {
            return "Fluid: " + ((ILiquidStack)obj).getDisplayName() + "|Count: " + ((ILiquidStack)obj).getAmount();
        }
        if (obj instanceof ItemStack) {
            return "Item: " + ((ItemStack)obj).func_82833_r() + "|Count: " + ((ItemStack)obj).func_190916_E();
        }
        if (obj instanceof IItemStack) {
            return "Item: " + ((IItemStack)obj).getDisplayName() + "|Count: " + ((IItemStack)obj).getAmount();
        }
        if (obj instanceof IOreDictEntry) {
            return "OreDict: " + ((IOreDictEntry)obj).getName() + "|Count: " + ((IOreDictEntry)obj).getAmount();
        }
        if (obj instanceof NumberedOreDictStack) {
            return " OreDict: " + ((NumberedOreDictStack)obj).getOre() + "|Count: " + ((NumberedOreDictStack)obj).getNumber();
        }
        return "Null: null";
    }

    protected static Object[] convertFromCT(Object[] input) {
        if (input != null && input.length > 0) {
            int i;
            ArrayList<FluidStack> vanillaFluids = new ArrayList<FluidStack>();
            ArrayList<ItemStack> vanillaItems = new ArrayList<ItemStack>();
            ArrayList<NumberedOreDictStack> oreDicts = new ArrayList<NumberedOreDictStack>();
            for (Object element : input) {
                NumberedOreDictStack oreStack;
                if (element == null) continue;
                if (CraftTweaker.isLiquid(element)) {
                    FluidStack liquidStack = CraftTweaker.getLiquid(element);
                    if (liquidStack == null) continue;
                    vanillaFluids.add(liquidStack);
                    continue;
                }
                if (CraftTweaker.isItem(element)) {
                    ItemStack itemStack = CraftTweaker.getItem(element);
                    if (itemStack == null) continue;
                    vanillaItems.add(itemStack);
                    continue;
                }
                if (!CraftTweaker.isOreDict(element) || (oreStack = CraftTweaker.getOreDict(element)) == null) continue;
                oreDicts.add(oreStack);
            }
            Object[] returnObj = new Object[vanillaFluids.size() + vanillaItems.size() + oreDicts.size()];
            int objIndex = 0;
            for (i = 0; i < vanillaFluids.size(); ++i) {
                returnObj[objIndex] = vanillaFluids.get(i);
                ++objIndex;
            }
            for (i = 0; i < vanillaItems.size(); ++i) {
                returnObj[objIndex] = vanillaItems.get(i);
                ++objIndex;
            }
            for (i = 0; i < oreDicts.size(); ++i) {
                returnObj[objIndex] = oreDicts.get(i);
                ++objIndex;
            }
            return returnObj;
        }
        return new Object[0];
    }

    private static boolean isItem(Object ctObj) {
        if (ctObj instanceof IItemStack || ctObj instanceof ItemStack) {
            return true;
        }
        if (ctObj instanceof IIngredient) {
            return ((IIngredient)ctObj).getInternal() instanceof IItemStack || ((IIngredient)ctObj).getInternal() instanceof ItemStack;
        }
        return false;
    }

    protected static boolean isLiquid(Object ctObj) {
        if (ctObj instanceof ILiquidStack || ctObj instanceof FluidStack) {
            return true;
        }
        if (ctObj instanceof IIngredient) {
            return ((IIngredient)ctObj).getInternal() instanceof ILiquidStack || ((IIngredient)ctObj).getInternal() instanceof FluidStack;
        }
        return false;
    }

    private static boolean isOreDict(Object ctObj) {
        if (ctObj instanceof IIngredient) {
            return ((IIngredient)ctObj).getInternal() instanceof IOreDictEntry;
        }
        return ctObj instanceof IOreDictEntry;
    }

    private static ItemStack getItem(Object obj) {
        if (CraftTweaker.isItem(obj)) {
            if (obj instanceof ItemStack) {
                return (ItemStack)obj;
            }
            if (obj instanceof IIngredient) {
                if (((IIngredient)obj).getInternal() instanceof ItemStack) {
                    return (ItemStack)((IIngredient)obj).getInternal();
                }
                return CraftTweaker.toVanilla((IItemStack)((IIngredient)obj).getInternal());
            }
            return CraftTweaker.toVanilla((IItemStack)obj);
        }
        return ItemStack.field_190927_a;
    }

    private static FluidStack getLiquid(Object obj) {
        if (CraftTweaker.isLiquid(obj)) {
            if (obj instanceof FluidStack) {
                return (FluidStack)obj;
            }
            if (obj instanceof IIngredient) {
                if (((IIngredient)obj).getInternal() instanceof FluidStack) {
                    return (FluidStack)((IIngredient)obj).getInternal();
                }
                return CraftTweaker.toVanilla((ILiquidStack)((IIngredient)obj).getInternal());
            }
            return CraftTweaker.toVanilla((ILiquidStack)obj);
        }
        return null;
    }

    private static NumberedOreDictStack getOreDict(Object obj) {
        IIngredient ingredient;
        Object type;
        if (obj instanceof IIngredient && CraftTweaker.isOreDict(obj) && (type = (ingredient = (IIngredient)obj).getInternal()) instanceof IOreDictEntry) {
            return CraftTweaker.toVanilla((IOreDictEntry)type, ingredient.getAmount());
        }
        if (obj instanceof IOreDictEntry) {
            return CraftTweaker.toVanilla((IOreDictEntry)obj, ((IOreDictEntry)obj).getAmount());
        }
        return null;
    }

    private static NumberedOreDictStack toVanilla(IOreDictEntry oreDict, int amount) {
        return new NumberedOreDictStack(oreDict.getName(), amount);
    }

    private static ItemStack toVanilla(IItemStack item) {
        return InputHelper.toStack((IItemStack)item);
    }

    private static FluidStack toVanilla(ILiquidStack liquid) {
        return InputHelper.toFluid((ILiquidStack)liquid);
    }

    protected class Clear
    implements IAction {
        public void apply() {
            if (CraftTweaker.this.getRecipeClass() != null) {
                CraftTweaker.getRecipesForMachine(CraftTweaker.this.getRecipeClass()).clear();
            }
        }

        public String describe() {
            if (CraftTweaker.this.getRecipeClass() != null) {
                return "Cleared " + CraftTweaker.this.getRecipeClass().getSimpleName() + " Recipes";
            }
            return "";
        }
    }

    protected class Remove
    implements IAction {
        final FluidStack[] fluidOutput;
        final ItemStack[][] itemOutput;

        public Remove(FluidStack[] output) {
            this(output, null);
        }

        public Remove(ItemStack[][] output) {
            this(null, output);
        }

        public Remove(FluidStack[] fluidOutput, ItemStack[][] itemOutput) {
            this.fluidOutput = fluidOutput;
            this.itemOutput = itemOutput;
        }

        private ItemStack[] getAllStacks(ItemStack[][] stacks) {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            ItemStack[][] itemStackArray = stacks;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack[] stack;
                for (ItemStack element : stack = itemStackArray[i]) {
                    if (element == null) continue;
                    stackList.add(element);
                }
            }
            return stackList.toArray(new ItemStack[stackList.size()]);
        }

        private ItemStack[] getAllStacks(List<ItemStack> list) {
            return list.toArray(new ItemStack[list.size()]);
        }

        public boolean matches(IRecipe recipe) {
            int i;
            if (recipe == null) {
                return false;
            }
            int numFluidsToMatch = 0;
            int numItemsToMatch = 0;
            if (this.itemOutput != null) {
                ItemStack[] recipeArray;
                ItemStack[] matchArray = this.getAllStacks(this.itemOutput);
                numItemsToMatch = matchArray.length;
                if (numItemsToMatch != (recipeArray = this.getAllStacks(recipe.getOutput())).length) {
                    return false;
                }
                block0: for (i = 0; i < matchArray.length; ++i) {
                    for (ItemStack element : recipeArray) {
                        ItemStack stack1 = matchArray[i].func_77946_l();
                        stack1.func_190920_e(1);
                        ItemStack stack2 = element.func_77946_l();
                        stack2.func_190920_e(1);
                        if (ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2) && --numItemsToMatch == 0) continue block0;
                    }
                }
            }
            if (this.fluidOutput != null) {
                if (this.fluidOutput.length != recipe.getFluidOutputs().size()) {
                    return false;
                }
                numFluidsToMatch = this.fluidOutput.length;
                for (i = 0; i < this.fluidOutput.length; ++i) {
                    for (int j = 0; j < recipe.getFluidOutputs().size(); ++j) {
                        if (this.fluidOutput[i] == null || this.fluidOutput[i].getFluid() != ((FluidStack)recipe.getFluidOutputs().get(j)).getFluid()) continue;
                        --numFluidsToMatch;
                    }
                }
            }
            return numFluidsToMatch == 0 && numItemsToMatch == 0;
        }

        public void apply() {
            if (CraftTweaker.this.getRecipeClass() != null) {
                List<IRecipe> recipeList = CraftTweaker.getRecipesForMachine(CraftTweaker.this.getRecipeClass());
                ListIterator<IRecipe> recipeIterator = recipeList.listIterator();
                while (recipeIterator.hasNext()) {
                    IRecipe currentRecipe = recipeIterator.next();
                    if (!this.matches(currentRecipe)) continue;
                    recipeIterator.remove();
                    break;
                }
            }
        }

        public String describe() {
            if (CraftTweaker.this.getRecipeClass() != null) {
                boolean itemSupplied = this.itemOutput != null;
                boolean fluidSupplied = this.fluidOutput != null;
                String outputStr = "Removed Recipe for " + CraftTweaker.this.getRecipeClass().getSimpleName() + " with output \"";
                if (itemSupplied) {
                    outputStr = outputStr + "-" + CraftTweaker.this.formatObjectArray(this.getAllStacks(this.itemOutput)).split("\\|")[0];
                }
                if (fluidSupplied) {
                    outputStr = outputStr + "-" + CraftTweaker.this.formatObjectArray(this.fluidOutput).split("\\|")[0] + "\"";
                }
                return outputStr + "\"";
            }
            return "";
        }
    }

    protected class Add
    implements IAction {
        final Object[] out;
        final int time;
        final int power;
        final Object[] inputs;

        public Add(Object[] out, int time, int power, Object[] inputs) {
            this.out = out;
            this.time = time;
            this.power = power;
            this.inputs = inputs;
        }

        public void apply() {
            if (CraftTweaker.this.getRecipeClass() != null) {
                RecipesMachine.getInstance().addRecipe(CraftTweaker.this.getRecipeClass(), this.out, this.time, this.power, this.inputs);
            }
        }

        public String describe() {
            return "Added Recipe" + (CraftTweaker.this.getRecipeClass() != null ? " for " + CraftTweaker.this.getRecipeClass().getSimpleName() : "") + ": INPUT:[" + CraftTweaker.this.formatObjectArray(this.inputs) + "] -> OUTPUT:[" + CraftTweaker.this.formatObjectArray(this.out) + "]; Time: " + this.time + "; Power: " + this.power;
        }
    }
}

