/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.remove;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsBaseCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class BlockEnchantRemoveCommand
extends BlockDropsBaseCommand {
    public String func_71517_b() {
        return "remove";
    }

    @Override
    protected String getCommandPath() {
        return "block.enchant.remove";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        BlockDropData blockDropData;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a block first using '/bd block select'"));
            return;
        }
        String enchant = args[0];
        if (!blockDropData.enchantmentList.contains(enchant)) {
            player.func_145747_a(ChatUtil.getNormalMessage("That enchant does not exist."));
            return;
        }
        blockDropData.enchantmentList.remove(enchant);
        player.func_145747_a(ChatUtil.getNormalMessage("Removed Enchantment '" + enchant + "'"));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.length == 1 && sender instanceof EntityPlayer) {
            BlockDropData blockDropData;
            EntityPlayer player = (EntityPlayer)sender;
            IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
            BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
            if (blockDropData != null) {
                tabList.addAll(BlockEnchantRemoveCommand.func_175762_a((String[])args, blockDropData.enchantmentList));
            }
        }
        return tabList;
    }
}

