/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsBaseCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropDupeCommand
extends BlockDropsBaseCommand {
    public String func_71517_b() {
        return "dupe";
    }

    @Override
    protected String getCommandPath() {
        return "drop.dupe";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        int metadata;
        BlockDropData blockDropData;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a block first using '/bd block select'"));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, playerData.getSelectedDrop());
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a drop first using '/bd drop select'"));
            return;
        }
        String itemID = args[0];
        String metadataStr = args[1];
        try {
            metadata = Integer.parseInt(metadataStr);
        }
        catch (NumberFormatException e) {
            player.func_145747_a(ChatUtil.getNormalMessage("Metadata can only be a whole number."));
            return;
        }
        Item item = Item.func_111206_d((String)itemID);
        if (item == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("The item with that id does not exist."));
            return;
        }
        DropData newDropData = dropData.duplicate();
        newDropData.id = itemID;
        newDropData.metadata = metadata;
        blockDropData.dropdatalist.add(newDropData);
        playerData.setSelectedDrop(newDropData.id + "," + newDropData.metadata);
        player.func_145747_a(ChatUtil.getNormalMessage("Duplicated drop '" + itemID + "' with metadata '" + metadataStr + "'"));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> tabListItems = new ArrayList<String>();
        if (args.length == 1) {
            tabListItems.addAll(DropDupeCommand.func_175762_a((String[])args, (Collection)Item.field_150901_e.func_148742_b()));
        }
        return tabListItems;
    }
}

