/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsBaseCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class BlockAddCommand
extends BlockDropsBaseCommand {
    public String func_71517_b() {
        return "add";
    }

    @Override
    protected String getCommandPath() {
        return "block.add";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        String blockInfo;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        String blockID = args[0];
        String metadataStr = args[1];
        if (!metadataStr.equals("*")) {
            try {
                int metadata = Integer.parseInt(metadataStr);
            }
            catch (NumberFormatException e) {
                player.func_145747_a(ChatUtil.getNormalMessage("Metadata can either be '*' for the wildcard or a number '0-99999'."));
                return;
            }
        }
        if (ConfigurationHandler.blockDropMap.containsKey(blockInfo = blockID + "," + metadataStr)) {
            player.func_145747_a(ChatUtil.getNormalMessage("Drops for that block already exists."));
            return;
        }
        ConfigurationHandler.blockDropMap.put(blockInfo, new BlockDropData());
        playerData.setSelectedBlock(blockInfo);
        player.func_145747_a(ChatUtil.getNormalMessage("Added block '" + blockID + "' with metadata '" + metadataStr + "'"));
        player.func_145747_a(ChatUtil.getNormalMessage("Use '/bd block set' to edit the block drops now."));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> tabListItems = new ArrayList<String>();
        if (args.length == 1) {
            tabListItems.addAll(BlockAddCommand.func_175762_a((String[])args, (Collection)Item.field_150901_e.func_148742_b()));
        }
        return tabListItems;
    }
}

