/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsTreeBaseCommand;
import net.theawesomegem.blockdropstweaker.common.command.add.DropTraitAddCommand;
import net.theawesomegem.blockdropstweaker.common.command.remove.DropTraitClearCommand;
import net.theawesomegem.blockdropstweaker.common.command.remove.DropTraitRemoveCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropTraitCommand
extends BlockDropsTreeBaseCommand {
    public DropTraitCommand() {
        this.addSubcommand((ICommand)new DropTraitAddCommand());
        this.addSubcommand((ICommand)new DropTraitRemoveCommand());
        this.addSubcommand((ICommand)new DropTraitClearCommand());
    }

    public String func_71517_b() {
        return "trait";
    }

    @Override
    protected String getCommandPath() {
        return "drop.trait";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        BlockDropData blockDropData;
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("The block associated with the drop does not exist."));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, playerData.getSelectedDrop());
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a drop first using '/bd drop select'"));
            return;
        }
        player.func_145747_a(ChatUtil.getNormalMessage("-----Traits-----"));
        for (String trait : dropData.traitList) {
            player.func_145747_a(ChatUtil.getNormalMessage(trait));
        }
        player.func_145747_a(ChatUtil.getNormalMessage("----------------"));
    }
}

