/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsTreeBaseCommand;
import net.theawesomegem.blockdropstweaker.common.command.add.DropNbtAddCommand;
import net.theawesomegem.blockdropstweaker.common.command.remove.DropNbtClearCommand;
import net.theawesomegem.blockdropstweaker.common.command.remove.DropNbtRemoveCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropNbtCommand
extends BlockDropsTreeBaseCommand {
    public DropNbtCommand() {
        this.addSubcommand((ICommand)new DropNbtAddCommand());
        this.addSubcommand((ICommand)new DropNbtRemoveCommand());
        this.addSubcommand((ICommand)new DropNbtClearCommand());
    }

    public String func_71517_b() {
        return "nbt";
    }

    @Override
    protected String getCommandPath() {
        return "drop.nbt";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        BlockDropData blockDropData;
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("The block associated with the drop does not exist."));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, playerData.getSelectedDrop());
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a drop first using '/bd drop select'"));
            return;
        }
        player.func_145747_a(ChatUtil.getNormalMessage("-----NBT-----"));
        for (String nbt : dropData.nbtList) {
            player.func_145747_a(ChatUtil.getNormalMessage(nbt));
        }
        player.func_145747_a(ChatUtil.getNormalMessage("----------------"));
    }
}

