/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network.handler;

import java.util.ArrayList;
import javax.annotation.Nullable;
import li.cil.scannable.client.scanning.ScanResultProviderStructure;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.MessageStructureRequest;
import li.cil.scannable.common.network.message.MessageStructureResponse;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public final class MessageHandlerStructureRequest
implements IMessageHandler<MessageStructureRequest, IMessage> {
    @Nullable
    public IMessage onMessage(MessageStructureRequest message, MessageContext context) {
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread(context.netHandler);
        if (thread.func_152345_ab()) {
            this.onMessageSynchronized(message, context);
        } else {
            thread.func_152344_a(() -> this.onMessageSynchronized(message, context));
        }
        return null;
    }

    private void onMessageSynchronized(MessageStructureRequest message, MessageContext context) {
        int dimension = message.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return;
        }
        BlockPos center = message.getCenter();
        float radius = message.getRadius();
        boolean hideExplored = message.hideExplored();
        ArrayList<ScanResultProviderStructure.StructureLocation> structures = new ArrayList<ScanResultProviderStructure.StructureLocation>();
        float sqRadius = radius * radius;
        for (String name : Settings.getStructures()) {
            BlockPos pos = world.func_72863_F().func_180513_a((World)world, name, center, hideExplored);
            if (pos == null || !(center.func_177951_i((Vec3i)pos) <= (double)sqRadius)) continue;
            structures.add(new ScanResultProviderStructure.StructureLocation(name, pos));
        }
        if (structures.isEmpty()) {
            return;
        }
        Network.INSTANCE.getWrapper().sendTo((IMessage)new MessageStructureResponse(structures.toArray(new ScanResultProviderStructure.StructureLocation[structures.size()])), context.getServerHandler().field_147369_b);
    }
}

