/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.bandit;

import com.teammetallurgy.atum.entity.ai.AIBowAttack;
import com.teammetallurgy.atum.entity.bandit.EntityBanditBase;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNomad
extends EntityBanditBase
implements IRangedAttackMob {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityNomad.class, (DataSerializer)DataSerializers.field_187198_h);
    private AIBowAttack aiArrowAttack = new AIBowAttack<EntityNomad>(this, 0.75, 35, 12.0f);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.0, false){

        public void func_75251_c() {
            super.func_75251_c();
            EntityNomad.this.func_184724_a(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityNomad.this.func_184724_a(true);
        }
    };

    public EntityNomad(World world) {
        super(world);
        this.field_70728_aV = 6;
        this.setCombatTask();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(13.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(AtumItems.SHORT_BOW));
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        return livingdata;
    }

    private void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
        EntityArrow arrow = this.getArrow(distanceFactor);
        double x = target.field_70165_t - this.field_70165_t;
        double y = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow.field_70163_u;
        double z = target.field_70161_v - this.field_70161_v;
        double height = MathHelper.func_76133_a((double)(x * x + z * z));
        arrow.func_70186_c(x, y + height * (double)0.2f, z, 1.6f, (float)(11 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    private EntityArrow getArrow(float distanceFactor) {
        EntityTippedArrow arrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        arrow.func_190547_a((EntityLivingBase)this, distanceFactor);
        return arrow;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public void func_184201_a(EntityEquipmentSlot slot, @Nonnull ItemStack stack) {
        super.func_184201_a(slot, stack);
        if (!this.field_70170_p.field_72995_K && slot == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public float func_70047_e() {
        return 1.74f;
    }

    public double func_70033_W() {
        return -0.35;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return AtumLootTables.NOMAD;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }
}

