/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.tileentity;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.base.BlockChestBase;
import com.teammetallurgy.atum.blocks.base.tileentity.TileEntityChestBase;
import com.teammetallurgy.atum.client.model.chest.ModelSarcophagus;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTileChest
extends TileEntitySpecialRenderer<TileEntityChestBase> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();
    private final ModelSarcophagus sarcophagus = new ModelSarcophagus();
    private final ModelChest normalChest = new ModelChest();
    private final ModelChest largeChest = new ModelLargeChest();

    public void render(@Nonnull TileEntityChestBase te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int meta;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        if (te.func_145830_o()) {
            Block block = te.func_145838_q();
            meta = te.func_145832_p();
            if (block instanceof BlockChestBase && meta == 0) {
                ((BlockChestBase)block).func_176455_e(te.func_145831_w(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()));
                meta = te.func_145832_p();
            }
            te.func_145979_i();
        } else {
            meta = 0;
        }
        if (te.field_145992_i == null && te.field_145991_k == null) {
            float adjacentLid;
            ResourceLocation chestTexture;
            String name;
            ModelChest modelchest;
            if (te.field_145990_j == null && te.field_145988_l == null) {
                modelchest = this.normalChest;
                if (destroyStage >= 0) {
                    this.func_147499_a(field_178460_a[destroyStage]);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    GlStateManager.func_179128_n((int)5888);
                } else {
                    name = Objects.requireNonNull(te.func_145838_q().getRegistryName()).func_110623_a();
                    chestTexture = CACHE.get(name);
                    if (chestTexture == null) {
                        chestTexture = new ResourceLocation("atum", "textures/blocks/chest/" + name + ".png");
                        CACHE.put(name, chestTexture);
                    }
                    this.func_147499_a(chestTexture);
                }
            } else {
                modelchest = this.largeChest;
                if (destroyStage >= 0) {
                    this.func_147499_a(field_178460_a[destroyStage]);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)8.0f, (float)4.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    GlStateManager.func_179128_n((int)5888);
                } else {
                    name = Objects.requireNonNull(te.func_145838_q().getRegistryName()).func_110623_a() + "_double";
                    chestTexture = CACHE.get(name);
                    if (chestTexture == null) {
                        chestTexture = new ResourceLocation("atum", "textures/blocks/chest/" + name + ".png");
                        CACHE.put(name, chestTexture);
                    }
                    this.func_147499_a(chestTexture);
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            if (destroyStage < 0) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            int angle = 0;
            if (meta == 2) {
                angle = 180;
            }
            if (meta == 3) {
                angle = 0;
            }
            if (meta == 4) {
                angle = 90;
            }
            if (meta == 5) {
                angle = -90;
            }
            if (meta == 2 && te.field_145990_j != null) {
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (meta == 5 && te.field_145988_l != null) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float lid = te.field_145986_n + (te.field_145989_m - te.field_145986_n) * partialTicks;
            if (te.field_145992_i != null && (adjacentLid = te.field_145992_i.field_145986_n + (te.field_145992_i.field_145989_m - te.field_145992_i.field_145986_n) * partialTicks) > lid) {
                lid = adjacentLid;
            }
            if (te.field_145991_k != null && (adjacentLid = te.field_145991_k.field_145986_n + (te.field_145991_k.field_145989_m - te.field_145991_k.field_145986_n) * partialTicks) > lid) {
                lid = adjacentLid;
            }
            lid = 1.0f - lid;
            lid = 1.0f - lid * lid * lid;
            if (te.func_145838_q() == AtumBlocks.SARCOPHAGUS) {
                GlStateManager.func_179109_b((float)1.0f, (float)-0.5f, (float)0.5f);
                this.sarcophagus.lid.field_78796_g = -lid / 2.0f;
                this.sarcophagus.liddeco1.field_78796_g = -lid / 2.0f;
                this.sarcophagus.liddeco2.field_78796_g = -lid / 2.0f;
                this.sarcophagus.liddeco3.field_78796_g = -lid / 2.0f;
                this.sarcophagus.gemhead.field_78796_g = -lid / 2.0f;
                this.sarcophagus.gemchest.field_78796_g = -lid / 2.0f;
                this.sarcophagus.renderAll();
            } else {
                modelchest.field_78234_a.field_78795_f = -(lid * 1.5707964f);
                modelchest.func_78231_a();
            }
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            }
        }
    }
}

