/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.crafttweaker.support.ic2;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import ic2.api.recipe.ICannerEnrichRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import info.tritusk.modpack.crafttweaker.support.ic2.CraftTweakerActions;
import info.tritusk.modpack.crafttweaker.support.ic2.IC2RecipeInputs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="ic2")
@ZenClass(value="mods.ic2.Canner")
@ZenRegister
public final class CannerSupport {
    @ZenMethod
    public static void addBottleRecipe(IItemStack output, IIngredient container, IIngredient filler) {
        CraftTweakerActions.apply(new BottleAction(container, filler, output));
    }

    @ZenMethod
    public static void addEnrichRecipe(ILiquidStack output, ILiquidStack input, IIngredient additive) {
        CraftTweakerActions.apply(new EnrichAction(input, additive, output));
    }

    private static final class EnrichAction
    implements IAction {
        private final FluidStack input;
        private final FluidStack output;
        private final IRecipeInput additive;

        EnrichAction(ILiquidStack input, IIngredient additive, ILiquidStack output) {
            this.input = CraftTweakerMC.getLiquidStack((ILiquidStack)input);
            this.additive = IC2RecipeInputs.of(additive);
            this.output = CraftTweakerMC.getLiquidStack((ILiquidStack)output);
        }

        public void apply() {
            Recipes.cannerEnrich.addRecipe((Object)new ICannerEnrichRecipeManager.Input(this.input, this.additive), (Object)this.output, null, false);
        }

        public String describe() {
            return null;
        }
    }

    private static final class BottleAction
    implements IAction {
        private final IRecipeInput container;
        private final IRecipeInput filler;
        private final ItemStack output;

        BottleAction(IIngredient container, IIngredient filler, IItemStack output) {
            this.container = IC2RecipeInputs.of(container);
            this.filler = IC2RecipeInputs.of(filler);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            Recipes.cannerBottle.addRecipe(this.container, this.filler, this.output, false);
        }

        public String describe() {
            return null;
        }
    }
}

