/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import zmaster587.libVulpes.event.BucketHandler;
import zmaster587.libVulpes.util.EmbeddedInventory;

public class FluidUtils {
    private static Map<String, List<String>> fluidEquivilentMapping = new HashMap<String, List<String>>();

    public static boolean containsFluid(ItemStack stack) {
        return stack != null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        IFluidHandlerItem fluidItem;
        FluidStack fluidStack;
        return FluidUtils.containsFluid(stack) && (fluidStack = (fluidItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)).getTankProperties()[0].getContents()) != null && FluidUtils.areFluidsSameType(fluidStack.getFluid(), fluid);
    }

    public static int getFluidItemCapacity(ItemStack stack) {
        if (FluidUtils.containsFluid(stack)) {
            IFluidHandlerItem fluidItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
            return fluidItem.getTankProperties()[0].getCapacity();
        }
        return 0;
    }

    public static IFluidHandlerItem getFluidHandler(ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
    }

    public static FluidStack getFluidForItem(ItemStack item) {
        if (!FluidUtils.containsFluid(item)) {
            return null;
        }
        IFluidHandlerItem fluidItem = (IFluidHandlerItem)item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
        return fluidItem.getTankProperties()[0].getContents();
    }

    public static boolean attemptDrainContainerIInv(EmbeddedInventory inv, IFluidTank tank, ItemStack stack, int inputSlot, int outputSlot) {
        if (FluidUtils.containsFluid(stack)) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            IFluidHandlerItem fluidItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
            FluidStack itemFluidStack = FluidUtils.getFluidForItem(stack);
            if (itemFluidStack == null && tank.getFluid() != null) {
                int amt = 0;
                if (stack.func_77973_b() == Items.field_151133_ar) {
                    Item newBucket;
                    if (tank.getFluidAmount() > 1000 && (newBucket = BucketHandler.INSTANCE.getItemFromFluid(tank.getFluid().getFluid())) != null) {
                        stack = new ItemStack(newBucket);
                        amt = 1000;
                    }
                } else {
                    amt = fluidItem.fill(tank.getFluid(), true);
                    stack = fluidItem.getContainer();
                }
                if (amt != 0 && FluidUtils.getFluidItemCapacity(stack) == FluidUtils.getFluidForItem((ItemStack)stack).amount) {
                    if (inv.func_70301_a(outputSlot).func_190926_b()) {
                        inv.func_70299_a(outputSlot, stack);
                    } else if (ItemStack.func_77970_a((ItemStack)inv.func_70301_a(outputSlot), (ItemStack)stack) && inv.func_70301_a(outputSlot).func_77973_b().equals(stack.func_77973_b()) && inv.func_70301_a(outputSlot).func_77952_i() == stack.func_77952_i() && stack.func_77973_b().getItemStackLimit(stack) < inv.func_70301_a(outputSlot).func_190916_E()) {
                        inv.func_70301_a(outputSlot).func_190920_e(inv.func_70301_a(outputSlot).func_190916_E() + 1);
                    } else {
                        return false;
                    }
                    tank.drain(amt, true);
                    inv.func_70298_a(inputSlot, 1);
                    return true;
                }
            } else {
                FluidStack fluidStack = fluidItem.drain(tank.getCapacity() - tank.getFluidAmount(), false);
                int amountDrained = tank.fill(fluidStack, false);
                FluidStack fluidStack2 = fluidItem.drain(amountDrained, true);
                stack = fluidItem.getContainer();
                if (FluidUtils.getFluidForItem(stack) == null || fluidStack2 != null && fluidStack2.amount != 0) {
                    if (inv.func_70301_a(outputSlot).func_190926_b()) {
                        inv.func_70299_a(outputSlot, stack);
                    } else if (ItemStack.func_77970_a((ItemStack)inv.func_70301_a(outputSlot), (ItemStack)stack) && inv.func_70301_a(outputSlot).func_77973_b().equals(stack.func_77973_b()) && inv.func_70301_a(outputSlot).func_77952_i() == stack.func_77952_i() && stack.func_77973_b().getItemStackLimit(stack) > inv.func_70301_a(outputSlot).func_190916_E()) {
                        inv.func_70301_a(outputSlot).func_190920_e(inv.func_70301_a(outputSlot).func_190916_E() + 1);
                    } else {
                        return false;
                    }
                    tank.fill(fluidStack, true);
                    inv.func_70298_a(inputSlot, 1);
                    return true;
                }
            }
        }
        return false;
    }

    public static void addFluidMapping(Fluid in, String altName) {
        String fluidKeyName = in.getName();
        FluidUtils.addFluidMapping(fluidKeyName, altName);
        FluidUtils.addFluidMapping(altName, fluidKeyName);
    }

    private static void addFluidMapping(String in, String altName) {
        List<Object> mappedValues;
        String fluidKeyName = in;
        if (!fluidEquivilentMapping.containsKey(fluidKeyName)) {
            mappedValues = new LinkedList();
            fluidEquivilentMapping.put(fluidKeyName, mappedValues);
        } else {
            mappedValues = fluidEquivilentMapping.get(fluidKeyName);
        }
        mappedValues.add(altName);
    }

    public static boolean areFluidsSameType(Fluid in, Fluid otherFluid) {
        String otherFluidName;
        if (in == null || otherFluid == null) {
            return false;
        }
        String inFluidName = in.getName();
        if (inFluidName.equals(otherFluidName = otherFluid.getName())) {
            return true;
        }
        return fluidEquivilentMapping.containsKey(inFluidName) && fluidEquivilentMapping.get(inFluidName).contains(otherFluidName);
    }
}

