/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request.resources;

import javax.annotation.Nonnull;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public class ItemResource
implements IResource {
    private final ItemIdentifierStack stack;
    private final IRequestItems requester;
    private Object ccObject;

    public ItemResource(ItemIdentifierStack stack, IRequestItems requester) {
        this.stack = stack;
        this.requester = requester;
    }

    public ItemResource(LPDataInput input) {
        this.stack = input.readItemIdentifierStack();
        this.requester = null;
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeItemIdentifierStack(this.stack);
    }

    @Override
    public ItemIdentifier getAsItem() {
        return this.stack.getItem();
    }

    @Override
    public int getRequestedAmount() {
        return this.stack.getStackSize();
    }

    public ItemIdentifier getItem() {
        return this.stack.getItem();
    }

    public ItemIdentifierStack getItemStack() {
        return this.stack;
    }

    public IRequestItems getTarget() {
        return this.requester;
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        return this.requester.getRouter();
    }

    @Override
    public boolean matches(ItemIdentifier itemType, IResource.MatchSettings settings) {
        switch (settings) {
            case NORMAL: {
                return this.stack.getItem().equals(itemType);
            }
            case WITHOUT_NBT: {
                return this.stack.getItem().equalsWithoutNBT(itemType);
            }
        }
        return this.stack.getItem().equals(itemType);
    }

    @Override
    public IResource clone(int multiplier) {
        ItemIdentifierStack stack = this.stack.clone();
        stack.setStackSize(stack.getStackSize() * multiplier);
        return new ItemResource(stack, this.requester);
    }

    @Override
    public boolean mergeForDisplay(IResource resource, int withAmount) {
        if (resource instanceof ItemResource && ((ItemResource)resource).stack.getItem().equals(this.stack.getItem())) {
            this.stack.setStackSize(this.stack.getStackSize() + withAmount);
            return true;
        }
        return false;
    }

    @Override
    public IResource copyForDisplayWith(int amount) {
        ItemIdentifierStack stack = this.stack.clone();
        stack.setStackSize(amount);
        return new ItemResource(stack, this.requester);
    }

    @Override
    public Object getCCType() {
        return this.ccObject;
    }

    @Override
    public void setCCType(Object type) {
        this.ccObject = type;
    }

    @Override
    public String getDisplayText(IResource.ColorCode code) {
        StringBuilder builder = new StringBuilder();
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)(code == IResource.ColorCode.MISSING ? ChatColor.RED : ChatColor.GREEN));
        }
        builder.append(this.stack.getFriendlyName());
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)ChatColor.WHITE);
        }
        return builder.toString();
    }

    @Override
    public ItemIdentifierStack getDisplayItem() {
        return this.stack;
    }
}

