/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request.resources;

import javax.annotation.Nonnull;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public class FluidResource
implements IResource {
    private final FluidIdentifier liquid;
    private final IRequestFluid target;
    private int amount;
    private Object ccObject;

    public FluidResource(FluidIdentifier liquid, int amount, IRequestFluid target) {
        this.liquid = liquid;
        this.amount = amount;
        this.target = target;
    }

    public FluidResource(LPDataInput input) {
        this.liquid = FluidIdentifier.get(input.readItemIdentifier());
        this.amount = input.readInt();
        this.target = null;
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeItemIdentifier(this.liquid.getItemIdentifier());
        output.writeInt(this.amount);
    }

    @Override
    public ItemIdentifier getAsItem() {
        return this.liquid.getItemIdentifier();
    }

    @Override
    public int getRequestedAmount() {
        return this.amount;
    }

    public FluidIdentifier getFluid() {
        return this.liquid;
    }

    public IRequestFluid getTarget() {
        return this.target;
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        return this.target.getRouter();
    }

    @Override
    public boolean matches(ItemIdentifier itemType, IResource.MatchSettings settings) {
        if (itemType.isFluidContainer()) {
            FluidIdentifier other = FluidIdentifier.get(itemType);
            return other.equals(this.liquid);
        }
        return false;
    }

    @Override
    public IResource clone(int multiplier) {
        return new FluidResource(this.liquid, this.amount * multiplier, this.target);
    }

    @Override
    public boolean mergeForDisplay(IResource resource, int withAmount) {
        if (resource instanceof FluidResource && ((FluidResource)resource).liquid.equals(this.liquid)) {
            this.amount += withAmount;
            return true;
        }
        return false;
    }

    @Override
    public IResource copyForDisplayWith(int amount) {
        return new FluidResource(this.liquid, amount, null);
    }

    @Override
    public Object getCCType() {
        return this.ccObject;
    }

    @Override
    public void setCCType(Object type) {
        this.ccObject = type;
    }

    @Override
    public String getDisplayText(IResource.ColorCode code) {
        StringBuilder builder = new StringBuilder();
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)(code == IResource.ColorCode.MISSING ? ChatColor.RED : ChatColor.GREEN));
        }
        builder.append(this.amount);
        builder.append("mB ");
        builder.append(this.liquid.makeFluidStack(0).getLocalizedName());
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)ChatColor.WHITE);
        }
        return builder.toString();
    }

    @Override
    public ItemIdentifierStack getDisplayItem() {
        return this.liquid.getItemIdentifier().makeStack(this.amount);
    }
}

