/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe.tube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.tubes.HSTubeLine;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPColourMultiplier;
import logisticspipes.proxy.object3d.operation.LPRotation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVTransformationList;
import logisticspipes.proxy.object3d.operation.LPUVTranslation;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.renderer.newpipe.RenderEntry;
import net.minecraft.util.ResourceLocation;

public final class LineTubeRenderer
implements ISpecialPipeRenderer,
IHighlightPlacementRenderer {
    public static final LineTubeRenderer instance = new LineTubeRenderer();
    static Map<HSTubeLine.TubeLineRenderOrientation, List<IModel3D>> tubeLineBase = new HashMap<HSTubeLine.TubeLineRenderOrientation, List<IModel3D>>();
    public static Map<HSTubeLine.TubeLineRenderOrientation, IModel3D> tubeLine = new HashMap<HSTubeLine.TubeLineRenderOrientation, IModel3D>();
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/blocks/pipes/HS-Tube-Line.png");

    private LineTubeRenderer() {
    }

    public static void loadModels() {
        try {
            Map<String, IModel3D> pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/HSTube-Line_result.obj"), 7, new LPScale(0.01f));
            for (HSTubeLine.TubeLineRenderOrientation turn : HSTubeLine.TubeLineRenderOrientation.values()) {
                tubeLineBase.put(turn, new ArrayList());
            }
            pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("Side ") || ((String)entry.getKey()).contains(" Side ") || ((String)entry.getKey()).endsWith(" Side")).forEach(entry -> {
                tubeLineBase.get(HSTubeLine.TubeLineRenderOrientation.EAST_WEST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 0.0)).apply(new LPRotation(-1.5707963267948966, 0, 1, 0))));
                tubeLineBase.get(HSTubeLine.TubeLineRenderOrientation.NORTH_SOUTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
            });
            if (tubeLineBase.get(HSTubeLine.TubeLineRenderOrientation.EAST_WEST).size() != 4) {
                throw new RuntimeException("Couldn't load Tube Side. Only loaded " + tubeLineBase.get(HSTubeLine.TubeLineRenderOrientation.EAST_WEST).size());
            }
            for (HSTubeLine.TubeLineRenderOrientation turn : HSTubeLine.TubeLineRenderOrientation.values()) {
                tubeLine.put(turn, SimpleServiceLocator.cclProxy.combine((Collection<IModel3D>)tubeLineBase.get(turn)));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void renderToList(CoreUnroutedPipe pipe, List<RenderEntry> objectsToRender) {
        HSTubeLine tube;
        if (pipe instanceof HSTubeLine && (tube = (HSTubeLine)pipe).getOrientation() != null) {
            HSTubeLine.TubeLineRenderOrientation speedupDirection = tube.getOrientation().getRenderOrientation();
            objectsToRender.addAll(tubeLineBase.get(speedupDirection).stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, TEXTURE)).collect(Collectors.toList()));
        }
        if (pipe == null) {
            objectsToRender.addAll(tubeLineBase.get(HSTubeLine.TubeLineRenderOrientation.NORTH_SOUTH).stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, TEXTURE)).collect(Collectors.toList()));
        }
    }

    @Override
    public void renderHighlight(ITubeOrientation orientation) {
        HSTubeLine.TubeLineRenderOrientation direction = (HSTubeLine.TubeLineRenderOrientation)orientation.getRenderOrientation();
        tubeLine.get(direction).copy().render(LPColourMultiplier.instance(-1));
    }

    static {
        LineTubeRenderer.loadModels();
    }
}

