/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.upgrades;

import java.util.Arrays;
import javax.annotation.Nullable;
import logisticspipes.modules.ModuleCreativeTabBasedItemSink;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.modules.ModuleModBasedItemSink;
import logisticspipes.modules.ModuleOreDictItemSink;
import logisticspipes.modules.ModulePolymorphicItemSink;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.UpgradeCoordinatesGuiProvider;
import logisticspipes.network.guis.upgrade.SneakyUpgradeConfigGuiProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.IConfigPipeUpgrade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class SneakyUpgradeConfig
implements IConfigPipeUpgrade {
    public static final String SIDE_KEY = "LPSNEAKY-SIDE";

    @Override
    public boolean needsUpdate() {
        return false;
    }

    @Override
    public boolean isAllowedForPipe(CoreRoutedPipe pipe) {
        return true;
    }

    @Override
    public boolean isAllowedForModule(LogisticsModule module) {
        return module instanceof ModuleItemSink || module instanceof ModulePolymorphicItemSink || module instanceof ModuleModBasedItemSink || module instanceof ModuleOreDictItemSink || module instanceof ModuleCreativeTabBasedItemSink;
    }

    @Override
    public String[] getAllowedPipes() {
        return new String[]{"all"};
    }

    @Override
    public String[] getAllowedModules() {
        return new String[]{"itemsink"};
    }

    @Override
    public UpgradeCoordinatesGuiProvider getGUI() {
        return NewGuiHandler.getGui(SneakyUpgradeConfigGuiProvider.class);
    }

    @Nullable
    public EnumFacing getSide(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        String sideString = nbt.func_74779_i(SIDE_KEY);
        return Arrays.stream(Sides.values()).filter(side -> side.getLpName().equals(sideString)).map(Sides::getDir).findFirst().orElse(null);
    }

    public static enum Sides {
        UP(EnumFacing.UP, "LPSNEAKY-UP"),
        DOWN(EnumFacing.DOWN, "LPSNEAKY-DOWN"),
        NORTH(EnumFacing.NORTH, "LPSNEAKY-NORTH"),
        SOUTH(EnumFacing.SOUTH, "LPSNEAKY-SOUTH"),
        EAST(EnumFacing.EAST, "LPSNEAKY-EAST"),
        WEST(EnumFacing.WEST, "LPSNEAKY-WEST");

        private EnumFacing dir;
        private String lpName;

        public static String getNameForDirection(EnumFacing fd) {
            return Arrays.stream(Sides.values()).filter(side -> side.getDir() == fd).map(Sides::getLpName).findFirst().orElse("LPSNEAKY-UNKNWON");
        }

        private Sides(EnumFacing dir, String lpName) {
            this.dir = dir;
            this.lpName = lpName;
        }

        public EnumFacing getDir() {
            return this.dir;
        }

        public String getLpName() {
            return this.lpName;
        }
    }
}

