/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.gui.GuiChassiPipe;
import logisticspipes.gui.hud.HudChassisPipe;
import logisticspipes.interfaces.IBufferItems;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILegacyActiveModule;
import logisticspipes.interfaces.ISendQueueContentRecieiver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.items.ItemModule;
import logisticspipes.logisticspipes.ChassiTransportLayer;
import logisticspipes.logisticspipes.ItemModuleInformationManager;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.modules.ChassiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.pipe.ChassiOrientationPacket;
import logisticspipes.network.packets.pipe.ChassiePipeModuleContent;
import logisticspipes.network.packets.pipe.RequestChassiOrientationPacket;
import logisticspipes.network.packets.pipe.SendQueueContent;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.ModuleUpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IPromise;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.utils.EnumFacingUtil;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

@CCType(name="LogisticsChassiePipe")
public abstract class PipeLogisticsChassi
extends CoreRoutedPipe
implements ICraftItems,
IBufferItems,
ISimpleInventoryEventHandler,
ISendRoutedItem,
IProvideItems,
IHeadUpDisplayRendererProvider,
ISendQueueContentRecieiver {
    private final ChassiModule _module;
    private final ItemIdentifierInventory _moduleInventory;
    private final ModuleUpgradeManager[] _upgradeManagers;
    private boolean switchOrientationOnTick = true;
    private boolean init = false;
    public final LinkedList<ItemIdentifierStack> displayList = new LinkedList();
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private HudChassisPipe hud;
    public final LinkedList<LogisticsOrder> _extras = new LinkedList();

    public PipeLogisticsChassi(Item item) {
        super(item);
        this._moduleInventory = new ItemIdentifierInventory(this.getChassiSize(), "Chassi pipe", 1);
        this._moduleInventory.addListener(this);
        this._upgradeManagers = new ModuleUpgradeManager[this.getChassiSize()];
        for (int i = 0; i < this.getChassiSize(); ++i) {
            this._upgradeManagers[i] = new ModuleUpgradeManager(this, this.upgradeManager);
        }
        this._module = new ChassiModule(this.getChassiSize(), this);
        this.hud = new HudChassisPipe(this, this._module, this._moduleInventory);
        this.pointedDirection = null;
    }

    @Override
    protected List<TileEntity> getConnectedRawInventories() {
        if (this._cachedAdjacentInventories != null) {
            return this._cachedAdjacentInventories;
        }
        NeighborTileEntity<TileEntity> pointedItemHandler = this.getPointedItemHandler();
        this._cachedAdjacentInventories = pointedItemHandler == null ? Collections.emptyList() : Collections.singletonList(pointedItemHandler.getTileEntity());
        return this._cachedAdjacentInventories;
    }

    public void nextOrientation() {
        boolean found = false;
        EnumFacing oldOrientation = this.pointedDirection;
        for (int l = 0; l < 6; ++l) {
            this.pointedDirection = EnumFacing.values()[(this.pointedDirection == null ? 6 : this.pointedDirection.ordinal() + 1) % 6];
            if (!this.isValidOrientation(this.pointedDirection)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.pointedDirection = null;
        }
        if (this.pointedDirection != oldOrientation) {
            this.clearCache();
            MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), this.getWorld().field_73011_w.getDimension(), PacketHandler.getPacket(ChassiOrientationPacket.class).setDir(this.pointedDirection).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
            this.refreshRender(true);
        }
    }

    public void setClientOrientation(EnumFacing dir) {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            this.pointedDirection = dir;
        }
    }

    private boolean isValidOrientation(EnumFacing connection) {
        if (connection == null) {
            return false;
        }
        if (this.getRouter().isRoutedExit(connection)) {
            return false;
        }
        DoubleCoordinates pos = CoordinateUtils.add(new DoubleCoordinates(this), connection);
        TileEntity tile = pos.getTileEntity((IBlockAccess)this.getWorld());
        if (tile == null) {
            return false;
        }
        if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
            return false;
        }
        return MainProxy.checkPipesConnections(this.container, tile, connection);
    }

    public IInventory getModuleInventory() {
        return this._moduleInventory;
    }

    public ModuleUpgradeManager getModuleUpgradeManager(int slot) {
        return this._upgradeManagers[slot];
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_TEXTURE;
    }

    @Override
    public Textures.TextureType getRoutedTexture(EnumFacing connection) {
        if (this.getRouter().isSubPoweredExit(connection)) {
            return Textures.LOGISTICSPIPE_SUBPOWER_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_CHASSI_ROUTED_TEXTURE;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(EnumFacing connection) {
        if (connection.equals((Object)this.pointedDirection)) {
            return Textures.LOGISTICSPIPE_CHASSI_DIRECTION_TEXTURE;
        }
        if (this.isPowerProvider(connection)) {
            return Textures.LOGISTICSPIPE_POWERED_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_CHASSI_NOTROUTED_TEXTURE;
    }

    @Override
    public void onNeighborBlockChange_Logistics() {
        if (!this.isValidOrientation(this.pointedDirection) && MainProxy.isServer((IBlockAccess)this.getWorld())) {
            this.nextOrientation();
        }
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
        this.switchOrientationOnTick = true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        try {
            super.readFromNBT(nbttagcompound);
            this._moduleInventory.readFromNBT(nbttagcompound, "chassi");
            this.InventoryChanged(this._moduleInventory);
            this._module.readFromNBT(nbttagcompound);
            int tmp = nbttagcompound.func_74762_e("Orientation");
            this.pointedDirection = tmp == -1 ? null : EnumFacingUtil.getOrientation(tmp % 6);
            this.switchOrientationOnTick = this.pointedDirection == null;
            for (int i = 0; i < this.getChassiSize(); ++i) {
                this._upgradeManagers[i].readFromNBT(nbttagcompound, Integer.toString(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this._moduleInventory.writeToNBT(nbttagcompound, "chassi");
        this._module.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Orientation", this.pointedDirection == null ? -1 : this.pointedDirection.ordinal());
        for (int i = 0; i < this.getChassiSize(); ++i) {
            this._upgradeManagers[i].writeToNBT(nbttagcompound, Integer.toString(i));
        }
    }

    @Override
    public void onAllowedRemoval() {
        this._moduleInventory.removeListener(this);
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            int i;
            for (i = 0; i < this.getChassiSize(); ++i) {
                LogisticsModule x = this._module.getSubModule(i);
                if (!(x instanceof ILegacyActiveModule)) continue;
                ILegacyActiveModule y = (ILegacyActiveModule)((Object)x);
                y.onBlockRemoval();
            }
            for (i = 0; i < this._moduleInventory.func_70302_i_(); ++i) {
                ItemIdentifierStack ms = this._moduleInventory.getIDStackInSlot(i);
                if (ms == null) continue;
                ItemStack s = ms.makeNormalStack();
                ItemModuleInformationManager.saveInformation(s, this.getLogisticsModule().getSubModule(i));
                this._moduleInventory.func_70299_a(i, s);
            }
            this._moduleInventory.dropContents(this.getWorld(), this.getX(), this.getY(), this.getZ());
            for (i = 0; i < this.getChassiSize(); ++i) {
                this.getModuleUpgradeManager(i).dropUpgrades();
            }
        }
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (info instanceof ChassiTargetInformation) {
                ChassiTargetInformation target = (ChassiTargetInformation)info;
                LogisticsModule module = this._module.getSubModule(target.moduleSlot);
                if (module instanceof IRequireReliableTransport) {
                    ((IRequireReliableTransport)((Object)module)).itemArrived(item, info);
                }
            } else if (LogisticsPipes.isDEBUG() && info != null) {
                System.out.println(item);
                new RuntimeException("[ItemArrived] Information weren't ment for a chassi pipe").printStackTrace();
            }
        }
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (info instanceof ChassiTargetInformation) {
                ChassiTargetInformation target = (ChassiTargetInformation)info;
                LogisticsModule module = this._module.getSubModule(target.moduleSlot);
                if (module instanceof IRequireReliableTransport) {
                    ((IRequireReliableTransport)((Object)module)).itemLost(item, info);
                }
            } else if (LogisticsPipes.isDEBUG()) {
                System.out.println(item);
                new RuntimeException("[ItemLost] Information weren't ment for a chassi pipe").printStackTrace();
            }
        }
    }

    @Override
    public int addToBuffer(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (info instanceof ChassiTargetInformation) {
                ChassiTargetInformation target = (ChassiTargetInformation)info;
                LogisticsModule module = this._module.getSubModule(target.moduleSlot);
                if (module instanceof IBufferItems) {
                    return ((IBufferItems)((Object)module)).addToBuffer(item, info);
                }
            } else if (LogisticsPipes.isDEBUG()) {
                System.out.println(item);
                new RuntimeException("[AddToBuffer] Information weren't ment for a chassi pipe").printStackTrace();
            }
        }
        return item.getStackSize();
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        boolean reInitGui = false;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) {
                if (!this._module.hasModule(i)) continue;
                this._module.removeModule(i);
                reInitGui = true;
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemModule)) continue;
            LogisticsModule current = this._module.getModule(i);
            LogisticsModule next = ((ItemModule)stack.func_77973_b()).getModuleForItem(stack, this._module.getModule(i), this, this);
            next.registerPosition(LogisticsModule.ModulePositionType.SLOT, i);
            next.registerCCEventQueuer(this);
            if (current != next) {
                this._module.installModule(i, next);
                if (!MainProxy.isClient()) {
                    ItemModuleInformationManager.readInformation(stack, next);
                }
            }
            inventory.func_70299_a(i, stack);
        }
        if (reInitGui && MainProxy.isClient((IBlockAccess)this.getWorld()) && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiChassiPipe) {
            FMLClientHandler.instance().getClient().field_71462_r.func_73866_w_();
        }
        if (MainProxy.isServer() && !this.localModeWatchers.isEmpty()) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ChassiePipeModuleContent.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._moduleInventory)).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void ignoreDisableUpdateEntity() {
        if (this.switchOrientationOnTick) {
            this.switchOrientationOnTick = false;
            if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
                this.nextOrientation();
            }
        }
        if (!this.init) {
            this.init = true;
            if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestChassiOrientationPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
            }
        }
    }

    public abstract int getChassiSize();

    @Override
    public final LogisticsModule getLogisticsModule() {
        return this._module;
    }

    @Override
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new ChassiTransportLayer(this);
        }
        return this._transportLayer;
    }

    private boolean tryInsertingModule(EntityPlayer entityplayer) {
        for (int i = 0; i < this._moduleInventory.func_70302_i_(); ++i) {
            ItemStack item = this._moduleInventory.func_70301_a(i);
            if (!item.func_190926_b()) continue;
            this._moduleInventory.func_70299_a(i, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77979_a(1));
            this.InventoryChanged(this._moduleInventory);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        if (entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
            return false;
        }
        if (entityplayer.func_70093_af() && SimpleServiceLocator.configToolHandler.canWrench(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), this.container)) {
            if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
                if (settings == null || settings.openGui) {
                    ((PipeLogisticsChassi)this.container.pipe).nextOrientation();
                } else {
                    entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            SimpleServiceLocator.configToolHandler.wrenchUsed(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), this.container);
            return true;
        }
        if (!entityplayer.func_70093_af() && entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemModule) {
            if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
                if (settings == null || settings.openGui) {
                    return this.tryInsertingModule(entityplayer);
                }
                entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this.isEnabled()) {
            return;
        }
        for (IFilter filter : filters) {
            if (filter.isBlocked() != filter.isFilteredItem(tree.getRequestType()) && !filter.blockProvider()) continue;
            return;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            LogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            ILegacyActiveModule y = (ILegacyActiveModule)((Object)x);
            y.canProvide(tree, root, filters);
        }
    }

    @Override
    public LogisticsOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        if (!this.isEnabled()) {
            return null;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILegacyActiveModule y;
            LogisticsOrder result;
            LogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule) || (result = (y = (ILegacyActiveModule)((Object)x)).fullFill(promise, destination, info)) == null) continue;
            this.spawnParticle(Particles.WhiteParticle, 2);
            return result;
        }
        return null;
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> list, List<IFilter> filter) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            LogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            ILegacyActiveModule y = (ILegacyActiveModule)((Object)x);
            y.getAllItems(list, filter);
        }
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.hud;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
        this.hud.stopWatching();
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ChassiePipeModuleContent.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._moduleInventory)).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SendQueueContent.class).setIdentList(ItemIdentifierStack.getListSendQueue(this._sendQueue)).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    public void handleModuleItemIdentifierList(Collection<ItemIdentifierStack> _allItems) {
        this._moduleInventory.handleItemIdentifierList(_allItems);
    }

    public void handleContentItemIdentifierList(Collection<ItemIdentifierStack> _allItems) {
        this._moduleInventory.handleItemIdentifierList(_allItems);
    }

    @Override
    public int sendQueueChanged(boolean force) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (Configs.MULTI_THREAD_NUMBER > 0 && !force) {
                HudUpdateTick.add(this.getRouter());
            } else if (this.localModeWatchers != null && this.localModeWatchers.size() > 0) {
                LinkedList<ItemIdentifierStack> items = ItemIdentifierStack.getListSendQueue(this._sendQueue);
                MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SendQueueContent.class).setIdentList(items).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
                return items.size();
            }
        }
        return 0;
    }

    @Override
    public void handleSendQueueItemIdentifierList(Collection<ItemIdentifierStack> _allItems) {
        this.displayList.clear();
        this.displayList.addAll(_allItems);
    }

    public ChassiModule getModules() {
        return this._module;
    }

    @Override
    public void setTile(TileEntity tile) {
        super.setTile(tile);
        for (int i = 0; i < this._moduleInventory.func_70302_i_(); ++i) {
            LogisticsModule current = this._module.getModule(i);
            if (current == null) continue;
            current.registerPosition(LogisticsModule.ModulePositionType.SLOT, i);
        }
    }

    @Override
    public int getSourceID() {
        return this.getRouterId();
    }

    @Override
    public Set<ItemIdentifier> getSpecificInterests() {
        LogisticsModule module;
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        if (this.getPointedItemHandler() == null) {
            return l1;
        }
        for (int moduleIndex = 0; moduleIndex < this.getChassiSize(); ++moduleIndex) {
            IInventoryUtil inv;
            module = this._module.getSubModule(moduleIndex);
            if (module == null || !module.interestedInAttachedInventory() || (inv = this.getSneakyInventory(module.getSlot(), module.getPositionInt())) == null) continue;
            Set<ItemIdentifier> items = inv.getItems();
            l1.addAll(items);
            l1.addAll(items.stream().map(ItemIdentifier::getIgnoringNBT).collect(Collectors.toList()));
            boolean modulesInterestedInUndamged = false;
            for (int i = 0; i < this.getChassiSize(); ++i) {
                if (!this._module.getSubModule(moduleIndex).interestedInUndamagedID()) continue;
                modulesInterestedInUndamged = true;
                break;
            }
            if (!modulesInterestedInUndamged) break;
            l1.addAll(items.stream().map(ItemIdentifier::getUndamaged).collect(Collectors.toList()));
            break;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            Collection<ItemIdentifier> current;
            module = this._module.getSubModule(i);
            if (module == null || (current = module.getSpecificInterests()) == null) continue;
            l1.addAll(current);
        }
        return l1;
    }

    @Override
    public boolean hasGenericInterests() {
        if (this.getPointedItemHandler() == null) {
            return false;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            LogisticsModule x = this._module.getSubModule(i);
            if (x == null || !x.hasGenericInterests()) continue;
            return true;
        }
        return false;
    }

    @CCCommand(description="Returns the LogisticsModule for the given slot number starting by 1")
    public LogisticsModule getModuleInSlot(Double i) {
        return this._module.getSubModule((int)(i - 1.0));
    }

    @CCCommand(description="Returns the size of this Chassie pipe")
    public Integer getChassieSize() {
        return this.getChassiSize();
    }

    public abstract ResourceLocation getChassiGUITexture();

    @Override
    public void registerExtras(IPromise promise) {
        if (!(promise instanceof LogisticsPromise)) {
            throw new UnsupportedOperationException("Extra has to be an item for a chassis pipe");
        }
        ItemIdentifierStack stack = new ItemIdentifierStack(((LogisticsPromise)promise).item, ((LogisticsPromise)promise).numberOfItems);
        this._extras.add(new LogisticsItemOrder(new DictResource(stack, null), null, IOrderInfoProvider.ResourceType.EXTRA, null));
    }

    @Override
    public ICraftingTemplate addCrafting(IResource toCraft) {
        for (int i = 0; i < this.getChassiSize(); ++i) {
            LogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ICraftItems) || !((ICraftItems)((Object)x)).canCraft(toCraft)) continue;
            return ((ICraftItems)((Object)x)).addCrafting(toCraft);
        }
        return null;
    }

    @Override
    public List<ItemIdentifierStack> getCraftedItems() {
        LinkedList<ItemIdentifierStack> craftables = null;
        for (int i = 0; i < this.getChassiSize(); ++i) {
            LogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ICraftItems)) continue;
            if (craftables == null) {
                craftables = new LinkedList<ItemIdentifierStack>();
            }
            craftables.addAll(((ICraftItems)((Object)x)).getCraftedItems());
        }
        return craftables;
    }

    @Override
    public boolean canCraft(IResource toCraft) {
        for (int i = 0; i < this.getChassiSize(); ++i) {
            LogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ICraftItems) || !((ICraftItems)((Object)x)).canCraft(toCraft)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ISlotUpgradeManager getUpgradeManager(LogisticsModule.ModulePositionType slot, int positionInt) {
        if (slot != LogisticsModule.ModulePositionType.SLOT || positionInt >= this._upgradeManagers.length) {
            if (LogisticsPipes.isDEBUG()) {
                new UnsupportedOperationException("Position info arn't for a chassi pipe. (" + (Object)((Object)slot) + "/" + positionInt + ")").printStackTrace();
            }
            return super.getUpgradeManager(slot, positionInt);
        }
        return this._upgradeManagers[positionInt];
    }

    @Override
    public int getTodo() {
        return 0;
    }

    public static class ChassiTargetInformation
    implements IAdditionalTargetInformation {
        private final int moduleSlot;

        public ChassiTargetInformation(int slot) {
            this.moduleSlot = slot;
        }

        public int getModuleSlot() {
            return this.moduleSlot;
        }
    }
}

