/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debug;

import java.util.List;
import logisticspipes.network.IReadListObject;
import logisticspipes.network.IWriteListObject;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.debug.LogWindow;
import logisticspipes.pipes.basic.debug.StatusEntry;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class UpdateStatusEntries
extends ModernPacket {
    public int windowID;
    public List<StatusEntry> status;

    public UpdateStatusEntries(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.windowID = input.readInt();
        this.status = input.readArrayList(new IReadListObject<StatusEntry>(){

            @Override
            public StatusEntry readObject(LPDataInput input) {
                StatusEntry status = new StatusEntry();
                status.name = input.readUTF();
                if (input.readBoolean()) {
                    status.subEntry = input.readArrayList(this);
                }
                return status;
            }
        });
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogWindow.getWindow(this.windowID).updateStatus(this.status);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.windowID);
        output.writeCollection(this.status, new IWriteListObject<StatusEntry>(){

            @Override
            public void writeObject(LPDataOutput output, StatusEntry entry) {
                output.writeUTF(entry.name);
                output.writeBoolean(entry.subEntry != null);
                if (entry.subEntry != null) {
                    output.writeCollection(entry.subEntry, this);
                }
            }
        });
    }

    @Override
    public ModernPacket template() {
        return new UpdateStatusEntries(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public int getWindowID() {
        return this.windowID;
    }

    public UpdateStatusEntries setWindowID(int windowID) {
        this.windowID = windowID;
        return this;
    }

    public List<StatusEntry> getStatus() {
        return this.status;
    }

    public UpdateStatusEntries setStatus(List<StatusEntry> status) {
        this.status = status;
        return this;
    }
}

