/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractguis;

import logisticspipes.LogisticsPipes;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class CoordinatesGuiProvider
extends GuiProvider {
    private int posX;
    private int posY;
    private int posZ;

    public CoordinatesGuiProvider(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.posX);
        output.writeInt(this.posY);
        output.writeInt(this.posZ);
    }

    @Override
    public void readData(LPDataInput input) {
        this.posX = input.readInt();
        this.posY = input.readInt();
        this.posZ = input.readInt();
    }

    public CoordinatesGuiProvider setTilePos(TileEntity tile) {
        this.setPosX(tile.func_174877_v().func_177958_n());
        this.setPosY(tile.func_174877_v().func_177956_o());
        this.setPosZ(tile.func_174877_v().func_177952_p());
        return this;
    }

    public <T> T getTile(World world, Class<T> clazz) {
        if (world == null) {
            return null;
        }
        if (world.func_175623_d(new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()))) {
            if (LogisticsPipes.isDEBUG()) {
                LogisticsPipes.log.fatal(this.toString());
                new RuntimeException("Couldn't find " + clazz.getName()).printStackTrace();
            }
            return null;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
        if (tile != null) {
            if (!clazz.isAssignableFrom(tile.getClass())) {
                if (LogisticsPipes.isDEBUG()) {
                    LogisticsPipes.log.fatal(this.toString());
                    new RuntimeException("Couldn't find " + clazz.getName() + ", found " + tile.getClass()).printStackTrace();
                }
                return null;
            }
        } else if (LogisticsPipes.isDEBUG()) {
            LogisticsPipes.log.fatal(this.toString());
            new RuntimeException("Couldn't find " + clazz.getName()).printStackTrace();
        }
        return (T)tile;
    }

    public LogisticsTileGenericPipe getPipe(World world) {
        return this.getTile(world, LogisticsTileGenericPipe.class);
    }

    public String toString() {
        return "CoordinatesGuiProvider(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ")";
    }

    public int getPosX() {
        return this.posX;
    }

    public CoordinatesGuiProvider setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public CoordinatesGuiProvider setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public CoordinatesGuiProvider setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }
}

