/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logistics;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.logistics.ILogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.PipeItemsProviderLogistics;
import logisticspipes.pipes.PipeItemsRequestLogistics;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;

public class LogisticsManager
implements ILogisticsManager {
    @Override
    public Triplet<Integer, SinkReply, List<IFilter>> hasDestination(ItemIdentifier stack, boolean allowDefault, int sourceID, List<Integer> routerIDsToExclude) {
        IRouter sourceRouter = SimpleServiceLocator.routerManager.getRouter(sourceID);
        if (sourceRouter == null) {
            return null;
        }
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(stack);
        ArrayList<ExitRoute> validDestinations = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            List<ExitRoute> exits = sourceRouter.getDistanceTo(r);
            if (exits != null) {
                validDestinations.addAll(exits.stream().filter(e -> e.containsFlag(PipeRoutingConnectionType.canRouteTo)).collect(Collectors.toList()));
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validDestinations);
        Triplet<Integer, SinkReply, List<IFilter>> search = this.getBestReply(stack, sourceRouter, validDestinations, true, routerIDsToExclude, null, allowDefault);
        if (search.getValue2() == null) {
            return null;
        }
        if (!allowDefault && ((SinkReply)search.getValue2()).isDefault) {
            return null;
        }
        return search;
    }

    @Override
    public Triplet<Integer, SinkReply, List<IFilter>> hasDestinationWithMinPriority(ItemIdentifier stack, int sourceRouter, boolean excludeSource, SinkReply.FixedPriority priority) {
        IRouter router = SimpleServiceLocator.routerManager.getRouter(sourceRouter);
        if (router == null) {
            return null;
        }
        Triplet<Integer, SinkReply, List<IFilter>> search = this.getBestReply(stack, router, router.getIRoutersByCost(), excludeSource, new ArrayList<Integer>(), null, true);
        if (search.getValue2() == null) {
            return null;
        }
        if (((SinkReply)search.getValue2()).fixedPriority.ordinal() < priority.ordinal()) {
            return null;
        }
        return search;
    }

    private Triplet<Integer, SinkReply, List<IFilter>> getBestReply(ItemIdentifier stack, @Nonnull IRouter sourceRouter, @Nonnull List<ExitRoute> validDestinations, boolean excludeSource, List<Integer> jamList, Triplet<Integer, SinkReply, List<IFilter>> result, boolean allowDefault) {
        if (result == null) {
            result = new Triplet<Object, Object, Object>(null, null, null);
        }
        block0: for (ExitRoute candidateRouter : validDestinations) {
            LinkedList list;
            if (excludeSource && candidateRouter.destination.getId().equals(sourceRouter.getId()) || jamList.contains(candidateRouter.destination.getSimpleID()) || !candidateRouter.containsFlag(PipeRoutingConnectionType.canRouteTo)) continue;
            for (IFilter filter : candidateRouter.filters) {
                if (!filter.blockRouting() && filter.isBlocked() != filter.isFilteredItem(stack)) continue;
                continue block0;
            }
            SinkReply reply = LogisticsManager.canSink(candidateRouter.destination, sourceRouter, excludeSource, stack, (SinkReply)result.getValue2(), false, allowDefault);
            if (reply == null) continue;
            if (result.getValue1() == null) {
                result.setValue1(candidateRouter.destination.getSimpleID());
                result.setValue2(reply);
                list = new LinkedList();
                result.setValue3(list);
                continue;
            }
            if (reply.fixedPriority.ordinal() > ((SinkReply)result.getValue2()).fixedPriority.ordinal()) {
                result.setValue1(candidateRouter.destination.getSimpleID());
                result.setValue2(reply);
                list = new LinkedList();
                result.setValue3(list);
                continue;
            }
            if (reply.fixedPriority != ((SinkReply)result.getValue2()).fixedPriority || reply.customPriority <= ((SinkReply)result.getValue2()).customPriority) continue;
            result.setValue1(candidateRouter.destination.getSimpleID());
            result.setValue2(reply);
            list = new LinkedList();
            result.setValue3(list);
        }
        if (result.getValue1() != null) {
            CoreRoutedPipe pipe = SimpleServiceLocator.routerManager.getRouterUnsafe((Integer)result.getValue1(), false).getPipe();
            pipe.useEnergy(((SinkReply)result.getValue2()).energyUse);
            pipe.spawnParticle(Particles.BlueParticle, 10);
        }
        return result;
    }

    public static SinkReply canSink(@Nonnull IRouter destination, IRouter sourceRouter, boolean excludeSource, ItemIdentifier stack, SinkReply result, boolean activeRequest, boolean allowDefault) {
        LogisticsModule module = destination.getLogisticsModule();
        CoreRoutedPipe crp = destination.getPipe();
        if (module == null) {
            return null;
        }
        if (!module.recievePassive() && !activeRequest) {
            return null;
        }
        if (crp == null || !crp.isEnabled()) {
            return null;
        }
        if (excludeSource && sourceRouter != null && destination.getPipe().sharesInterestWith(sourceRouter.getPipe())) {
            return null;
        }
        SinkReply reply = result == null ? module.sinksItem(stack, -1, 0, allowDefault, true, true) : module.sinksItem(stack, result.fixedPriority.ordinal(), result.customPriority, allowDefault, true, true);
        if (result != null && result.maxNumberOfItems < 0) {
            return null;
        }
        return reply;
    }

    @Override
    public IRoutedItem assignDestinationFor(IRoutedItem item, int sourceRouterID, boolean excludeSource) {
        IRouter sourceRouter = SimpleServiceLocator.routerManager.getRouterUnsafe(sourceRouterID, false);
        if (sourceRouter == null) {
            return item;
        }
        item.clearDestination();
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(item.getItemIdentifierStack().getItem());
        ArrayList<ExitRoute> validDestinations = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            List<ExitRoute> exits = sourceRouter.getDistanceTo(r);
            if (exits != null) {
                validDestinations.addAll(exits.stream().filter(e -> e.containsFlag(PipeRoutingConnectionType.canRouteTo)).collect(Collectors.toList()));
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validDestinations);
        if (item.getItemIdentifierStack() != null && item.getItemIdentifierStack().makeNormalStack().func_77973_b() instanceof LogisticsFluidContainer) {
            Pair<Integer, Integer> bestReply = SimpleServiceLocator.logisticsFluidManager.getBestReply(SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(item.getItemIdentifierStack()), sourceRouter, item.getJamList());
            if (bestReply.getValue1() != null && bestReply.getValue1() != 0) {
                item.setDestination(bestReply.getValue1());
            }
            return item;
        }
        Triplet<Integer, SinkReply, List<IFilter>> bestReply = this.getBestReply(item.getItemIdentifierStack().getItem(), sourceRouter, validDestinations, excludeSource, item.getJamList(), null, true);
        if (bestReply.getValue1() != null && (Integer)bestReply.getValue1() != 0) {
            item.setDestination((Integer)bestReply.getValue1());
            if (((SinkReply)bestReply.getValue2()).isPassive) {
                if (((SinkReply)bestReply.getValue2()).isDefault) {
                    item.setTransportMode(IRoutedItem.TransportMode.Default);
                } else {
                    item.setTransportMode(IRoutedItem.TransportMode.Passive);
                }
            } else {
                item.setTransportMode(IRoutedItem.TransportMode.Active);
            }
            item.setAdditionalTargetInformation(((SinkReply)bestReply.getValue2()).addInfo);
        }
        return item;
    }

    @Override
    public String getBetterRouterName(IRouter r) {
        PipeItemsCraftingLogistics pipe;
        if (r.getPipe() instanceof PipeItemsCraftingLogistics && (pipe = (PipeItemsCraftingLogistics)r.getPipe()).getCraftedItems() != null) {
            List<ItemIdentifierStack> items = pipe.getCraftedItems();
            if (items.size() == 1) {
                return "Crafter<" + items.get(0).getFriendlyName() + ">";
            }
            return "Crafter< MULTIPLE ITEMS >";
        }
        if (r.getPipe() instanceof PipeItemsProviderLogistics) {
            return "Provider";
        }
        if (r.getPipe() instanceof PipeLogisticsChassi) {
            return "Chassis";
        }
        if (r.getPipe() instanceof PipeItemsRequestLogistics) {
            return "Request";
        }
        return r.getId().toString();
    }

    public HashMap<ItemIdentifier, Integer> getAvailableItems(List<ExitRoute> validDestinations) {
        ArrayList items = new ArrayList(ServerRouter.getBiggestSimpleID());
        for (int i = 0; i < ServerRouter.getBiggestSimpleID(); ++i) {
            items.add(new HashMap());
        }
        BitSet used = new BitSet(ServerRouter.getBiggestSimpleID());
        block1: for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(r.destination.getPipe() instanceof IProvideItems)) continue;
            for (IFilter filter : r.filters) {
                if (!filter.blockProvider()) continue;
                continue block1;
            }
            IProvideItems iProvideItems = (IProvideItems)((Object)r.destination.getPipe());
            iProvideItems.getAllItems((Map)items.get(r.destination.getSimpleID()), r.filters);
            used.set(r.destination.getSimpleID(), true);
        }
        HashMap<ItemIdentifier, Integer> allAvailableItems = new HashMap<ItemIdentifier, Integer>();
        for (Map map : items) {
            for (Map.Entry item : map.entrySet()) {
                Integer currentItem = allAvailableItems.get(item.getKey());
                if (currentItem == null) {
                    allAvailableItems.put((ItemIdentifier)item.getKey(), (Integer)item.getValue());
                    continue;
                }
                allAvailableItems.put((ItemIdentifier)item.getKey(), currentItem + (Integer)item.getValue());
            }
        }
        return allAvailableItems;
    }

    @Override
    public LinkedList<ItemIdentifier> getCraftableItems(List<ExitRoute> validDestinations) {
        LinkedList<ItemIdentifier> craftableItems = new LinkedList<ItemIdentifier>();
        BitSet used = new BitSet(ServerRouter.getBiggestSimpleID());
        block0: for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(r.destination.getSimpleID()) || !(r.destination.getPipe() instanceof ICraftItems)) continue;
            for (IFilter filter : r.filters) {
                if (!filter.blockCrafting()) continue;
                continue block0;
            }
            ICraftItems crafter = (ICraftItems)((Object)r.destination.getPipe());
            List<ItemIdentifierStack> craftedItems = crafter.getCraftedItems();
            if (craftedItems != null) {
                block2: for (ItemIdentifierStack craftedItem : craftedItems) {
                    if (craftedItem == null || craftableItems.contains(craftedItem.getItem())) continue;
                    for (IFilter filter : r.filters) {
                        if (filter.isBlocked() != filter.isFilteredItem(craftedItem.getItem())) continue;
                        continue block2;
                    }
                    craftableItems.add(craftedItem.getItem());
                }
            }
            used.set(r.destination.getSimpleID(), true);
        }
        return craftableItems;
    }

    @Override
    public int getAmountFor(ItemIdentifier itemType, List<ExitRoute> validDestinations) {
        ArrayList items = new ArrayList(ServerRouter.getBiggestSimpleID());
        for (int i = 0; i < ServerRouter.getBiggestSimpleID(); ++i) {
            items.add(new HashMap());
        }
        BitSet used = new BitSet(ServerRouter.getBiggestSimpleID());
        block1: for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(r.destination.getPipe() instanceof IProvideItems)) continue;
            for (IFilter filter : r.filters) {
                if (!filter.blockProvider()) continue;
                continue block1;
            }
            IProvideItems iProvideItems = (IProvideItems)((Object)r.destination.getPipe());
            iProvideItems.getAllItems((Map)items.get(r.destination.getSimpleID()), r.filters);
            used.set(r.destination.getSimpleID(), true);
        }
        int amount = 0;
        for (Map map : items) {
            for (Map.Entry item : map.entrySet()) {
                if (!((ItemIdentifier)item.getKey()).equals(itemType)) continue;
                amount += ((Integer)item.getValue()).intValue();
            }
        }
        return amount;
    }
}

