/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import logisticspipes.LPItems;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IItemAdvancedExistance;
import logisticspipes.modules.ModuleQuickSort;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.PlayerConfigToClientPacket;
import logisticspipes.network.packets.chassis.ChestGuiClosed;
import logisticspipes.network.packets.chassis.ChestGuiOpened;
import logisticspipes.network.packets.gui.GuiReopenPacket;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsGuiOverrenderer;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.pathfinder.changedetection.TEControl;
import logisticspipes.ticks.LPTickHandler;
import logisticspipes.ticks.VersionChecker;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.QuickSortChestMarkerStorage;
import logisticspipes.utils.string.ChatColor;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.config.PlayerConfiguration;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class LogisticsEventListener {
    public static final WeakHashMap<EntityPlayer, List<WeakReference<ModuleQuickSort>>> chestQuickSortConnection = new WeakHashMap();
    public static Map<ChunkPos, PlayerCollectionList> watcherList = new ConcurrentHashMap<ChunkPos, PlayerCollectionList>();
    public static HashMap<Integer, Long> WorldLoadTime = new HashMap();
    private static final AtomicReference<Object> guiPos = new AtomicReference();

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event != null && event.getEntity() instanceof EntityItem && event.getEntity().field_70170_p != null && !event.getEntity().field_70170_p.field_72995_K) {
            ItemStack stack = ((EntityItem)event.getEntity()).func_92059_d();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IItemAdvancedExistance && !((IItemAdvancedExistance)stack.func_77973_b()).canExistInWorld(stack)) {
                event.setCanceled(true);
            }
            if (stack.func_77942_o()) {
                for (String key : stack.func_77978_p().func_150296_c()) {
                    if (!key.startsWith("logisticspipes:routingdata")) continue;
                    ItemRoutingInformation info = ItemRoutingInformation.restoreFromNBT(stack.func_77978_p().func_74775_l(key));
                    info.setItemTimedout();
                    ((EntityItem)event.getEntity()).func_92058_a(info.getItem().getItem().makeNormalStack(stack.func_190916_E()));
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        TileEntity tile;
        if (MainProxy.isServer((IBlockAccess)event.getEntityPlayer().field_70170_p) && (tile = event.getEntityPlayer().field_70170_p.func_175625_s(event.getPos())) instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe) {
            if (!((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).canBeDestroyedByPlayer(event.getEntityPlayer())) {
                event.setCanceled(true);
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                ((LogisticsTileGenericPipe)tile).scheduleNeighborChange();
                World world = event.getEntityPlayer().field_70170_p;
                BlockPos pos = tile.func_174877_v();
                IBlockState state = world.func_180495_p(pos);
                world.markAndNotifyBlock(tile.func_174877_v(), world.func_175726_f(pos), state, state, 2);
                ((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).delayTo = System.currentTimeMillis() + 200L;
                ((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).repeatFor = 10;
            } else {
                ((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).setDestroyByPlayer();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickBlock(PlayerInteractEvent.RightClickBlock event) {
        List list;
        WorldCoordinatesWrapper worldCoordinates;
        TileEntity tileEntity;
        if (MainProxy.isServer((IBlockAccess)event.getEntityPlayer().field_70170_p) && ((tileEntity = (worldCoordinates = new WorldCoordinatesWrapper(event.getEntityPlayer().field_70170_p, event.getPos())).getTileEntity()) instanceof TileEntityChest || SimpleServiceLocator.ironChestProxy.isIronChest(tileEntity)) && !(list = worldCoordinates.allNeighborTileEntities().filter(NeighborTileEntity::isLogisticsPipe).filter(adjacent -> ((LogisticsTileGenericPipe)adjacent.getTileEntity()).pipe instanceof PipeLogisticsChassi).filter(adjacent -> ((PipeLogisticsChassi)((LogisticsTileGenericPipe)adjacent.getTileEntity()).pipe).getPointedOrientation() == adjacent.getOurDirection()).map(adjacent -> (PipeLogisticsChassi)((LogisticsTileGenericPipe)adjacent.getTileEntity()).pipe).flatMap(pipeLogisticsChassi -> Arrays.stream(pipeLogisticsChassi.getModules().getModules())).filter(logisticsModule -> logisticsModule instanceof ModuleQuickSort).map(logisticsModule -> new WeakReference<ModuleQuickSort>((ModuleQuickSort)logisticsModule)).collect(Collectors.toList())).isEmpty()) {
            chestQuickSortConnection.put(event.getEntityPlayer(), list);
        }
    }

    @SubscribeEvent
    public void WorldLoad(WorldEvent.Load event) {
        int dim;
        if (MainProxy.isServer((IBlockAccess)event.getWorld()) && !WorldLoadTime.containsKey(dim = event.getWorld().field_73011_w.getDimension())) {
            WorldLoadTime.put(dim, System.currentTimeMillis());
        }
        if (MainProxy.isClient((IBlockAccess)event.getWorld())) {
            SimpleServiceLocator.routerManager.clearClientRouters();
            LogisticsHUDRenderer.instance().clear();
        }
    }

    @SubscribeEvent
    public void WorldUnload(WorldEvent.Unload event) {
        if (MainProxy.isServer((IBlockAccess)event.getWorld())) {
            int dim = event.getWorld().field_73011_w.getDimension();
            SimpleServiceLocator.routerManager.dimensionUnloaded(dim);
        }
    }

    @SubscribeEvent
    public void watchChunk(ChunkWatchEvent.Watch event) {
        ChunkPos pos = event.getChunkInstance().func_76632_l();
        if (!watcherList.containsKey(pos)) {
            watcherList.put(pos, new PlayerCollectionList());
        }
        watcherList.get(pos).add((EntityPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public void unWatchChunk(ChunkWatchEvent.UnWatch event) {
        ChunkPos pos = event.getChunkInstance().func_76632_l();
        if (watcherList.containsKey(pos)) {
            watcherList.get(pos).remove((EntityPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (MainProxy.isServer((IBlockAccess)event.player.field_70170_p)) {
            SimpleServiceLocator.securityStationManager.sendClientAuthorizationList(event.player);
        }
        SimpleServiceLocator.serverBufferHandler.clear(event.player);
        PlayerConfiguration config = LogisticsPipes.getServerConfigManager().getPlayerConfiguration(PlayerIdentifier.get(event.player));
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(PlayerConfigToClientPacket.class).setConfig(config), event.player);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        SimpleServiceLocator.serverBufferHandler.clear(event.player);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpen(GuiOpenEvent event) {
        if (!LogisticsEventListener.getGuiPos().isEmpty()) {
            if (event.getGui() == null) {
                GuiEntry part = LogisticsEventListener.getGuiPos().peek();
                if (part.isActive()) {
                    part = LogisticsEventListener.getGuiPos().poll();
                    MainProxy.sendPacketToServer(PacketHandler.getPacket(GuiReopenPacket.class).setGuiID(part.getGuiID()).setPosX(part.getXCoord()).setPosY(part.getYCoord()).setPosZ(part.getZCoord()));
                    LogisticsGuiOverrenderer.getInstance().setOverlaySlotActive(false);
                }
            } else {
                GuiEntry part = LogisticsEventListener.getGuiPos().peek();
                part.setActive(true);
            }
        }
        if (event.getGui() == null) {
            LogisticsGuiOverrenderer.getInstance().setOverlaySlotActive(false);
        }
        if (event.getGui() instanceof GuiChest || SimpleServiceLocator.ironChestProxy != null && SimpleServiceLocator.ironChestProxy.isChestGui(event.getGui())) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ChestGuiOpened.class));
        } else {
            QuickSortChestMarkerStorage.getInstance().disable();
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ChestGuiClosed.class));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addGuiToReopen(int xCoord, int yCoord, int zCoord, int guiID) {
        LogisticsEventListener.getGuiPos().add(new GuiEntry(xCoord, yCoord, zCoord, guiID, false));
    }

    @SubscribeEvent
    public void clientLoggedIn(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        SimpleServiceLocator.clientBufferHandler.clear();
        if (Configs.CHECK_FOR_UPDATES) {
            LogisticsPipes.singleThreadExecutor.execute(() -> {
                EntityPlayerSP playerEntity;
                int times = 0;
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                } while ((playerEntity = FMLClientHandler.instance().getClientPlayerEntity()) == null && ++times <= 10);
                if (times > 10) {
                    return;
                }
                VersionChecker checker = LogisticsPipes.versionChecker;
                String versionMessage = checker.getVersionCheckerStatus();
                if (checker.isVersionCheckDone() && checker.getVersionInfo().isNewVersionAvailable() && !checker.getVersionInfo().isImcMessageSent()) {
                    playerEntity.func_145747_a((ITextComponent)new TextComponentString(versionMessage));
                    playerEntity.func_145747_a((ITextComponent)new TextComponentString("Use \"/logisticspipes changelog\" to see a changelog."));
                } else if (!checker.isVersionCheckDone()) {
                    playerEntity.func_145747_a((ITextComponent)new TextComponentString(versionMessage));
                }
            });
        }
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        TEControl.handleBlockUpdate(event.getWorld(), LPTickHandler.getWorldInfo(event.getWorld()), event.getPos());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemStackToolTip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77942_o()) {
            for (String key : event.getItemStack().func_77978_p().func_150296_c()) {
                if (!key.startsWith("logisticspipes:routingdata")) continue;
                ItemRoutingInformation info = ItemRoutingInformation.restoreFromNBT(event.getItemStack().func_77978_p().func_74775_l(key));
                List list = event.getToolTip();
                list.set(0, (Object)((Object)ChatColor.RED) + "!!! " + (Object)((Object)ChatColor.WHITE) + (String)list.get(0) + (Object)((Object)ChatColor.RED) + " !!!" + (Object)((Object)ChatColor.WHITE));
                list.add(1, StringUtils.translate("itemstackinfo.lprouteditem"));
                list.add(2, StringUtils.translate("itemstackinfo.lproutediteminfo"));
                list.add(3, StringUtils.translate("itemstackinfo.lprouteditemtype") + ": " + info.getItem().toString());
            }
        }
    }

    @SubscribeEvent
    public void onItemCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.player.func_70613_aW() && !event.crafting.func_190926_b() && event.crafting.func_77973_b().getRegistryName().func_110624_b().equals("logisticspipes")) {
            PlayerIdentifier identifier = PlayerIdentifier.get(event.player);
            PlayerConfiguration config = LogisticsPipes.getServerConfigManager().getPlayerConfiguration(identifier);
            if (!config.getHasCraftedLPItem() && !LogisticsPipes.isDEBUG()) {
                ItemStack book = new ItemStack((Item)LPItems.itemGuideBook, 1);
                event.player.func_191521_c(book);
                config.setHasCraftedLPItem(true);
                LogisticsPipes.getServerConfigManager().setPlayerConfiguration(identifier, config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue<GuiEntry> getGuiPos() {
        Serializable value = guiPos.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = guiPos;
            synchronized (atomicReference) {
                value = guiPos.get();
                if (value == null) {
                    LinkedList actualValue = new LinkedList();
                    value = actualValue == null ? guiPos : actualValue;
                    guiPos.set(value);
                }
            }
        }
        return (Queue)((Object)(value == guiPos ? null : value));
    }

    private static class GuiEntry {
        private final int xCoord;
        private final int yCoord;
        private final int zCoord;
        private final int guiID;
        private boolean isActive;

        public GuiEntry(int xCoord, int yCoord, int zCoord, int guiID, boolean isActive) {
            this.xCoord = xCoord;
            this.yCoord = yCoord;
            this.zCoord = zCoord;
            this.guiID = guiID;
            this.isActive = isActive;
        }

        public int getXCoord() {
            return this.xCoord;
        }

        public int getYCoord() {
            return this.yCoord;
        }

        public int getZCoord() {
            return this.zCoord;
        }

        public int getGuiID() {
            return this.guiID;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public GuiEntry setActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }
    }
}

