/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_crop_overrides;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ic2.core.IC2;
import ic2.core.block.crop.Ic2Crops;
import java.io.File;
import java.nio.charset.Charset;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import trinsdar.ic2c_crop_overrides.CropJsonLoader;
import trinsdar.ic2c_crop_overrides.Ic2cCropsConfig;
import trinsdar.ic2c_crop_overrides.JsonMaker;
import trinsdar.ic2c_crop_overrides.crops.CropRedWheat2;

@Mod(modid="ic2c_crop_overrides", name="Ic2c Crop Overrides", version="1.0.0", dependencies="required-after:ic2;required-after:ic2-classic-spmod;after:ic2c_extras", acceptedMinecraftVersions="[1.12.2]")
public class Ic2cCropOverrides {
    public static final String MODID = "ic2c_crop_overrides";
    public static final String NAME = "Ic2c Crop Overrides";
    public static final String VERSION = "1.0.0";
    public static final String DEPENDS = "required-after:ic2;required-after:ic2-classic-spmod;after:ic2c_extras";
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        Ic2Crops.cropRedwheat = new CropRedWheat2();
        Ic2Crops.instance.registerCrop(Ic2Crops.cropRedwheat);
        if (Ic2cCropsConfig.generateExampleJson) {
            JsonMaker.init(event);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (Ic2cCropsConfig.redwheat.changeDrops) {
            Ic2Crops.instance.registerCropDisplayItem(Ic2Crops.cropRedwheat, GameRegistry.makeItemStack((String)Ic2cCropsConfig.redwheat.drop2, (int)Ic2cCropsConfig.redwheat.drop2Meta, (int)1, null));
        }
        CropJsonLoader.load(this.getObject(new File(IC2.configFolder, "overrideCrops.json")));
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    private JsonObject getObject(File file) {
        try {
            JsonElement obj;
            if (file.exists() && (obj = IC2.parser.parse(Files.toString((File)file, (Charset)Charsets.UTF_8))) != null && obj.isJsonObject()) {
                return obj.getAsJsonObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new JsonObject();
    }
}

