/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import io.github.phantamanta44.libnine.util.ImpossibilityRealizedException;
import java.util.function.UnaryOperator;
import net.minecraft.util.EnumFacing;

public enum BlockSide {
    FRONT(f -> f),
    BACK(EnumFacing::func_176734_d),
    UP(f -> EnumFacing.UP),
    LEFT(EnumFacing::func_176746_e),
    DOWN(f -> EnumFacing.DOWN),
    RIGHT(EnumFacing::func_176735_f);

    private final UnaryOperator<EnumFacing> transformer;

    private BlockSide(UnaryOperator<EnumFacing> transformer) {
        this.transformer = transformer;
    }

    public EnumFacing getDirection(EnumFacing front) {
        return (EnumFacing)this.transformer.apply(front);
    }

    public static BlockSide fromDirection(EnumFacing front, EnumFacing face) {
        for (BlockSide side : BlockSide.values()) {
            if (side.getDirection(front) != face) continue;
            return side;
        }
        throw new ImpossibilityRealizedException();
    }
}

