/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.component.reservoir;

import io.github.phantamanta44.libnine.component.reservoir.DelegatedIntReservoir;
import io.github.phantamanta44.libnine.component.reservoir.IIntReservoir;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidReservoir
extends DelegatedIntReservoir
implements IFluidTankProperties {
    private final boolean locked;
    private final Collection<BiConsumer<Fluid, Fluid>> callbacks;
    @Nullable
    private Fluid fluid;

    public FluidReservoir(Fluid fluid, IIntReservoir backing, boolean locked) {
        super(backing);
        this.fluid = fluid;
        this.locked = locked;
        this.callbacks = new ArrayList<BiConsumer<Fluid, Fluid>>();
    }

    public FluidReservoir(Fluid fluid, IIntReservoir backing) {
        super(backing);
        this.fluid = fluid;
        this.locked = true;
        this.callbacks = new ArrayList<BiConsumer<Fluid, Fluid>>();
    }

    public FluidReservoir(IIntReservoir backing) {
        super(backing);
        this.fluid = null;
        this.locked = false;
        this.callbacks = new ArrayList<BiConsumer<Fluid, Fluid>>();
    }

    public boolean hasFluid() {
        return this.fluid != null && this.getQuantity() > 0;
    }

    @Nullable
    public Fluid getFluid() {
        return this.fluid;
    }

    public void setFluid(@Nullable Fluid fluid) {
        if (!Objects.equals(fluid, this.fluid)) {
            if (this.locked) {
                throw new UnsupportedOperationException("Fluid type is locked!");
            }
            Fluid oldFluid = this.fluid;
            this.fluid = fluid;
            for (BiConsumer<Fluid, Fluid> callback : this.callbacks) {
                callback.accept(oldFluid, fluid);
            }
        }
    }

    @Override
    public void setQuantity(int qty) {
        super.setQuantity(qty);
        if (qty == 0 && !this.locked) {
            this.fluid = null;
        }
    }

    @Nullable
    public FluidStack getContents() {
        return this.fluid != null ? new FluidStack(this.fluid, this.getQuantity()) : null;
    }

    public boolean canFill() {
        return true;
    }

    public boolean canDrain() {
        return true;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.canFill() && (this.fluid == null || this.fluid == fluidStack.getFluid());
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.canDrain() && this.fluid != null && this.fluid == fluidStack.getFluid();
    }

    public void onFluidChange(BiConsumer<Fluid, Fluid> callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        super.serNBT(tag);
        if (!this.locked) {
            if (this.fluid == null) {
                tag.func_74757_a("NoFluid", true);
            } else {
                tag.func_74778_a("Fluid", this.fluid.getName());
            }
        }
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        super.deserNBT(tag);
        if (!this.locked) {
            this.fluid = tag.func_74764_b("NoFluid") ? null : FluidRegistry.getFluid((String)tag.func_74779_i("Fluid"));
        }
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        super.serBytes(data);
        if (!this.locked) {
            if (this.fluid == null) {
                data.writeByte((byte)0);
            } else {
                data.writeFluid(this.fluid);
            }
        }
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        super.deserBytes(data);
        if (!this.locked) {
            if (data.readByte() != 0) {
                data.backUp(1);
                this.setFluid(data.readFluid());
            } else {
                this.setFluid(null);
            }
        }
    }
}

