/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.capability.impl;

import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import io.github.phantamanta44.libnine.util.function.IInventoryObserver;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class L9AspectInventory
implements IItemHandlerModifiable,
ISerializable {
    private final ItemStack[] inv;
    private final Predicate<ItemStack>[] preds;

    public L9AspectInventory(int size) {
        this.inv = new ItemStack[size];
        Arrays.fill(this.inv, ItemStack.field_190927_a);
        this.preds = new Predicate[size];
    }

    public L9AspectInventory withPredicate(int slot, Predicate<ItemStack> pred) {
        this.preds[slot] = pred;
        return this;
    }

    public int getSlots() {
        return this.inv.length;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inv[slot];
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inv[slot] = stack;
        int slotLimit = this.getSlotLimit(slot);
        if (stack.func_190916_E() > slotLimit) {
            stack.func_190920_e(slotLimit);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.preds[slot] != null && !this.preds[slot].test(stack)) {
            return stack;
        }
        if (this.getStackInSlot(slot).func_190926_b()) {
            int toTransfer = Math.min(stack.func_190916_E(), this.getSlotLimit(slot));
            if (!simulate) {
                this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)toTransfer));
            }
            return toTransfer == stack.func_190916_E() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - toTransfer));
        }
        int maxStackSize = Math.min(this.getStackInSlot(slot).func_77976_d(), this.getSlotLimit(slot));
        if (this.getStackInSlot(slot).func_190916_E() >= maxStackSize || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(slot), (ItemStack)stack)) {
            return stack;
        }
        int toTransfer = Math.min(stack.func_190916_E(), maxStackSize - this.getStackInSlot(slot).func_190916_E());
        if (!simulate) {
            this.getStackInSlot(slot).func_190917_f(toTransfer);
        }
        return toTransfer == stack.func_190916_E() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - toTransfer));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || this.getStackInSlot(slot).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toTransfer = Math.min(amount, this.getStackInSlot(slot).func_190916_E());
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStackInSlot(slot), (int)toTransfer);
        if (!simulate) {
            if (this.getStackInSlot(slot).func_190916_E() == toTransfer) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            } else {
                this.getStackInSlot(slot).func_190918_g(toTransfer);
            }
        }
        return result;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.inv) {
            NBTTagCompound itemTag = new NBTTagCompound();
            if (stack.func_190926_b()) {
                itemTag.func_74757_a("Empty", true);
            } else {
                stack.func_77955_b(itemTag);
            }
            list.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Items", 10);
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            this.setStackInSlot(i, itemTag.func_74764_b("Empty") ? ItemStack.field_190927_a : new ItemStack(itemTag));
        }
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        for (ItemStack stack : this.inv) {
            if (stack.func_190926_b()) {
                data.writeShort((short)-1);
                continue;
            }
            data.writeItemStack(stack);
        }
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        for (int i = 0; i < this.inv.length; ++i) {
            if (data.readShort() == -1) {
                this.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            this.setStackInSlot(i, data.backUp(2).readItemStack());
        }
    }

    public static class Observable
    extends L9AspectInventory {
        private final IInventoryObserver observer;

        public Observable(int size, IInventoryObserver observer) {
            super(size);
            this.observer = observer;
        }

        @Override
        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            ItemStack original = this.getStackInSlot(slot).func_77946_l();
            super.setStackInSlot(slot, stack);
            this.observer.onSlotChanged(slot, original, this.getStackInSlot(slot));
        }

        @Override
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (simulate) {
                return super.insertItem(slot, stack, true);
            }
            ItemStack original = this.getStackInSlot(slot).func_77946_l();
            ItemStack result = super.insertItem(slot, stack, false);
            this.observer.onSlotChanged(slot, original, this.getStackInSlot(slot));
            return result;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (simulate) {
                return super.extractItem(slot, amount, true);
            }
            ItemStack original = this.getStackInSlot(slot).func_77946_l();
            ItemStack result = super.extractItem(slot, amount, false);
            this.observer.onSlotChanged(slot, original, this.getStackInSlot(slot));
            return result;
        }
    }
}

