/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.capability.impl;

import io.github.phantamanta44.libnine.component.reservoir.FluidReservoir;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class L9AspectFluidHandler
implements IFluidHandler,
ISerializable {
    private final FluidReservoir[] tanks;

    public L9AspectFluidHandler(FluidReservoir mainTank, FluidReservoir ... secondaryTanks) {
        this.tanks = new FluidReservoir[secondaryTanks.length + 1];
        this.tanks[0] = mainTank;
        System.arraycopy(secondaryTanks, 0, this.tanks, 1, secondaryTanks.length);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tanks;
    }

    public int fill(FluidStack resource, boolean doFill) {
        for (FluidReservoir tank : this.tanks) {
            if (!tank.canFillFluidType(resource)) continue;
            tank.setFluid(resource.getFluid());
            return tank.offer(resource.amount, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        for (FluidReservoir tank : this.tanks) {
            if (!tank.canDrainFluidType(resource) || !tank.hasFluid()) continue;
            return new FluidStack(tank.getFluid(), tank.draw(resource.amount, doDrain));
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (FluidReservoir tank : this.tanks) {
            if (!tank.canDrain() || !tank.hasFluid()) continue;
            return new FluidStack(tank.getFluid(), tank.draw(maxDrain, doDrain));
        }
        return null;
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (FluidReservoir tank : this.tanks) {
            NBTTagCompound tankTag = new NBTTagCompound();
            tank.serNBT(tankTag);
            list.func_74742_a((NBTBase)tankTag);
        }
        tag.func_74782_a("Tanks", (NBTBase)list);
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Tanks", 10);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserNBT(list.func_150305_b(i));
        }
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        for (FluidReservoir tank : this.tanks) {
            tank.serBytes(data);
        }
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        for (FluidReservoir tank : this.tanks) {
            tank.deserBytes(data);
        }
    }
}

