/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen.biome;

import java.util.List;
import java.util.Random;
import nc.entity.EntityFeralGhoul;
import nc.init.NCBlocks;
import nc.worldgen.biome.BiomeDecoratorNuclearWasteland;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeNuclearWasteland
extends Biome {
    public static final String BIOME_REGISTRY_NAME = "nuclear_wasteland";
    public static final String BIOME_NAME = "Nuclear Wasteland";
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();

    public BiomeNuclearWasteland() {
        super(new Biome.BiomeProperties(BIOME_NAME).func_185398_c(0.12f).func_185400_d(0.02f).func_185410_a(2.0f).func_185402_a(10046464).func_185396_a());
        this.field_76752_A = NCBlocks.dry_earth.func_176223_P();
        this.field_76753_B = Blocks.field_150354_m.func_176223_P();
        this.field_76760_I = this.func_76729_a();
        this.setSpawnables();
        this.addFlowers();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 10330225;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(10046464);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(10046464);
    }

    public BiomeDecorator func_76729_a() {
        BiomeDecoratorNuclearWasteland biomeDecorator = new BiomeDecoratorNuclearWasteland();
        biomeDecorator.field_76833_y = 0;
        biomeDecorator.field_76832_z = 0;
        biomeDecorator.field_189870_A = 0.0f;
        biomeDecorator.field_76802_A = 20;
        biomeDecorator.field_76803_B = 3;
        biomeDecorator.field_76804_C = 2;
        biomeDecorator.field_76798_D = 0;
        biomeDecorator.field_76799_E = 0;
        biomeDecorator.field_76800_F = 0;
        biomeDecorator.field_76801_G = 2;
        biomeDecorator.field_76805_H = 2;
        biomeDecorator.field_76806_I = 0;
        biomeDecorator.field_76807_J = 0;
        biomeDecorator.field_76808_K = false;
        return this.getModdedBiomeDecorator(biomeDecorator);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return field_76757_N;
    }

    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenTallGrass(BlockTallGrass.EnumType.DEAD_BUSH);
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        return BlockFlower.EnumFlowerType.DANDELION;
    }

    public List<Biome.FlowerEntry> getFlowerList() {
        return this.flowers;
    }

    private void addFlowers() {
        this.flowers.clear();
        this.addFlower(NCBlocks.glowing_mushroom.func_176223_P(), 10);
    }

    private void setSpawnables() {
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityFeralGhoul.class, Short.MAX_VALUE, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityFeralGhoul.class, Short.MAX_VALUE, 1, 2));
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        this.field_76760_I.func_180292_a(worldIn, rand, (Biome)this, pos);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int seaLevel = worldIn.func_181545_F();
        IBlockState topBlockState = this.field_76752_A;
        IBlockState fillerBlockState = this.field_76753_B;
        int heightCount = -1;
        int noise = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int chunkPosX = x & 0xF;
        int chunkPosZ = z & 0xF;
        BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
        for (int posY = 255; posY >= 0; --posY) {
            if (posY <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, BEDROCK);
                continue;
            }
            IBlockState currentBlockState = chunkPrimerIn.func_177856_a(chunkPosX, posY, chunkPosZ);
            if (currentBlockState.func_185904_a() == Material.field_151579_a) {
                heightCount = -1;
                continue;
            }
            if (currentBlockState.func_177230_c() != Blocks.field_150348_b) continue;
            if (heightCount == -1) {
                if (noise <= 0) {
                    topBlockState = field_185366_b;
                    fillerBlockState = field_185365_a;
                } else if (posY >= seaLevel - 4 && posY <= seaLevel + 1) {
                    topBlockState = this.field_76752_A;
                    fillerBlockState = this.field_76753_B;
                }
                if (posY < seaLevel && (topBlockState == null || topBlockState.func_185904_a() == Material.field_151579_a)) {
                    topBlockState = this.func_180626_a((BlockPos)mutableblockpos.func_181079_c(x, posY, z)) < 0.15f ? field_185371_g : field_185372_h;
                }
                heightCount = noise;
                if (posY >= seaLevel - 1) {
                    chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, topBlockState);
                    continue;
                }
                if (posY < seaLevel - 7 - noise) {
                    topBlockState = field_185366_b;
                    fillerBlockState = field_185365_a;
                    chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, field_185368_d);
                    continue;
                }
                chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, fillerBlockState);
                continue;
            }
            if (heightCount <= 0) continue;
            chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, fillerBlockState);
            if (--heightCount != 0 || fillerBlockState != this.field_76753_B || noise <= 1) continue;
            heightCount = rand.nextInt(4) + Math.max(0, posY - 63);
            fillerBlockState = this.field_76752_A;
        }
    }
}

