/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.IGalaxy;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.util.XMLOreLoader;

public class XMLPlanetLoader {
    private static final String ATTR_TEMP = "temp";
    private static final String GENERATEGEODES = "generateGeodes";
    private static final String GENERATESTRUCTURES = "generateStructures";
    private static final String GENERATEVOLCANOS = "generateVolcanos";
    private static final String GENERATECRATERS = "generateCraters";
    private static final String ELEMENT_GALAXY = "galaxy";
    private static final String ELEMENT_STAR = "star";
    private static final String ELEMENT_PLANET = "planet";
    private static final String ATTR_BLACKHOLE = "blackHole";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_X = "x";
    private static final String ATTR_Y = "y";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NUMPLANETS = "numPlanets";
    private static final String ATTR_NUMGASPLANETS = "numGasGiants";
    private static final String ATTR_SEPERATION = "separation";
    private static final String ATTR_DIMID = "DIMID";
    private static final String ATTR_NATIVEDIM = "dimMapping";
    private static final String ATTR_ICON = "customIcon";
    private static final String ELEMENT_ISKNOWN = "isKnown";
    private static final String ELEMENT_HASRINGS = "hasRings";
    private static final String ELEMENT_RINGCOLOR = "ringColor";
    private static final String ELEMENT_GASGIANT = "GasGiant";
    private static final String ELEMENT_GAS = "gas";
    private static final String ELEMENT_FOGCOLOR = "fogColor";
    private static final String ELEMENT_SKYCOLOR = "skyColor";
    private static final String ELEMENT_GRAVITY = "gravitationalMultiplier";
    private static final String ELEMENT_DISTANCE = "orbitalDistance";
    private static final String ELEMENT_PHI = "orbitalPhi";
    private static final String AVG_TEMPERATURE = "avgTemperature";
    private static final String ELEMENT_PERIOD = "rotationalPeriod";
    private static final String ELEMENT_ATMDENSITY = "atmosphereDensity";
    private static final String ELEMENT_SEALEVEL = "seaLevel";
    private static final String ELEMENT_GENTYPE = "genType";
    private static final String ELEMENT_OREGEN = "oreGen";
    private static final String ELEMENT_BIOMEIDS = "biomeIds";
    private static final String ELEMENT_ARTIFACT = "artifact";
    private static final String ELEMENT_OCEANBLOCK = "oceanBlock";
    private static final String ELEMENT_FILLERBLOCK = "fillerBlock";
    private static final String ELEMENT_SPAWNABLE = "spawnable";
    private static final String ELEMENT_CRATER_MULTIPLIER = "craterFrequencyMultiplier";
    private static final String ELEMENT_VOLCANO_MULTIPLIER = "volcanoFrequencyMultiplier";
    private static final String ELEMENT_GEODE_MULTIPLIER = "geodefrequencyMultiplier";
    private static final String ELEMENT_CAN_DECORATE = "hasShading";
    private static final String ATTR_WEIGHT = "weight";
    private static final String ATTR_GROUPMIN = "groupMin";
    private static final String ATTR_GROUPMAX = "groupMax";
    private static final String ATTR_NBT = "nbt";
    Document doc = null;
    NodeList currentList;
    int currentNodeIndex = -1;
    int starId = 0;
    int offset;
    HashMap<StellarBody, Integer> maxPlanetNumber = new HashMap();
    HashMap<StellarBody, Integer> maxGasPlanetNumber = new HashMap();

    public boolean loadFile(File xmlFile) throws IOException {
        DocumentBuilder docBuilder;
        this.doc = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        try {
            this.doc = docBuilder.parse(xmlFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.doc != null;
    }

    public int getMaxNumPlanets(StellarBody body) {
        if (!this.maxPlanetNumber.containsKey(body)) {
            AdvancedRocketry.logger.warn("Star ID " + body.getId() + " has no entry for numPlanets");
            return 0;
        }
        return this.maxPlanetNumber.get(body);
    }

    public int getMaxNumGasGiants(StellarBody body) {
        if (!this.maxGasPlanetNumber.containsKey(body)) {
            AdvancedRocketry.logger.warn("Star ID " + body.getId() + " has no entry for numGasGiants");
            return 0;
        }
        return this.maxGasPlanetNumber.get(body);
    }

    private List<DimensionProperties> readPlanetFromNode(Node planetNode, StellarBody star) {
        ArrayList<DimensionProperties> list = new ArrayList<DimensionProperties>();
        Node planetPropertyNode = planetNode.getFirstChild();
        DimensionProperties properties = new DimensionProperties(DimensionManager.getInstance().getNextFreeDim(this.offset));
        list.add(properties);
        ++this.offset;
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem(ATTR_NAME);
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                properties.setName(nameNode.getNodeValue());
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem(ATTR_DIMID)) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    if (nameNode.getTextContent().isEmpty()) {
                        throw new NumberFormatException();
                    }
                    properties.setId(Integer.parseInt(nameNode.getTextContent()));
                    --this.offset;
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Invalid DIMID specified for planet " + properties.getName());
                    list.remove(properties);
                    --this.offset;
                    return list;
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem(ATTR_NATIVEDIM)) != null) {
                properties.isNativeDimension = false;
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem(ATTR_ICON)) != null) {
                properties.customIcon = nameNode.getTextContent();
            }
        }
        while (planetPropertyNode != null) {
            block148: {
                String text;
                String blockName;
                String[] colors;
                if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_FOGCOLOR)) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (int j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.fogColor = rgb;
                            break block148;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.fogColor = rgb;
                            break block148;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for fog color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid fog color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_GAS)) {
                    Fluid f = FluidRegistry.getFluid((String)planetPropertyNode.getTextContent());
                    if (f == null) {
                        AdvancedRocketry.logger.warn("\"" + planetPropertyNode.getTextContent() + "\" is not a valid fluid");
                    } else {
                        properties.getHarvestableGasses().add(f);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_OCEANBLOCK)) {
                    blockName = planetPropertyNode.getTextContent();
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
                    if (block == Blocks.field_150350_a) {
                        AdvancedRocketry.logger.warn("Invalid ocean block: " + blockName);
                    }
                    properties.setOceanBlock(block.func_176223_P());
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_FILLERBLOCK)) {
                    blockName = planetPropertyNode.getTextContent();
                    String[] splitBlockName = blockName.split(":");
                    if (splitBlockName.length < 2) {
                        AdvancedRocketry.logger.warn("Invalid resource location for fillerBlock: " + blockName);
                    } else {
                        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(splitBlockName[0], splitBlockName[1]));
                        int metaValue = 0;
                        if (splitBlockName.length > 2) {
                            try {
                                metaValue = Integer.parseInt(splitBlockName[2]);
                            }
                            catch (NumberFormatException e) {
                                AdvancedRocketry.logger.warn("Invalid meta value location for fillerBlock: " + blockName + " using " + splitBlockName[2]);
                            }
                        }
                        if (block == Blocks.field_150350_a) {
                            AdvancedRocketry.logger.warn("Invalid filler block: " + blockName);
                        }
                        properties.setStoneBlock(block.func_176203_a(metaValue));
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_SKYCOLOR)) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (int j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.skyColor = rgb;
                            break block148;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.skyColor = rgb;
                            break block148;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for sky color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid sky color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_ATMDENSITY)) {
                    try {
                        properties.setAtmosphereDensityDirect(Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 0), 1600));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid atmosphereDensity specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_GRAVITY)) {
                    try {
                        properties.gravitationalMultiplier = (float)Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 0), 400) / 100.0f;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid gravitationalMultiplier specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_DISTANCE)) {
                    try {
                        properties.orbitalDist = Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 1), Integer.MAX_VALUE);
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalDist specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("orbitaltheta")) {
                    try {
                        properties.baseOrbitTheta = (double)(Integer.parseInt(planetPropertyNode.getTextContent()) % 360) * Math.PI / 180.0;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalTheta specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_PERIOD)) {
                    try {
                        int rotationalPeriod = Integer.parseInt(planetPropertyNode.getTextContent());
                        if (rotationalPeriod > 0) {
                            properties.rotationalPeriod = rotationalPeriod;
                            break block148;
                        }
                        AdvancedRocketry.logger.warn("rotational Period must be greater than 0 for dimension " + properties.getId());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid rotational period specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_SEALEVEL)) {
                    try {
                        properties.setSeaLevel(Integer.parseInt(planetPropertyNode.getTextContent()));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid sealeve specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_BIOMEIDS)) {
                    String[] biomeList = planetPropertyNode.getTextContent().split(",");
                    for (int j = 0; j < biomeList.length; ++j) {
                        ResourceLocation location = new ResourceLocation(biomeList[j]);
                        if (Biome.field_185377_q.func_148741_d((Object)location)) {
                            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)location);
                            if (biome != null && properties.addBiome(Biome.func_185362_a((Biome)biome))) continue;
                            AdvancedRocketry.logger.warn("Error adding " + biomeList[j]);
                            continue;
                        }
                        try {
                            int biome = Integer.parseInt(biomeList[j]);
                            if (properties.addBiome(biome)) continue;
                            AdvancedRocketry.logger.warn(biomeList[j] + " is not a valid biome id");
                            continue;
                        }
                        catch (NumberFormatException e) {
                            AdvancedRocketry.logger.warn(biomeList[j] + " is not a valid biome id or name");
                        }
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_SPAWNABLE)) {
                    Class<?> clazz;
                    int weight = 100;
                    int groupMin = 1;
                    int groupMax = 1;
                    String nbtString = "";
                    Node weightNode = planetPropertyNode.getAttributes().getNamedItem(ATTR_WEIGHT);
                    Node groupMinNode = planetPropertyNode.getAttributes().getNamedItem(ATTR_GROUPMIN);
                    Node groupMaxNode = planetPropertyNode.getAttributes().getNamedItem(ATTR_GROUPMIN);
                    Node nbtNode = planetPropertyNode.getAttributes().getNamedItem(ATTR_NBT);
                    if (weightNode != null) {
                        try {
                            weight = Integer.parseInt(weightNode.getTextContent());
                            weight = Math.max(1, weight);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (groupMinNode != null) {
                        try {
                            groupMin = Integer.parseInt(groupMinNode.getTextContent());
                            groupMin = Math.max(1, groupMin);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (groupMaxNode != null) {
                        try {
                            groupMax = Integer.parseInt(groupMaxNode.getTextContent());
                            groupMax = Math.max(1, groupMax);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (nbtNode != null) {
                        nbtString = nbtNode.getTextContent();
                    }
                    if (groupMax < groupMin) {
                        groupMax = groupMin;
                    }
                    if ((clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(planetPropertyNode.getTextContent()))) == null) {
                        try {
                            clazz = Class.forName(planetPropertyNode.getTextContent());
                            if (clazz != null && !Entity.class.isAssignableFrom(clazz)) {
                                clazz = null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (clazz != null) {
                        SpawnListEntryNBT entry = new SpawnListEntryNBT(clazz, weight, groupMin, groupMax);
                        if (!nbtString.isEmpty()) {
                            try {
                                entry.setNbt(nbtString);
                            }
                            catch (DOMException e) {
                                AdvancedRocketry.logger.fatal("===== Configuration Error!  Please check your save's planetDefs.xml config file =====\n" + e.getLocalizedMessage() + "\nThe following is not valid JSON:\n" + nbtString);
                            }
                            catch (NBTException e) {
                                AdvancedRocketry.logger.fatal("===== Configuration Error!  Please check your save's planetDefs.xml config file =====\n" + e.getLocalizedMessage() + "\nThe following is not valid NBT data:\n" + nbtString);
                            }
                        }
                        properties.getSpawnListEntries().add(entry);
                    } else {
                        AdvancedRocketry.logger.warn("Cannot find " + planetPropertyNode.getTextContent() + " while registering entity for planet spawn");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_ARTIFACT)) {
                    ItemStack stack = XMLPlanetLoader.getStack(planetPropertyNode.getTextContent());
                    if (stack != null) {
                        properties.getRequiredArtifacts().add(stack);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_PLANET)) {
                    List<DimensionProperties> childList = this.readPlanetFromNode(planetPropertyNode, star);
                    if (childList.size() > 0) {
                        DimensionProperties child = childList.get(0);
                        properties.addChildPlanet(child);
                        list.addAll(childList);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_PHI)) {
                    try {
                        properties.orbitalPhi = Integer.parseInt(planetPropertyNode.getTextContent()) % 360;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalPhi specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_OREGEN)) {
                    properties.oreProperties = XMLOreLoader.loadOre(planetPropertyNode);
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_GENTYPE)) {
                    try {
                        properties.setGenType(Integer.parseInt(planetPropertyNode.getTextContent()));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid generator type specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_HASRINGS)) {
                    properties.hasRings = Boolean.parseBoolean(planetPropertyNode.getTextContent());
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_CAN_DECORATE)) {
                    properties.setDecoratoration(Boolean.parseBoolean(planetPropertyNode.getTextContent()));
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_RINGCOLOR)) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (int j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.ringColor = rgb;
                            break block148;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.ringColor = rgb;
                            break block148;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for ring color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid sky color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_GASGIANT)) {
                    text = planetPropertyNode.getTextContent();
                    if (text != null && !text.isEmpty() && text.equalsIgnoreCase("true")) {
                        properties.setGasGiant(true);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_ISKNOWN)) {
                    text = planetPropertyNode.getTextContent();
                    if (text != null && !text.isEmpty() && text.equalsIgnoreCase("true")) {
                        ARConfiguration.getCurrentConfig().initiallyKnownPlanets.add(properties.getId());
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(GENERATECRATERS)) {
                    text = planetPropertyNode.getTextContent();
                    if (text != null && !text.isEmpty()) {
                        properties.setGenerateCraters(text.equalsIgnoreCase("true"));
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_CRATER_MULTIPLIER)) {
                    try {
                        properties.setCraterMultiplier(Float.parseFloat(planetPropertyNode.getTextContent()));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid crater multiplier specified, must be a number");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_VOLCANO_MULTIPLIER)) {
                    try {
                        properties.setVolcanoMultiplier(Float.parseFloat(planetPropertyNode.getTextContent()));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid volcano multiplier specified, must be a number");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(ELEMENT_GEODE_MULTIPLIER)) {
                    try {
                        properties.setGeodeMultiplier(Float.parseFloat(planetPropertyNode.getTextContent()));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid geode multiplier specified, must be a number");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(GENERATEGEODES)) {
                    text = planetPropertyNode.getTextContent();
                    if (text != null && !text.isEmpty()) {
                        properties.setGenerateGeodes(text.equalsIgnoreCase("true"));
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(GENERATEVOLCANOS)) {
                    text = planetPropertyNode.getTextContent();
                    if (text != null && !text.isEmpty()) {
                        properties.setGenerateVolcanos(text.equalsIgnoreCase("true"));
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase(GENERATESTRUCTURES) && (text = planetPropertyNode.getTextContent()) != null && !text.isEmpty()) {
                    properties.setGenerateStructures(text.equalsIgnoreCase("true"));
                }
            }
            planetPropertyNode = planetPropertyNode.getNextSibling();
        }
        properties.setStar(star.getId());
        properties.averageTemperature = AstronomicalBodyHelper.getAverageTemperature(star, properties.getOrbitalDist(), properties.getAtmosphereDensity());
        if (properties.getBiomes().isEmpty()) {
            properties.addBiomes(properties.getViableBiomes());
        }
        return list;
    }

    public StellarBody readStar(Node planetNode) {
        StellarBody star = this.readSubStar(planetNode);
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem(ATTR_X);
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setPosX(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem(ATTR_Y)) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setPosZ(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            nameNode = planetNode.getAttributes().getNamedItem(ATTR_NUMPLANETS);
            try {
                this.maxPlanetNumber.put(star, Integer.parseInt(nameNode.getNodeValue()));
            }
            catch (Exception e) {
                AdvancedRocketry.logger.warn("Invalid number of planets specified in xml config!");
            }
            nameNode = planetNode.getAttributes().getNamedItem(ATTR_NUMGASPLANETS);
            try {
                this.maxGasPlanetNumber.put(star, Integer.parseInt(nameNode.getNodeValue()));
            }
            catch (Exception e) {
                AdvancedRocketry.logger.warn("Invalid number of planets specified in xml config!");
            }
            nameNode = planetNode.getAttributes().getNamedItem(ATTR_BLACKHOLE);
            if (nameNode != null && nameNode.getNodeValue().equalsIgnoreCase("true")) {
                star.setBlackHole(true);
            }
        }
        star.setId(this.starId++);
        return star;
    }

    public StellarBody readSubStar(Node planetNode) {
        StellarBody star = new StellarBody();
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem(ATTR_NAME);
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                star.setName(nameNode.getNodeValue());
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem(ATTR_TEMP)) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setTemperature(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem(ATTR_SIZE)) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setSize(Float.parseFloat(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem(ATTR_BLACKHOLE)) != null && nameNode.getNodeValue().equalsIgnoreCase("true")) {
                star.setBlackHole(true);
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem(ATTR_SEPERATION)) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setStarSeparation(Float.parseFloat(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
        }
        return star;
    }

    public DimensionPropertyCoupling readAllPlanets() {
        DimensionPropertyCoupling coupling = new DimensionPropertyCoupling();
        Node masterNode = this.doc.getElementsByTagName(ELEMENT_GALAXY).item(0).getFirstChild();
        this.offset = DimensionManager.dimOffset;
        while (masterNode != null) {
            if (!masterNode.getNodeName().equals(ELEMENT_STAR)) {
                masterNode = masterNode.getNextSibling();
                continue;
            }
            StellarBody star = this.readStar(masterNode);
            coupling.stars.add(star);
            NodeList planetNodeList = masterNode.getChildNodes();
            for (Node planetNode = planetNodeList.item(0); planetNode != null; planetNode = planetNode.getNextSibling()) {
                if (planetNode.getNodeName().equalsIgnoreCase(ELEMENT_PLANET)) {
                    coupling.dims.addAll(this.readPlanetFromNode(planetNode, star));
                }
                if (!planetNode.getNodeName().equalsIgnoreCase(ELEMENT_STAR)) continue;
                StellarBody star2 = this.readSubStar(planetNode);
                star.addSubStar(star2);
            }
            masterNode = masterNode.getNextSibling();
        }
        return coupling;
    }

    public static String writeXML(IGalaxy galaxy) {
        Transformer transformer;
        DocumentBuilder docBuilder;
        Document doc = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return "";
        }
        doc = docBuilder.newDocument();
        Element galaxyElement = doc.createElement(ELEMENT_GALAXY);
        doc.appendChild(galaxyElement);
        Collection<StellarBody> stars = galaxy.getStars();
        for (StellarBody star : stars) {
            Element nodeStar = doc.createElement(ELEMENT_STAR);
            nodeStar.setAttribute(ATTR_BLACKHOLE, Boolean.toString(star.isBlackHole()));
            nodeStar.setAttribute(ATTR_NAME, star.getName());
            nodeStar.setAttribute(ATTR_TEMP, Integer.toString(star.getTemperature()));
            nodeStar.setAttribute(ATTR_X, Integer.toString(star.getPosX()));
            nodeStar.setAttribute(ATTR_Y, Integer.toString(star.getPosZ()));
            nodeStar.setAttribute(ATTR_SIZE, Float.toString(star.getSize()));
            nodeStar.setAttribute(ATTR_NUMPLANETS, "0");
            nodeStar.setAttribute(ATTR_NUMGASPLANETS, "0");
            for (StellarBody star2 : star.getSubStars()) {
                Element nodeSubStar = doc.createElement(ELEMENT_STAR);
                nodeSubStar.setAttribute(ATTR_BLACKHOLE, Boolean.toString(star2.isBlackHole()));
                nodeSubStar.setAttribute(ATTR_TEMP, Integer.toString(star.getTemperature()));
                nodeSubStar.setAttribute(ATTR_SIZE, Float.toString(star.getSize()));
                nodeSubStar.setAttribute(ATTR_SEPERATION, Float.toString(star.getStarSeparation()));
                nodeStar.appendChild(nodeSubStar);
            }
            for (IDimensionProperties properties : star.getPlanets()) {
                if (properties.isMoon()) continue;
                nodeStar.appendChild(XMLPlanetLoader.writePlanet(doc, (DimensionProperties)properties));
            }
            galaxyElement.appendChild(nodeStar);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            return "";
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(stream);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return "";
        }
        return ((Object)stream).toString();
    }

    private static Node createTextNode(Document doc, String nodeName, double nodeText) {
        return XMLPlanetLoader.createTextNode(doc, nodeName, Double.toString(nodeText));
    }

    private static Node createTextNode(Document doc, String nodeName, boolean nodeText) {
        return XMLPlanetLoader.createTextNode(doc, nodeName, Boolean.toString(nodeText));
    }

    private static Node createTextNode(Document doc, String nodeName, int nodeText) {
        return XMLPlanetLoader.createTextNode(doc, nodeName, Integer.toString(nodeText));
    }

    private static Node createTextNode(Document doc, String nodeName, String nodeText) {
        Element element = doc.createElement(nodeName);
        element.appendChild(doc.createTextNode(nodeText));
        return element;
    }

    private static Node writePlanet(Document doc, DimensionProperties properties) {
        Element nodePlanet = doc.createElement(ELEMENT_PLANET);
        nodePlanet.setAttribute(ATTR_NAME, properties.getName());
        nodePlanet.setAttribute(ATTR_DIMID, Integer.toString(properties.getId()));
        if (!properties.isNativeDimension) {
            nodePlanet.setAttribute(ATTR_NATIVEDIM, "");
        }
        if (!properties.customIcon.isEmpty()) {
            nodePlanet.setAttribute(ATTR_ICON, properties.customIcon);
        }
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_ISKNOWN, Boolean.toString(ARConfiguration.getCurrentConfig().initiallyKnownPlanets.contains(properties.getId()))));
        if (properties.hasRings) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_HASRINGS, "true"));
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_RINGCOLOR, properties.ringColor[0] + "," + properties.ringColor[1] + "," + properties.ringColor[2]));
        }
        if (properties.isGasGiant()) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_GASGIANT, "true"));
            if (!properties.getHarvestableGasses().isEmpty()) {
                for (Fluid fluid : properties.getHarvestableGasses()) {
                    nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_GAS, fluid.getName()));
                }
            }
        }
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_FOGCOLOR, properties.fogColor[0] + "," + properties.fogColor[1] + "," + properties.fogColor[2]));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_SKYCOLOR, properties.skyColor[0] + "," + properties.skyColor[1] + "," + properties.skyColor[2]));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_GRAVITY, (int)(properties.getGravitationalMultiplier() * 100.0f)));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_DISTANCE, properties.getOrbitalDist()));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_PHI, (int)properties.orbitalPhi));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, AVG_TEMPERATURE, properties.averageTemperature));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_PERIOD, properties.rotationalPeriod));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_ATMDENSITY, properties.getAtmosphereDensity()));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, GENERATECRATERS, properties.canGenerateCraters()));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, GENERATEVOLCANOS, properties.canGenerateVolcanos()));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, GENERATESTRUCTURES, properties.canGenerateStructures()));
        nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, GENERATEGEODES, properties.canGenerateGeodes()));
        if (properties.canGenerateCraters() && properties.getCraterMultiplier() == 1.0f) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_CRATER_MULTIPLIER, properties.getCraterMultiplier()));
        }
        if (properties.canGenerateVolcanos() && properties.getVolcanoMultiplier() == 1.0f) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_VOLCANO_MULTIPLIER, properties.getVolcanoMultiplier()));
        }
        if (properties.canGenerateGeodes() && properties.getGeodeMultiplier() == 1.0f) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_GEODE_MULTIPLIER, properties.getGeodeMultiplier()));
        }
        if (properties.getSeaLevel() != 63) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_SEALEVEL, properties.getSeaLevel()));
        }
        if (properties.getGenType() != 0) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_GENTYPE, properties.getGenType()));
        }
        if (properties.oreProperties != null) {
            nodePlanet.appendChild(XMLOreLoader.writeOreEntryXML(doc, properties.oreProperties));
        }
        if (properties.isDecorationOverridden()) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_CAN_DECORATE, properties.hasDecorators()));
        }
        if (properties.isNativeDimension && !properties.isGasGiant()) {
            Object biomeIds = "";
            for (BiomeManager.BiomeEntry biome : properties.getBiomes()) {
                try {
                    biomeIds = (String)biomeIds + "," + ((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome.biome)).toString();
                }
                catch (NullPointerException e) {
                    AdvancedRocketry.logger.warn("Error saving biomes for world, biomes list saved may be incomplete.  World: " + properties.getId());
                }
            }
            if (!((String)biomeIds).isEmpty()) {
                biomeIds = ((String)biomeIds).substring(1);
            } else {
                AdvancedRocketry.logger.warn("Dim " + properties.getId() + " has no biomes to save!");
            }
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_BIOMEIDS, (String)biomeIds));
        }
        for (ItemStack itemStack : properties.getRequiredArtifacts()) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_ARTIFACT, itemStack.func_77973_b().getRegistryName() + " " + itemStack.func_77952_i() + " " + itemStack.func_190916_E()));
        }
        for (Integer n : properties.getChildPlanets()) {
            nodePlanet.appendChild(XMLPlanetLoader.writePlanet(doc, DimensionManager.getInstance().getDimensionProperties(n)));
        }
        if (properties.getOceanBlock() != null) {
            nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_OCEANBLOCK, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)properties.getOceanBlock().func_177230_c())).toString()));
        }
        if (properties.getStoneBlock() != null) {
            int meta = properties.getStoneBlock().func_177230_c().func_176201_c(properties.getStoneBlock());
            if (meta != 0) {
                nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_FILLERBLOCK, Block.field_149771_c.func_177774_c((Object)properties.getStoneBlock().func_177230_c()) + ":" + meta));
            } else {
                nodePlanet.appendChild(XMLPlanetLoader.createTextNode(doc, ELEMENT_FILLERBLOCK, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)properties.getStoneBlock().func_177230_c())).toString()));
            }
        }
        for (SpawnListEntryNBT spawnListEntryNBT : properties.getSpawnListEntries()) {
            String nbtString = spawnListEntryNBT.getNBTString();
            if (!nbtString.isEmpty()) {
                nbtString = " nbt=\"" + nbtString.replaceAll("\"", "&quot;") + "\"";
            }
            Element spawnable = doc.createElement(ELEMENT_SPAWNABLE);
            spawnable.setAttribute(ATTR_WEIGHT, Integer.toString(spawnListEntryNBT.field_76292_a));
            spawnable.setAttribute(ATTR_GROUPMIN, Integer.toString(spawnListEntryNBT.field_76301_c));
            spawnable.setAttribute(ATTR_GROUPMAX, Integer.toString(spawnListEntryNBT.field_76299_d));
            spawnable.setAttribute(ATTR_NBT, nbtString.replaceAll("\"", "&quot;"));
            spawnable.appendChild(doc.createTextNode(EntityRegistry.getEntry((Class)spawnListEntryNBT.field_76300_b).getRegistryName().toString()));
            nodePlanet.appendChild(spawnable);
        }
        return nodePlanet;
    }

    public static ItemStack getStack(String text) {
        String[] splitStr = text.split(" ");
        int meta = 0;
        int size = 1;
        if (splitStr.length > 1) {
            try {
                meta = Integer.parseInt(splitStr[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (splitStr.length > 2) {
                try {
                    size = Integer.parseInt(splitStr[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        ItemStack stack = null;
        Block block = Block.func_149684_b((String)splitStr[0]);
        if (block == null) {
            Item item = Item.func_111206_d((String)splitStr[0]);
            if (item != null) {
                stack = new ItemStack(item, size, meta);
            }
        } else {
            stack = new ItemStack(block, size, meta);
        }
        return stack;
    }

    public static class DimensionPropertyCoupling {
        public List<StellarBody> stars = new LinkedList<StellarBody>();
        public List<DimensionProperties> dims = new LinkedList<DimensionProperties>();
    }
}

