/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;

public class AstronomicalBodyHelper {
    public static float getBodySizeMultiplier(float orbitalDistance) {
        return 100.0f / orbitalDistance;
    }

    public static double getOrbitalPeriod(int orbitalDistance, float solarSize) {
        return 48.0 * Math.pow(Math.pow((double)orbitalDistance / 100.0, 3.0) * Math.pow(Math.PI, 2.0) / (Math.pow(solarSize, 3.0) * 10.0), 0.5);
    }

    public static double getOrbitalTheta(int orbitalDistance, float solarSize) {
        double orbitalPeriod = AstronomicalBodyHelper.getOrbitalPeriod(orbitalDistance, solarSize);
        return (double)AdvancedRocketry.proxy.getWorldTimeUniversal(0) % (24000.0 * orbitalPeriod) / (24000.0 * orbitalPeriod) * (Math.PI * 2);
    }

    public static int getAverageTemperature(StellarBody star, int orbitalDistance, int atmPressure) {
        int starSurfaceTemperature = 58 * star.getTemperature();
        float starRadius = star.getSize() / 215.0f;
        float planetaryOrbitalRadius = (float)orbitalDistance / 100.0f;
        double averageWithoutAtmosphere = (double)starSurfaceTemperature * Math.pow(starRadius / (2.0f * planetaryOrbitalRadius), 0.5) * Math.pow(0.7f, 0.25);
        return (int)(averageWithoutAtmosphere * Math.max(1.0, 1.125 * Math.pow(atmPressure / 100, 0.25)));
    }
}

